/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.jdkevents;

import com.oracle.jrockit.jfr.EventToken;
import com.oracle.jrockit.jfr.Producer;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.jfr.events.ErrorThrownEvent;
import jdk.jfr.events.ExceptionThrownEvent;
import jdk.jfr.events.ThrowablesEvent;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.jdkevents.throwabletransform.ConstructorTracerWriter;

public final class ThrowableTracer {
    private static EventToken exceptionThrownToken;
    private static EventToken errorThrownToken;
    private static AtomicLong numThrowables;

    public static void enable(JFR jFR, Producer producer) throws Exception {
        exceptionThrownToken = producer.addEvent(ExceptionThrownEvent.class);
        errorThrownToken = producer.addEvent(ErrorThrownEvent.class);
        producer.addEvent(ThrowablesEvent.class);
    }

    public static void traceError(Error error, String string) {
        if (error instanceof OutOfMemoryError) {
            return;
        }
        ErrorThrownEvent errorThrownEvent = new ErrorThrownEvent(errorThrownToken);
        errorThrownEvent.message = string;
        errorThrownEvent.thrownClass = error.getClass();
        errorThrownEvent.commit();
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent(exceptionThrownToken);
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = error.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    public static void traceThrowable(Throwable throwable, String string) {
        ExceptionThrownEvent exceptionThrownEvent = new ExceptionThrownEvent(exceptionThrownToken);
        exceptionThrownEvent.message = string;
        exceptionThrownEvent.thrownClass = throwable.getClass();
        exceptionThrownEvent.commit();
        numThrowables.incrementAndGet();
    }

    private static byte[] generateAsm(Class<?> clazz) throws Exception {
        String string = "/" + clazz.getName().replace('.', '/') + ".class";
        InputStream inputStream = ThrowableTracer.class.getResourceAsStream(string);
        ClassReader classReader = new ClassReader(inputStream);
        ClassWriter classWriter = new ClassWriter(1);
        ConstructorTracerWriter constructorTracerWriter = new ConstructorTracerWriter(classWriter, clazz);
        classReader.accept(constructorTracerWriter, 0);
        return classWriter.toByteArray();
    }

    public static byte[] generateThrowableAsm() throws Exception {
        return ThrowableTracer.generateAsm(Throwable.class);
    }

    public static byte[] generateErrorAsm() throws Exception {
        return ThrowableTracer.generateAsm(Error.class);
    }

    public static long numThrowables() {
        return numThrowables.get();
    }

    static {
        numThrowables = new AtomicLong(0L);
    }
}

