/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.logging.PlatformLogger;

public final class LocaleServiceProviderPool {
    private static ConcurrentMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool> poolOfPools = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, LocaleServiceProviderPool>();
    private ConcurrentMap<LocaleProviderAdapter.Type, LocaleServiceProvider> providers = new ConcurrentHashMap<LocaleProviderAdapter.Type, LocaleServiceProvider>();
    private ConcurrentMap<Locale, List<LocaleProviderAdapter.Type>> providersCache = new ConcurrentHashMap<Locale, List<LocaleProviderAdapter.Type>>();
    private Set<Locale> availableLocales = null;
    private Class<? extends LocaleServiceProvider> providerClass;
    static final Class<LocaleServiceProvider>[] spiClasses = new Class[]{BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class, CalendarDataProvider.class};
    private static List<LocaleProviderAdapter.Type> NULL_LIST = Collections.emptyList();

    public static LocaleServiceProviderPool getPool(Class<? extends LocaleServiceProvider> clazz) {
        LocaleServiceProviderPool localeServiceProviderPool;
        LocaleServiceProviderPool localeServiceProviderPool2 = (LocaleServiceProviderPool)poolOfPools.get(clazz);
        if (localeServiceProviderPool2 == null && (localeServiceProviderPool2 = poolOfPools.putIfAbsent(clazz, localeServiceProviderPool = new LocaleServiceProviderPool(clazz))) == null) {
            localeServiceProviderPool2 = localeServiceProviderPool;
        }
        return localeServiceProviderPool2;
    }

    private LocaleServiceProviderPool(Class<? extends LocaleServiceProvider> clazz) {
        this.providerClass = clazz;
        for (LocaleProviderAdapter.Type type : LocaleProviderAdapter.getAdapterPreference()) {
            LocaleServiceProvider localeServiceProvider;
            LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.forType(type);
            if (localeProviderAdapter == null || (localeServiceProvider = localeProviderAdapter.getLocaleServiceProvider(clazz)) == null) continue;
            this.providers.putIfAbsent(type, localeServiceProvider);
        }
    }

    static void config(Class<? extends Object> clazz, String string) {
        PlatformLogger platformLogger = PlatformLogger.getLogger(clazz.getCanonicalName());
        platformLogger.config(string);
    }

    public static Locale[] getAllAvailableLocales() {
        return (Locale[])AllAvailableLocales.allAvailableLocales.clone();
    }

    public Locale[] getAvailableLocales() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        hashSet.addAll(this.getAvailableLocaleSet());
        hashSet.addAll(Arrays.asList(LocaleProviderAdapter.forJRE().getAvailableLocales()));
        Locale[] localeArray = new Locale[hashSet.size()];
        hashSet.toArray(localeArray);
        return localeArray;
    }

    private synchronized Set<Locale> getAvailableLocaleSet() {
        if (this.availableLocales == null) {
            this.availableLocales = new HashSet<Locale>();
            for (LocaleServiceProvider localeServiceProvider : this.providers.values()) {
                Locale[] localeArray;
                for (Locale locale : localeArray = localeServiceProvider.getAvailableLocales()) {
                    this.availableLocales.add(LocaleServiceProviderPool.getLookupLocale(locale));
                }
            }
        }
        return this.availableLocales;
    }

    boolean hasProviders() {
        return this.providers.size() != 1 || this.providers.get((Object)LocaleProviderAdapter.Type.JRE) == null && this.providers.get((Object)LocaleProviderAdapter.Type.FALLBACK) == null;
    }

    public <P extends LocaleServiceProvider, S> S getLocalizedObject(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, Object ... objectArray) {
        return this.getLocalizedObjectImpl(localizedObjectGetter, locale, true, null, objectArray);
    }

    public <P extends LocaleServiceProvider, S> S getLocalizedObject(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, String string, Object ... objectArray) {
        return this.getLocalizedObjectImpl(localizedObjectGetter, locale, false, string, objectArray);
    }

    private <P extends LocaleServiceProvider, S> S getLocalizedObjectImpl(LocalizedObjectGetter<P, S> localizedObjectGetter, Locale locale, boolean bl, String string, Object ... objectArray) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (!this.hasProviders()) {
            return localizedObjectGetter.getObject((LocaleServiceProvider)this.providers.get((Object)LocaleProviderAdapter.defaultLocaleProviderAdapter), locale, string, objectArray);
        }
        List<Locale> list = LocaleServiceProviderPool.getLookupLocales(locale);
        Set<Locale> set = this.getAvailableLocaleSet();
        for (Locale locale2 : list) {
            if (!set.contains(locale2)) continue;
            for (LocaleProviderAdapter.Type type : this.findProviders(locale2)) {
                LocaleServiceProvider localeServiceProvider = (LocaleServiceProvider)this.providers.get((Object)type);
                S s = localizedObjectGetter.getObject(localeServiceProvider, locale, string, objectArray);
                if (s != null) {
                    return s;
                }
                if (!bl) continue;
                LocaleServiceProviderPool.config(LocaleServiceProviderPool.class, "A locale sensitive service provider returned null for a localized objects,  which should not happen.  provider: " + localeServiceProvider + " locale: " + locale);
            }
        }
        return null;
    }

    private List<LocaleProviderAdapter.Type> findProviders(Locale locale) {
        List<LocaleProviderAdapter.Type> list = (List<LocaleProviderAdapter.Type>)this.providersCache.get(locale);
        if (list == null) {
            Object object = LocaleProviderAdapter.getAdapterPreference().iterator();
            while (object.hasNext()) {
                LocaleProviderAdapter.Type type = object.next();
                LocaleServiceProvider localeServiceProvider = (LocaleServiceProvider)this.providers.get((Object)type);
                if (localeServiceProvider == null || !localeServiceProvider.isSupportedLocale(locale)) continue;
                if (list == null) {
                    list = new ArrayList<LocaleProviderAdapter.Type>(2);
                }
                list.add(type);
            }
            if (list == null) {
                list = NULL_LIST;
            }
            if ((object = this.providersCache.putIfAbsent(locale, list)) != null) {
                list = object;
            }
        }
        return list;
    }

    static List<Locale> getLookupLocales(Locale locale) {
        List<Locale> list = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", locale);
        return list;
    }

    static Locale getLookupLocale(Locale locale) {
        Locale locale2 = locale;
        if (locale.hasExtensions() && !locale.equals(JRELocaleConstants.JA_JP_JP) && !locale.equals(JRELocaleConstants.TH_TH_TH)) {
            Locale.Builder builder = new Locale.Builder();
            try {
                builder.setLocale(locale);
                builder.clearExtensions();
                locale2 = builder.build();
            }
            catch (IllformedLocaleException illformedLocaleException) {
                LocaleServiceProviderPool.config(LocaleServiceProviderPool.class, "A locale(" + locale + ") has non-empty extensions, but has illformed fields.");
                locale2 = new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
            }
        }
        return locale2;
    }

    private static class AllAvailableLocales {
        static final Locale[] allAvailableLocales;

        private AllAvailableLocales() {
        }

        static {
            HashSet hashSet = new HashSet();
            for (Class<LocaleServiceProvider> clazz : spiClasses) {
                LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(clazz);
                hashSet.addAll(localeServiceProviderPool.getAvailableLocaleSet());
            }
            allAvailableLocales = hashSet.toArray(new Locale[0]);
        }
    }

    public static interface LocalizedObjectGetter<P extends LocaleServiceProvider, S> {
        public S getObject(P var1, Locale var2, String var3, Object ... var4);
    }
}

