/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Arrays;
import sun.security.jca.JCAUtil;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

abstract class DSA
extends SignatureSpi {
    private static final boolean debug = false;
    private DSAParams params;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    private BigInteger presetY;
    private BigInteger presetX;
    private SecureRandom signingRandom;
    private final MessageDigest md;

    DSA(MessageDigest messageDigest) {
        this.md = messageDigest;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        DSAParams dSAParams = dSAPrivateKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("DSA private key lacks parameters");
        }
        this.checkKey(dSAParams);
        this.params = dSAParams;
        this.presetX = dSAPrivateKey.getX();
        this.presetY = null;
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
        this.md.reset();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams == null) {
            throw new InvalidKeyException("DSA public key lacks parameters");
        }
        this.checkKey(dSAParams);
        this.params = dSAParams;
        this.presetY = dSAPublicKey.getY();
        this.presetX = null;
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
        this.md.reset();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.md.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.md.update(byteBuffer);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.generateK(this.presetQ);
        BigInteger bigInteger2 = this.generateR(this.presetP, this.presetQ, this.presetG, bigInteger);
        BigInteger bigInteger3 = this.generateS(this.presetX, this.presetQ, bigInteger2, bigInteger);
        try {
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        Object object;
        Object object2;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        try {
            object2 = new DerInputStream(byArray, n, n2);
            object = ((DerInputStream)object2).getSequence(2);
            bigInteger = object[0].getBigInteger();
            bigInteger2 = object[1].getBigInteger();
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature");
        }
        if (bigInteger.signum() < 0) {
            bigInteger = new BigInteger(1, bigInteger.toByteArray());
        }
        if (bigInteger2.signum() < 0) {
            bigInteger2 = new BigInteger(1, bigInteger2.toByteArray());
        }
        if (bigInteger.compareTo(this.presetQ) == -1 && bigInteger2.compareTo(this.presetQ) == -1) {
            object2 = this.generateW(this.presetP, this.presetQ, this.presetG, bigInteger2);
            object = this.generateV(this.presetY, this.presetP, this.presetQ, this.presetG, (BigInteger)object2, bigInteger);
            return ((BigInteger)object).equals(bigInteger);
        }
        throw new SignatureException("invalid signature: out of range values");
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) {
        throw new InvalidParameterException("No parameter accepted");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void checkKey(DSAParams dSAParams) throws InvalidKeyException {
        int n = dSAParams.getQ().bitLength();
        if (n > this.md.getDigestLength() * 8) {
            throw new InvalidKeyException("Key is too strong for this signature algorithm");
        }
    }

    private BigInteger generateR(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
        return bigInteger5.mod(bigInteger2);
    }

    private BigInteger generateS(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws SignatureException {
        byte[] byArray;
        try {
            byArray = this.md.digest();
        }
        catch (RuntimeException runtimeException) {
            throw new SignatureException(runtimeException.getMessage());
        }
        int n = bigInteger2.bitLength() / 8;
        if (n < byArray.length) {
            byArray = Arrays.copyOfRange(byArray, 0, n);
        }
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger2);
        return bigInteger.multiply(bigInteger3).add(bigInteger5).multiply(bigInteger6).mod(bigInteger2);
    }

    private BigInteger generateW(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger4.modInverse(bigInteger2);
    }

    private BigInteger generateV(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) throws SignatureException {
        byte[] byArray;
        try {
            byArray = this.md.digest();
        }
        catch (RuntimeException runtimeException) {
            throw new SignatureException(runtimeException.getMessage());
        }
        int n = bigInteger3.bitLength() / 8;
        if (n < byArray.length) {
            byArray = Arrays.copyOfRange(byArray, 0, n);
        }
        BigInteger bigInteger7 = new BigInteger(1, byArray);
        BigInteger bigInteger8 = bigInteger7.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger4.modPow(bigInteger8, bigInteger2);
        BigInteger bigInteger11 = bigInteger.modPow(bigInteger9, bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.mod(bigInteger2);
        return bigInteger13.mod(bigInteger3);
    }

    protected BigInteger generateK(BigInteger bigInteger) {
        BigInteger bigInteger2;
        SecureRandom secureRandom = this.getSigningRandom();
        byte[] byArray = new byte[bigInteger.bitLength() / 8];
        do {
            secureRandom.nextBytes(byArray);
        } while ((bigInteger2 = new BigInteger(1, byArray).mod(bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        return bigInteger2;
    }

    protected SecureRandom getSigningRandom() {
        if (this.signingRandom == null) {
            this.signingRandom = this.appRandom != null ? this.appRandom : JCAUtil.getSecureRandom();
        }
        return this.signingRandom;
    }

    public String toString() {
        String string = "DSA Signature";
        if (this.presetP != null && this.presetQ != null && this.presetG != null) {
            string = string + "\n\tp: " + Debug.toHexString(this.presetP);
            string = string + "\n\tq: " + Debug.toHexString(this.presetQ);
            string = string + "\n\tg: " + Debug.toHexString(this.presetG);
        } else {
            string = string + "\n\t P, Q or G not initialized.";
        }
        if (this.presetY != null) {
            string = string + "\n\ty: " + Debug.toHexString(this.presetY);
        }
        if (this.presetY == null && this.presetX == null) {
            string = string + "\n\tUNINIIALIZED";
        }
        return string;
    }

    private static void debug(Exception exception) {
    }

    private static void debug(String string) {
    }

    static class LegacyDSA
    extends DSA {
        private int[] kSeed;
        private byte[] kSeedAsByteArray;
        private int[] kSeedLast;
        private static final int round1_kt = 1518500249;
        private static final int round2_kt = 1859775393;
        private static final int round3_kt = -1894007588;
        private static final int round4_kt = -899497514;

        public LegacyDSA(MessageDigest messageDigest) throws NoSuchAlgorithmException {
            super(messageDigest);
        }

        @Override
        @Deprecated
        protected void engineSetParameter(String string, Object object) {
            if (string.equals("KSEED")) {
                if (!(object instanceof byte[])) {
                    DSA.debug("unrecognized param: " + string);
                    throw new InvalidParameterException("kSeed not a byte array");
                }
            } else {
                throw new InvalidParameterException("Unsupported parameter");
            }
            this.kSeed = this.byteArray2IntArray((byte[])object);
            this.kSeedAsByteArray = (byte[])object;
        }

        @Override
        @Deprecated
        protected Object engineGetParameter(String string) {
            if (string.equals("KSEED")) {
                return this.kSeedAsByteArray;
            }
            return null;
        }

        @Override
        protected void checkKey(DSAParams dSAParams) throws InvalidKeyException {
            int n = dSAParams.getP().bitLength();
            if (n > 1024) {
                throw new InvalidKeyException("Key is too long for this algorithm");
            }
        }

        @Override
        protected BigInteger generateK(BigInteger bigInteger) {
            int[] nArray;
            BigInteger bigInteger2 = null;
            if (this.kSeed != null && !Arrays.equals(this.kSeed, this.kSeedLast) && (bigInteger2 = this.generateKUsingKSeed(this.kSeed, bigInteger)).signum() > 0 && bigInteger2.compareTo(bigInteger) < 0) {
                this.kSeedLast = (int[])this.kSeed.clone();
                return bigInteger2;
            }
            SecureRandom secureRandom = this.getSigningRandom();
            do {
                nArray = new int[5];
                for (int i = 0; i < 5; ++i) {
                    nArray[i] = secureRandom.nextInt();
                }
            } while ((bigInteger2 = this.generateKUsingKSeed(nArray, bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
            this.kSeedLast = nArray;
            return bigInteger2;
        }

        private BigInteger generateKUsingKSeed(int[] nArray, BigInteger bigInteger) {
            int[] nArray2 = new int[]{-271733879, -1732584194, 271733878, -1009589776, 1732584193};
            int[] nArray3 = LegacyDSA.SHA_7(nArray, nArray2);
            byte[] byArray = new byte[nArray3.length * 4];
            for (int i = 0; i < nArray3.length; ++i) {
                int n = nArray3[i];
                for (int j = 0; j < 4; ++j) {
                    byArray[i * 4 + j] = (byte)(n >>> 24 - j * 8);
                }
            }
            BigInteger bigInteger2 = new BigInteger(1, byArray).mod(bigInteger);
            return bigInteger2;
        }

        static int[] SHA_7(int[] nArray, int[] nArray2) {
            int n;
            int n2;
            int[] nArray3 = new int[80];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            int n3 = 0;
            for (n2 = 16; n2 <= 79; ++n2) {
                n3 = nArray3[n2 - 3] ^ nArray3[n2 - 8] ^ nArray3[n2 - 14] ^ nArray3[n2 - 16];
                nArray3[n2] = n3 << 1 | n3 >>> 31;
            }
            n2 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            int n6 = nArray2[3];
            int n7 = nArray2[4];
            for (n = 0; n < 20; ++n) {
                n3 = (n2 << 5 | n2 >>> 27) + (n4 & n5 | ~n4 & n6) + n7 + nArray3[n] + 1518500249;
                n7 = n6;
                n6 = n5;
                n5 = n4 << 30 | n4 >>> 2;
                n4 = n2;
                n2 = n3;
            }
            for (n = 20; n < 40; ++n) {
                n3 = (n2 << 5 | n2 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n] + 1859775393;
                n7 = n6;
                n6 = n5;
                n5 = n4 << 30 | n4 >>> 2;
                n4 = n2;
                n2 = n3;
            }
            for (n = 40; n < 60; ++n) {
                n3 = (n2 << 5 | n2 >>> 27) + (n4 & n5 | n4 & n6 | n5 & n6) + n7 + nArray3[n] + -1894007588;
                n7 = n6;
                n6 = n5;
                n5 = n4 << 30 | n4 >>> 2;
                n4 = n2;
                n2 = n3;
            }
            for (n = 60; n < 80; ++n) {
                n3 = (n2 << 5 | n2 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n] + -899497514;
                n7 = n6;
                n6 = n5;
                n5 = n4 << 30 | n4 >>> 2;
                n4 = n2;
                n2 = n3;
            }
            int[] nArray4 = new int[]{nArray2[0] + n2, nArray2[1] + n4, nArray2[2] + n5, nArray2[3] + n6, nArray2[4] + n7};
            return nArray4;
        }

        private int[] byteArray2IntArray(byte[] byArray) {
            byte[] byArray2;
            int n = 0;
            int n2 = byArray.length % 4;
            switch (n2) {
                case 3: {
                    byArray2 = new byte[byArray.length + 1];
                    break;
                }
                case 2: {
                    byArray2 = new byte[byArray.length + 2];
                    break;
                }
                case 1: {
                    byArray2 = new byte[byArray.length + 3];
                    break;
                }
                default: {
                    byArray2 = new byte[byArray.length + 0];
                }
            }
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            int[] nArray = new int[byArray2.length / 4];
            for (int i = 0; i < byArray2.length; i += 4) {
                nArray[n] = byArray2[i + 3] & 0xFF;
                int n3 = n;
                nArray[n3] = nArray[n3] | byArray2[i + 2] << 8 & 0xFF00;
                int n4 = n;
                nArray[n4] = nArray[n4] | byArray2[i + 1] << 16 & 0xFF0000;
                int n5 = n++;
                nArray[n5] = nArray[n5] | byArray2[i + 0] << 24 & 0xFF000000;
            }
            return nArray;
        }
    }

    public static final class RawDSA
    extends LegacyDSA {
        public RawDSA() throws NoSuchAlgorithmException {
            super(new NullDigest20());
        }

        public static final class NullDigest20
        extends MessageDigest {
            private final byte[] digestBuffer = new byte[20];
            private int ofs = 0;

            protected NullDigest20() {
                super("NullDigest20");
            }

            @Override
            protected void engineUpdate(byte by) {
                if (this.ofs == this.digestBuffer.length) {
                    this.ofs = Integer.MAX_VALUE;
                } else {
                    this.digestBuffer[this.ofs++] = by;
                }
            }

            @Override
            protected void engineUpdate(byte[] byArray, int n, int n2) {
                if (this.ofs + n2 > this.digestBuffer.length) {
                    this.ofs = Integer.MAX_VALUE;
                } else {
                    System.arraycopy(byArray, n, this.digestBuffer, this.ofs, n2);
                    this.ofs += n2;
                }
            }

            @Override
            protected final void engineUpdate(ByteBuffer byteBuffer) {
                int n = byteBuffer.remaining();
                if (this.ofs + n > this.digestBuffer.length) {
                    this.ofs = Integer.MAX_VALUE;
                } else {
                    byteBuffer.get(this.digestBuffer, this.ofs, n);
                    this.ofs += n;
                }
            }

            @Override
            protected byte[] engineDigest() throws RuntimeException {
                if (this.ofs != this.digestBuffer.length) {
                    throw new RuntimeException("Data for RawDSA must be exactly 20 bytes long");
                }
                this.reset();
                return this.digestBuffer;
            }

            @Override
            protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
                if (this.ofs != this.digestBuffer.length) {
                    throw new DigestException("Data for RawDSA must be exactly 20 bytes long");
                }
                if (n2 < this.digestBuffer.length) {
                    throw new DigestException("Output buffer too small; must be at least 20 bytes");
                }
                System.arraycopy(this.digestBuffer, 0, byArray, n, this.digestBuffer.length);
                this.reset();
                return this.digestBuffer.length;
            }

            @Override
            protected void engineReset() {
                this.ofs = 0;
            }

            @Override
            protected final int engineGetDigestLength() {
                return this.digestBuffer.length;
            }
        }
    }

    public static final class SHA1withDSA
    extends LegacyDSA {
        public SHA1withDSA() throws NoSuchAlgorithmException {
            super(MessageDigest.getInstance("SHA-1"));
        }
    }

    public static final class SHA224withDSA
    extends DSA {
        public SHA224withDSA() throws NoSuchAlgorithmException {
            super(MessageDigest.getInstance("SHA-224"));
        }
    }

    public static final class SHA256withDSA
    extends DSA {
        public SHA256withDSA() throws NoSuchAlgorithmException {
            super(MessageDigest.getInstance("SHA-256"));
        }
    }
}

