/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import sun.reflect.BootstrapConstructorAccessorImpl;
import sun.reflect.ConstructorAccessor;
import sun.reflect.ConstructorAccessorImpl;
import sun.reflect.DelegatingConstructorAccessorImpl;
import sun.reflect.DelegatingMethodAccessorImpl;
import sun.reflect.FieldAccessor;
import sun.reflect.InstantiationExceptionConstructorAccessorImpl;
import sun.reflect.LangReflectAccess;
import sun.reflect.MethodAccessor;
import sun.reflect.MethodAccessorGenerator;
import sun.reflect.NativeConstructorAccessorImpl;
import sun.reflect.NativeMethodAccessorImpl;
import sun.reflect.Reflection;
import sun.reflect.SerializationConstructorAccessorImpl;
import sun.reflect.UnsafeFieldAccessorFactory;
import sun.reflect.misc.ReflectUtil;

public class ReflectionFactory {
    private static boolean initted = false;
    private static Permission reflectionFactoryAccessPerm = new RuntimePermission("reflectionFactoryAccess");
    private static ReflectionFactory soleInstance = new ReflectionFactory();
    private static volatile LangReflectAccess langReflectAccess;
    private static boolean noInflation;
    private static int inflationThreshold;

    private ReflectionFactory() {
    }

    public static ReflectionFactory getReflectionFactory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(reflectionFactoryAccessPerm);
        }
        return soleInstance;
    }

    public void setLangReflectAccess(LangReflectAccess langReflectAccess) {
        ReflectionFactory.langReflectAccess = langReflectAccess;
    }

    public FieldAccessor newFieldAccessor(Field field, boolean bl) {
        ReflectionFactory.checkInitted();
        return UnsafeFieldAccessorFactory.newFieldAccessor(field, bl);
    }

    public MethodAccessor newMethodAccessor(Method method) {
        ReflectionFactory.checkInitted();
        if (noInflation && !ReflectUtil.isVMAnonymousClass(method.getDeclaringClass())) {
            return new MethodAccessorGenerator().generateMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes(), method.getModifiers());
        }
        NativeMethodAccessorImpl nativeMethodAccessorImpl = new NativeMethodAccessorImpl(method);
        DelegatingMethodAccessorImpl delegatingMethodAccessorImpl = new DelegatingMethodAccessorImpl(nativeMethodAccessorImpl);
        nativeMethodAccessorImpl.setParent(delegatingMethodAccessorImpl);
        return delegatingMethodAccessorImpl;
    }

    public ConstructorAccessor newConstructorAccessor(Constructor<?> constructor) {
        ReflectionFactory.checkInitted();
        Class<?> clazz = constructor.getDeclaringClass();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return new InstantiationExceptionConstructorAccessorImpl(null);
        }
        if (clazz == Class.class) {
            return new InstantiationExceptionConstructorAccessorImpl("Can not instantiate java.lang.Class");
        }
        if (Reflection.isSubclassOf(clazz, ConstructorAccessorImpl.class)) {
            return new BootstrapConstructorAccessorImpl(constructor);
        }
        if (noInflation && !ReflectUtil.isVMAnonymousClass(constructor.getDeclaringClass())) {
            return new MethodAccessorGenerator().generateConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers());
        }
        NativeConstructorAccessorImpl nativeConstructorAccessorImpl = new NativeConstructorAccessorImpl(constructor);
        DelegatingConstructorAccessorImpl delegatingConstructorAccessorImpl = new DelegatingConstructorAccessorImpl(nativeConstructorAccessorImpl);
        nativeConstructorAccessorImpl.setParent(delegatingConstructorAccessorImpl);
        return delegatingConstructorAccessorImpl;
    }

    public Field newField(Class<?> clazz, String string, Class<?> clazz2, int n, int n2, String string2, byte[] byArray) {
        return ReflectionFactory.langReflectAccess().newField(clazz, string, clazz2, n, n2, string2, byArray);
    }

    public Method newMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2, Class<?>[] classArray2, int n, int n2, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return ReflectionFactory.langReflectAccess().newMethod(clazz, string, classArray, clazz2, classArray2, n, n2, string2, byArray, byArray2, byArray3);
    }

    public Constructor<?> newConstructor(Class<?> clazz, Class<?>[] classArray, Class<?>[] classArray2, int n, int n2, String string, byte[] byArray, byte[] byArray2) {
        return ReflectionFactory.langReflectAccess().newConstructor(clazz, classArray, classArray2, n, n2, string, byArray, byArray2);
    }

    public MethodAccessor getMethodAccessor(Method method) {
        return ReflectionFactory.langReflectAccess().getMethodAccessor(method);
    }

    public void setMethodAccessor(Method method, MethodAccessor methodAccessor) {
        ReflectionFactory.langReflectAccess().setMethodAccessor(method, methodAccessor);
    }

    public ConstructorAccessor getConstructorAccessor(Constructor<?> constructor) {
        return ReflectionFactory.langReflectAccess().getConstructorAccessor(constructor);
    }

    public void setConstructorAccessor(Constructor<?> constructor, ConstructorAccessor constructorAccessor) {
        ReflectionFactory.langReflectAccess().setConstructorAccessor(constructor, constructorAccessor);
    }

    public Method copyMethod(Method method) {
        return ReflectionFactory.langReflectAccess().copyMethod(method);
    }

    public Field copyField(Field field) {
        return ReflectionFactory.langReflectAccess().copyField(field);
    }

    public <T> Constructor<T> copyConstructor(Constructor<T> constructor) {
        return ReflectionFactory.langReflectAccess().copyConstructor(constructor);
    }

    public byte[] getExecutableTypeAnnotationBytes(Executable executable) {
        return ReflectionFactory.langReflectAccess().getExecutableTypeAnnotationBytes(executable);
    }

    public Constructor<?> newConstructorForSerialization(Class<?> clazz, Constructor<?> constructor) {
        if (constructor.getDeclaringClass() == clazz) {
            return constructor;
        }
        SerializationConstructorAccessorImpl serializationConstructorAccessorImpl = new MethodAccessorGenerator().generateSerializationConstructor(clazz, constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers(), constructor.getDeclaringClass());
        Constructor<?> constructor2 = this.newConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers(), ReflectionFactory.langReflectAccess().getConstructorSlot(constructor), ReflectionFactory.langReflectAccess().getConstructorSignature(constructor), ReflectionFactory.langReflectAccess().getConstructorAnnotations(constructor), ReflectionFactory.langReflectAccess().getConstructorParameterAnnotations(constructor));
        this.setConstructorAccessor(constructor2, serializationConstructorAccessorImpl);
        return constructor2;
    }

    static int inflationThreshold() {
        return inflationThreshold;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.out == null) {
                    return null;
                }
                String string = System.getProperty("sun.reflect.noInflation");
                if (string != null && string.equals("true")) {
                    noInflation = true;
                }
                if ((string = System.getProperty("sun.reflect.inflationThreshold")) != null) {
                    try {
                        inflationThreshold = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RuntimeException("Unable to parse property sun.reflect.inflationThreshold", numberFormatException);
                    }
                }
                initted = true;
                return null;
            }
        });
    }

    private static LangReflectAccess langReflectAccess() {
        if (langReflectAccess == null) {
            Modifier.isPublic(1);
        }
        return langReflectAccess;
    }

    static {
        noInflation = false;
        inflationThreshold = 15;
    }

    public static final class GetReflectionFactoryAction
    implements PrivilegedAction<ReflectionFactory> {
        @Override
        public ReflectionFactory run() {
            return ReflectionFactory.getReflectionFactory();
        }
    }
}

