/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;

public abstract class AbstractPollArrayWrapper {
    public static final short POLLIN = 1;
    public static final short POLLOUT = 4;
    public static final short POLLERR = 8;
    public static final short POLLHUP = 16;
    public static final short POLLNVAL = 32;
    public static final short POLLREMOVE = 2048;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    protected AllocatedNativeObject pollArray;
    protected int totalChannels = 0;
    protected long pollArrayAddress;

    int getEventOps(int n) {
        int n2 = 8 * n + 4;
        return this.pollArray.getShort(n2);
    }

    int getReventOps(int n) {
        int n2 = 8 * n + 6;
        return this.pollArray.getShort(n2);
    }

    int getDescriptor(int n) {
        int n2 = 8 * n + 0;
        return this.pollArray.getInt(n2);
    }

    void putEventOps(int n, int n2) {
        int n3 = 8 * n + 4;
        this.pollArray.putShort(n3, (short)n2);
    }

    void putReventOps(int n, int n2) {
        int n3 = 8 * n + 6;
        this.pollArray.putShort(n3, (short)n2);
    }

    void putDescriptor(int n, int n2) {
        int n3 = 8 * n + 0;
        this.pollArray.putInt(n3, n2);
    }
}

