/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalToolBarUI
extends BasicToolBarUI {
    private static List<WeakReference<JComponent>> components = new ArrayList<WeakReference<JComponent>>();
    protected ContainerListener contListener;
    protected PropertyChangeListener rolloverListener;
    private static Border nonRolloverBorder;
    private JMenuBar lastMenuBar;

    static synchronized void register(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("JComponent must be non-null");
        }
        components.add(new WeakReference<JComponent>(jComponent));
    }

    static synchronized void unregister(JComponent jComponent) {
        for (int i = components.size() - 1; i >= 0; --i) {
            JComponent jComponent2 = (JComponent)components.get(i).get();
            if (jComponent2 != jComponent && jComponent2 != null) continue;
            components.remove(i);
        }
    }

    static synchronized Object findRegisteredComponentOfType(JComponent jComponent, Class clazz) {
        JRootPane jRootPane = SwingUtilities.getRootPane(jComponent);
        if (jRootPane != null) {
            for (int i = components.size() - 1; i >= 0; --i) {
                Object t = components.get(i).get();
                if (t == null) {
                    components.remove(i);
                    continue;
                }
                if (!clazz.isInstance(t) || SwingUtilities.getRootPane((Component)t) != jRootPane) continue;
                return t;
            }
        }
        return null;
    }

    static boolean doesMenuBarBorderToolBar(JMenuBar jMenuBar) {
        JToolBar jToolBar = (JToolBar)MetalToolBarUI.findRegisteredComponentOfType(jMenuBar, JToolBar.class);
        if (jToolBar != null && jToolBar.getOrientation() == 0) {
            JRootPane jRootPane = SwingUtilities.getRootPane(jMenuBar);
            Point point = new Point(0, 0);
            point = SwingUtilities.convertPoint(jMenuBar, point, jRootPane);
            int n = point.x;
            int n2 = point.y;
            point.y = 0;
            point.x = 0;
            point = SwingUtilities.convertPoint(jToolBar, point, jRootPane);
            return point.x == n && n2 + jMenuBar.getHeight() == point.y && jMenuBar.getWidth() == jToolBar.getWidth();
        }
        return false;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalToolBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        MetalToolBarUI.register(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        nonRolloverBorder = null;
        MetalToolBarUI.unregister(jComponent);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.contListener = this.createContainerListener();
        if (this.contListener != null) {
            this.toolBar.addContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.addPropertyChangeListener(this.rolloverListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.contListener != null) {
            this.toolBar.removeContainerListener(this.contListener);
        }
        this.rolloverListener = this.createRolloverListener();
        if (this.rolloverListener != null) {
            this.toolBar.removePropertyChangeListener(this.rolloverListener);
        }
    }

    @Override
    protected Border createRolloverBorder() {
        return super.createRolloverBorder();
    }

    @Override
    protected Border createNonRolloverBorder() {
        return super.createNonRolloverBorder();
    }

    private Border createNonRolloverToggleBorder() {
        return this.createNonRolloverBorder();
    }

    @Override
    protected void setBorderToNonRollover(Component component) {
        if (component instanceof JToggleButton && !(component instanceof JCheckBox)) {
            JToggleButton jToggleButton = (JToggleButton)component;
            Border border = jToggleButton.getBorder();
            super.setBorderToNonRollover(component);
            if (border instanceof UIResource) {
                if (nonRolloverBorder == null) {
                    nonRolloverBorder = this.createNonRolloverToggleBorder();
                }
                jToggleButton.setBorder(nonRolloverBorder);
            }
        } else {
            super.setBorderToNonRollover(component);
        }
    }

    protected ContainerListener createContainerListener() {
        return null;
    }

    protected PropertyChangeListener createRolloverListener() {
        return null;
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return new MetalDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point point) {
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            this.dragWindow.setOffset(point);
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (graphics == null) {
            throw new NullPointerException("graphics must be non-null");
        }
        if (jComponent.isOpaque() && jComponent.getBackground() instanceof UIResource && ((JToolBar)jComponent).getOrientation() == 0 && UIManager.get("MenuBar.gradient") != null) {
            JRootPane jRootPane = SwingUtilities.getRootPane(jComponent);
            JMenuBar jMenuBar = (JMenuBar)MetalToolBarUI.findRegisteredComponentOfType(jComponent, JMenuBar.class);
            if (jMenuBar != null && jMenuBar.isOpaque() && jMenuBar.getBackground() instanceof UIResource) {
                Point point = new Point(0, 0);
                point = SwingUtilities.convertPoint(jComponent, point, jRootPane);
                int n = point.x;
                int n2 = point.y;
                point.y = 0;
                point.x = 0;
                point = SwingUtilities.convertPoint(jMenuBar, point, jRootPane);
                if (point.x == n && n2 == point.y + jMenuBar.getHeight() && jMenuBar.getWidth() == jComponent.getWidth() && MetalUtils.drawGradient(jComponent, graphics, "MenuBar.gradient", 0, -jMenuBar.getHeight(), jComponent.getWidth(), jComponent.getHeight() + jMenuBar.getHeight(), true)) {
                    this.setLastMenuBar(jMenuBar);
                    this.paint(graphics, jComponent);
                    return;
                }
            }
            if (MetalUtils.drawGradient(jComponent, graphics, "MenuBar.gradient", 0, 0, jComponent.getWidth(), jComponent.getHeight(), true)) {
                this.setLastMenuBar(null);
                this.paint(graphics, jComponent);
                return;
            }
        }
        this.setLastMenuBar(null);
        super.update(graphics, jComponent);
    }

    private void setLastMenuBar(JMenuBar jMenuBar) {
        if (MetalLookAndFeel.usingOcean() && this.lastMenuBar != jMenuBar) {
            if (this.lastMenuBar != null) {
                this.lastMenuBar.repaint();
            }
            if (jMenuBar != null) {
                jMenuBar.repaint();
            }
            this.lastMenuBar = jMenuBar;
        }
    }

    protected class MetalContainerListener
    extends BasicToolBarUI.ToolBarContListener {
        protected MetalContainerListener() {
            super(MetalToolBarUI.this);
        }
    }

    protected class MetalDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps;

        public MetalDockingListener(JToolBar jToolBar) {
            super(MetalToolBarUI.this, jToolBar);
            this.pressedInBumps = false;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedInBumps = false;
            Rectangle rectangle = new Rectangle();
            if (this.toolBar.getOrientation() == 0) {
                int n = MetalUtils.isLeftToRight(this.toolBar) ? 0 : this.toolBar.getSize().width - 14;
                rectangle.setBounds(n, 0, 14, this.toolBar.getSize().height);
            } else {
                rectangle.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.pressedInBumps = true;
                Point point = mouseEvent.getPoint();
                if (!MetalUtils.isLeftToRight(this.toolBar)) {
                    point.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                MetalToolBarUI.this.setDragOffset(point);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.pressedInBumps) {
                super.mouseDragged(mouseEvent);
            }
        }
    }

    protected class MetalRolloverListener
    extends BasicToolBarUI.PropertyListener {
        protected MetalRolloverListener() {
            super(MetalToolBarUI.this);
        }
    }
}

