/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;

public class SQLInputImpl
implements SQLInput {
    private boolean lastValueWasNull;
    private int idx;
    private Object[] attrib;
    private Map<String, Class<?>> map;

    public SQLInputImpl(Object[] objectArray, Map<String, Class<?>> map) throws SQLException {
        if (objectArray == null || map == null) {
            throw new SQLException("Cannot instantiate a SQLInputImpl object with null parameters");
        }
        this.attrib = Arrays.copyOf(objectArray, objectArray.length);
        this.idx = -1;
        this.map = map;
    }

    private Object getNextAttribute() throws SQLException {
        if (++this.idx >= this.attrib.length) {
            throw new SQLException("SQLInputImpl exception: Invalid read position");
        }
        this.lastValueWasNull = this.attrib[this.idx] == null;
        return this.attrib[this.idx];
    }

    @Override
    public String readString() throws SQLException {
        return (String)this.getNextAttribute();
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean bl = (Boolean)this.getNextAttribute();
        return bl == null ? false : bl;
    }

    @Override
    public byte readByte() throws SQLException {
        Byte by = (Byte)this.getNextAttribute();
        return by == null ? (byte)0 : by;
    }

    @Override
    public short readShort() throws SQLException {
        Short s = (Short)this.getNextAttribute();
        return s == null ? (short)0 : s;
    }

    @Override
    public int readInt() throws SQLException {
        Integer n = (Integer)this.getNextAttribute();
        return n == null ? 0 : n;
    }

    @Override
    public long readLong() throws SQLException {
        Long l = (Long)this.getNextAttribute();
        return l == null ? 0L : l;
    }

    @Override
    public float readFloat() throws SQLException {
        Float f = (Float)this.getNextAttribute();
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        Double d = (Double)this.getNextAttribute();
        return d == null ? 0.0 : d;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return (BigDecimal)this.getNextAttribute();
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return (byte[])this.getNextAttribute();
    }

    @Override
    public Date readDate() throws SQLException {
        return (Date)this.getNextAttribute();
    }

    @Override
    public Time readTime() throws SQLException {
        return (Time)this.getNextAttribute();
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return (Timestamp)this.getNextAttribute();
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        return (Reader)this.getNextAttribute();
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        return (InputStream)this.getNextAttribute();
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        return (InputStream)this.getNextAttribute();
    }

    @Override
    public Object readObject() throws SQLException {
        Struct struct;
        Class<?> clazz;
        Object object = this.getNextAttribute();
        if (object instanceof Struct && (clazz = this.map.get((struct = (Struct)object).getSQLTypeName())) != null) {
            SQLData sQLData = null;
            try {
                sQLData = (SQLData)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException("Unable to instantiate: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException("Unable to instantiate: " + illegalAccessException.getMessage());
            }
            Object[] objectArray = struct.getAttributes(this.map);
            SQLInputImpl sQLInputImpl = new SQLInputImpl(objectArray, this.map);
            sQLData.readSQL(sQLInputImpl, struct.getSQLTypeName());
            return sQLData;
        }
        return object;
    }

    @Override
    public Ref readRef() throws SQLException {
        return (Ref)this.getNextAttribute();
    }

    @Override
    public Blob readBlob() throws SQLException {
        return (Blob)this.getNextAttribute();
    }

    @Override
    public Clob readClob() throws SQLException {
        return (Clob)this.getNextAttribute();
    }

    @Override
    public Array readArray() throws SQLException {
        return (Array)this.getNextAttribute();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueWasNull;
    }

    @Override
    public URL readURL() throws SQLException {
        return (URL)this.getNextAttribute();
    }

    @Override
    public NClob readNClob() throws SQLException {
        return (NClob)this.getNextAttribute();
    }

    @Override
    public String readNString() throws SQLException {
        return (String)this.getNextAttribute();
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return (SQLXML)this.getNextAttribute();
    }

    @Override
    public RowId readRowId() throws SQLException {
        return (RowId)this.getNextAttribute();
    }
}

