/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;

public final class IsoFields {
    public static final TemporalField DAY_OF_QUARTER = Field.DAY_OF_QUARTER;
    public static final TemporalField QUARTER_OF_YEAR = Field.QUARTER_OF_YEAR;
    public static final TemporalField WEEK_OF_WEEK_BASED_YEAR = Field.WEEK_OF_WEEK_BASED_YEAR;
    public static final TemporalField WEEK_BASED_YEAR = Field.WEEK_BASED_YEAR;
    public static final TemporalUnit WEEK_BASED_YEARS = Unit.WEEK_BASED_YEARS;
    public static final TemporalUnit QUARTER_YEARS = Unit.QUARTER_YEARS;

    private IsoFields() {
        throw new AssertionError((Object)"Not instantiable");
    }

    private static enum Field implements TemporalField
    {
        DAY_OF_QUARTER{

            @Override
            public TemporalUnit getBaseUnit() {
                return ChronoUnit.DAYS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return QUARTER_YEARS;
            }

            @Override
            public ValueRange range() {
                return ValueRange.of(1L, 90L, 92L);
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
                return temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR) && temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR) && temporalAccessor.isSupported(ChronoField.YEAR) && Field.isIso(temporalAccessor);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
                if (!this.isSupportedBy(temporalAccessor)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: DayOfQuarter");
                }
                long l = temporalAccessor.getLong(QUARTER_OF_YEAR);
                if (l == 1L) {
                    long l2 = temporalAccessor.getLong(ChronoField.YEAR);
                    return IsoChronology.INSTANCE.isLeapYear(l2) ? ValueRange.of(1L, 91L) : ValueRange.of(1L, 90L);
                }
                if (l == 2L) {
                    return ValueRange.of(1L, 91L);
                }
                if (l == 3L || l == 4L) {
                    return ValueRange.of(1L, 92L);
                }
                return this.range();
            }

            @Override
            public long getFrom(TemporalAccessor temporalAccessor) {
                if (!this.isSupportedBy(temporalAccessor)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: DayOfQuarter");
                }
                int n = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
                int n2 = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
                long l = temporalAccessor.getLong(ChronoField.YEAR);
                return n - QUARTER_DAYS[(n2 - 1) / 3 + (IsoChronology.INSTANCE.isLeapYear(l) ? 4 : 0)];
            }

            @Override
            public <R extends Temporal> R adjustInto(R r, long l) {
                long l2 = this.getFrom(r);
                this.range().checkValidValue(l, this);
                return (R)r.with(ChronoField.DAY_OF_YEAR, r.getLong(ChronoField.DAY_OF_YEAR) + (l - l2));
            }

            @Override
            public ChronoLocalDate resolve(Map<TemporalField, Long> map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
                LocalDate localDate;
                Long l = map.get(ChronoField.YEAR);
                Long l2 = map.get(QUARTER_OF_YEAR);
                if (l == null || l2 == null) {
                    return null;
                }
                int n = ChronoField.YEAR.checkValidIntValue(l);
                long l3 = map.get(DAY_OF_QUARTER);
                Field.ensureIso(temporalAccessor);
                if (resolverStyle == ResolverStyle.LENIENT) {
                    localDate = LocalDate.of(n, 1, 1).plusMonths(Math.multiplyExact(Math.subtractExact(l2, 1L), 3L));
                    l3 = Math.subtractExact(l3, 1L);
                } else {
                    int n2 = QUARTER_OF_YEAR.range().checkValidIntValue(l2, QUARTER_OF_YEAR);
                    localDate = LocalDate.of(n, (n2 - 1) * 3 + 1, 1);
                    if (l3 < 1L || l3 > 90L) {
                        if (resolverStyle == ResolverStyle.STRICT) {
                            this.rangeRefinedBy(localDate).checkValidValue(l3, this);
                        } else {
                            this.range().checkValidValue(l3, this);
                        }
                    }
                    --l3;
                }
                map.remove(this);
                map.remove(ChronoField.YEAR);
                map.remove(QUARTER_OF_YEAR);
                return localDate.plusDays(l3);
            }

            @Override
            public String toString() {
                return "DayOfQuarter";
            }
        }
        ,
        QUARTER_OF_YEAR{

            @Override
            public TemporalUnit getBaseUnit() {
                return QUARTER_YEARS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return ChronoUnit.YEARS;
            }

            @Override
            public ValueRange range() {
                return ValueRange.of(1L, 4L);
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
                return temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR) && Field.isIso(temporalAccessor);
            }

            @Override
            public long getFrom(TemporalAccessor temporalAccessor) {
                if (!this.isSupportedBy(temporalAccessor)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: QuarterOfYear");
                }
                long l = temporalAccessor.getLong(ChronoField.MONTH_OF_YEAR);
                return (l + 2L) / 3L;
            }

            @Override
            public <R extends Temporal> R adjustInto(R r, long l) {
                long l2 = this.getFrom(r);
                this.range().checkValidValue(l, this);
                return (R)r.with(ChronoField.MONTH_OF_YEAR, r.getLong(ChronoField.MONTH_OF_YEAR) + (l - l2) * 3L);
            }

            @Override
            public String toString() {
                return "QuarterOfYear";
            }
        }
        ,
        WEEK_OF_WEEK_BASED_YEAR{

            @Override
            public String getDisplayName(Locale locale) {
                Objects.requireNonNull(locale, "locale");
                LocaleResources localeResources = LocaleProviderAdapter.getResourceBundleBased().getLocaleResources(locale);
                ResourceBundle resourceBundle = localeResources.getJavaTimeFormatData();
                return resourceBundle.containsKey("field.week") ? resourceBundle.getString("field.week") : this.toString();
            }

            @Override
            public TemporalUnit getBaseUnit() {
                return ChronoUnit.WEEKS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return WEEK_BASED_YEARS;
            }

            @Override
            public ValueRange range() {
                return ValueRange.of(1L, 52L, 53L);
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
                return temporalAccessor.isSupported(ChronoField.EPOCH_DAY) && Field.isIso(temporalAccessor);
            }

            @Override
            public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
                if (!this.isSupportedBy(temporalAccessor)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: WeekOfWeekBasedYear");
                }
                return Field.getWeekRange(LocalDate.from(temporalAccessor));
            }

            @Override
            public long getFrom(TemporalAccessor temporalAccessor) {
                if (!this.isSupportedBy(temporalAccessor)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: WeekOfWeekBasedYear");
                }
                return Field.getWeek(LocalDate.from(temporalAccessor));
            }

            @Override
            public <R extends Temporal> R adjustInto(R r, long l) {
                this.range().checkValidValue(l, this);
                return (R)r.plus(Math.subtractExact(l, this.getFrom(r)), ChronoUnit.WEEKS);
            }

            @Override
            public ChronoLocalDate resolve(Map<TemporalField, Long> map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
                Long l = map.get(WEEK_BASED_YEAR);
                Long l2 = map.get(ChronoField.DAY_OF_WEEK);
                if (l == null || l2 == null) {
                    return null;
                }
                int n = WEEK_BASED_YEAR.range().checkValidIntValue(l, WEEK_BASED_YEAR);
                long l3 = map.get(WEEK_OF_WEEK_BASED_YEAR);
                Field.ensureIso(temporalAccessor);
                LocalDate localDate = LocalDate.of(n, 1, 4);
                if (resolverStyle == ResolverStyle.LENIENT) {
                    long l4 = l2;
                    if (l4 > 7L) {
                        localDate = localDate.plusWeeks((l4 - 1L) / 7L);
                        l4 = (l4 - 1L) % 7L + 1L;
                    } else if (l4 < 1L) {
                        localDate = localDate.plusWeeks(Math.subtractExact(l4, 7L) / 7L);
                        l4 = (l4 + 6L) % 7L + 1L;
                    }
                    localDate = localDate.plusWeeks(Math.subtractExact(l3, 1L)).with(ChronoField.DAY_OF_WEEK, l4);
                } else {
                    int n2 = ChronoField.DAY_OF_WEEK.checkValidIntValue(l2);
                    if (l3 < 1L || l3 > 52L) {
                        if (resolverStyle == ResolverStyle.STRICT) {
                            Field.getWeekRange(localDate).checkValidValue(l3, this);
                        } else {
                            this.range().checkValidValue(l3, this);
                        }
                    }
                    localDate = localDate.plusWeeks(l3 - 1L).with(ChronoField.DAY_OF_WEEK, n2);
                }
                map.remove(this);
                map.remove(WEEK_BASED_YEAR);
                map.remove(ChronoField.DAY_OF_WEEK);
                return localDate;
            }

            @Override
            public String toString() {
                return "WeekOfWeekBasedYear";
            }
        }
        ,
        WEEK_BASED_YEAR{

            @Override
            public TemporalUnit getBaseUnit() {
                return WEEK_BASED_YEARS;
            }

            @Override
            public TemporalUnit getRangeUnit() {
                return ChronoUnit.FOREVER;
            }

            @Override
            public ValueRange range() {
                return ChronoField.YEAR.range();
            }

            @Override
            public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
                return temporalAccessor.isSupported(ChronoField.EPOCH_DAY) && Field.isIso(temporalAccessor);
            }

            @Override
            public long getFrom(TemporalAccessor temporalAccessor) {
                if (!this.isSupportedBy(temporalAccessor)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: WeekBasedYear");
                }
                return Field.getWeekBasedYear(LocalDate.from(temporalAccessor));
            }

            @Override
            public <R extends Temporal> R adjustInto(R r, long l) {
                if (!this.isSupportedBy(r)) {
                    throw new UnsupportedTemporalTypeException("Unsupported field: WeekBasedYear");
                }
                int n = this.range().checkValidIntValue(l, WEEK_BASED_YEAR);
                LocalDate localDate = LocalDate.from(r);
                int n2 = Field.getWeek(localDate);
                localDate = localDate.withDayOfYear(180).withYear(n).with(WEEK_OF_WEEK_BASED_YEAR, n2);
                return (R)localDate.with(localDate);
            }

            @Override
            public String toString() {
                return "WeekBasedYear";
            }
        };

        private static final int[] QUARTER_DAYS;

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
            return this.range();
        }

        private static boolean isIso(TemporalAccessor temporalAccessor) {
            return Chronology.from(temporalAccessor).equals(IsoChronology.INSTANCE);
        }

        private static void ensureIso(TemporalAccessor temporalAccessor) {
            if (!Field.isIso(temporalAccessor)) {
                throw new DateTimeException("Resolve requires IsoChronology");
            }
        }

        private static ValueRange getWeekRange(LocalDate localDate) {
            int n = Field.getWeekBasedYear(localDate);
            if ((localDate = localDate.withDayOfYear(1).withYear(n)).getDayOfWeek() == DayOfWeek.THURSDAY || localDate.getDayOfWeek() == DayOfWeek.WEDNESDAY && localDate.isLeapYear()) {
                return ValueRange.of(1L, 53L);
            }
            return ValueRange.of(1L, 52L);
        }

        private static int getWeek(LocalDate localDate) {
            int n;
            int n2 = localDate.getDayOfWeek().ordinal();
            int n3 = localDate.getDayOfYear() - 1;
            int n4 = n3 + (3 - n2);
            int n5 = n4 - (n = n4 / 7) * 7;
            int n6 = n5 - 3;
            if (n6 < -3) {
                n6 += 7;
            }
            if (n3 < n6) {
                return (int)Field.getWeekRange(localDate.withDayOfYear(180).minusYears(1L)).getMaximum();
            }
            int n7 = (n3 - n6) / 7 + 1;
            if (n7 == 53 && !(n6 == -3 || n6 == -2 && localDate.isLeapYear())) {
                n7 = 1;
            }
            return n7;
        }

        private static int getWeekBasedYear(LocalDate localDate) {
            int n = localDate.getYear();
            int n2 = localDate.getDayOfYear();
            if (n2 <= 3) {
                int n3 = localDate.getDayOfWeek().ordinal();
                if (n2 - n3 < -2) {
                    --n;
                }
            } else if (n2 >= 363) {
                int n4 = localDate.getDayOfWeek().ordinal();
                if ((n2 = n2 - 363 - (localDate.isLeapYear() ? 1 : 0)) - n4 >= 0) {
                    ++n;
                }
            }
            return n;
        }

        static {
            QUARTER_DAYS = new int[]{0, 90, 181, 273, 0, 91, 182, 274};
        }
    }

    private static enum Unit implements TemporalUnit
    {
        WEEK_BASED_YEARS("WeekBasedYears", Duration.ofSeconds(31556952L)),
        QUARTER_YEARS("QuarterYears", Duration.ofSeconds(7889238L));

        private final String name;
        private final Duration duration;

        private Unit(String string2, Duration duration) {
            this.name = string2;
            this.duration = duration;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        @Override
        public boolean isDurationEstimated() {
            return true;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(Temporal temporal) {
            return temporal.isSupported(ChronoField.EPOCH_DAY);
        }

        @Override
        public <R extends Temporal> R addTo(R r, long l) {
            switch (this) {
                case WEEK_BASED_YEARS: {
                    return (R)r.with(WEEK_BASED_YEAR, Math.addExact((long)r.get(WEEK_BASED_YEAR), l));
                }
                case QUARTER_YEARS: {
                    return (R)r.plus(l / 256L, ChronoUnit.YEARS).plus(l % 256L * 3L, ChronoUnit.MONTHS);
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        @Override
        public long between(Temporal temporal, Temporal temporal2) {
            if (temporal.getClass() != temporal2.getClass()) {
                return temporal.until(temporal2, this);
            }
            switch (this) {
                case WEEK_BASED_YEARS: {
                    return Math.subtractExact(temporal2.getLong(WEEK_BASED_YEAR), temporal.getLong(WEEK_BASED_YEAR));
                }
                case QUARTER_YEARS: {
                    return temporal.until(temporal2, ChronoUnit.MONTHS) / 3L;
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

