/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import sun.awt.datatransfer.DataTransferer;

public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static String JavaMIME = "JAVA_DATAFLAVOR:";
    private static final WeakHashMap<ClassLoader, FlavorMap> flavorMaps = new WeakHashMap();
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String[] UNICODE_TEXT_CLASSES = new String[]{"java.io.Reader", "java.lang.String", "java.nio.CharBuffer", "\"[C\""};
    private static final String[] ENCODED_TEXT_CLASSES = new String[]{"java.io.InputStream", "java.nio.ByteBuffer", "\"[B\""};
    private static final String TEXT_PLAIN_BASE_TYPE = "text/plain";
    private static final String HTML_TEXT_BASE_TYPE = "text/html";
    private static final boolean SYNTHESIZE_IF_NOT_FOUND = true;
    private final Map<String, List<DataFlavor>> nativeToFlavor = new HashMap<String, List<DataFlavor>>();
    private final Map<DataFlavor, List<String>> flavorToNative = new HashMap<DataFlavor, List<String>>();
    private boolean isMapInitialized = false;
    private Map<DataFlavor, SoftReference<List<String>>> getNativesForFlavorCache = new HashMap<DataFlavor, SoftReference<List<String>>>();
    private Map<String, SoftReference<List<DataFlavor>>> getFlavorsForNativeCache = new HashMap<String, SoftReference<List<DataFlavor>>>();
    private Set disabledMappingGenerationKeys = new HashSet();
    private static final String[] htmlDocumntTypes = new String[]{"all", "selection", "fragment"};

    private Map<String, List<DataFlavor>> getNativeToFlavor() {
        if (!this.isMapInitialized) {
            this.initSystemFlavorMap();
        }
        return this.nativeToFlavor;
    }

    private synchronized Map<DataFlavor, List<String>> getFlavorToNative() {
        if (!this.isMapInitialized) {
            this.initSystemFlavorMap();
        }
        return this.flavorToNative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlavorMap getDefaultFlavorMap() {
        FlavorMap flavorMap;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        WeakHashMap<ClassLoader, FlavorMap> weakHashMap = flavorMaps;
        synchronized (weakHashMap) {
            flavorMap = flavorMaps.get(classLoader);
            if (flavorMap == null) {
                flavorMap = new SystemFlavorMap();
                flavorMaps.put(classLoader, flavorMap);
            }
        }
        return flavorMap;
    }

    private SystemFlavorMap() {
    }

    private void initSystemFlavorMap() {
        if (this.isMapInitialized) {
            return;
        }
        this.isMapInitialized = true;
        BufferedReader bufferedReader = AccessController.doPrivileged(new PrivilegedAction<BufferedReader>(){

            @Override
            public BufferedReader run() {
                String string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "flavormap.properties";
                try {
                    return new BufferedReader(new InputStreamReader(new File(string).toURI().toURL().openStream(), "ISO-8859-1"));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("MalformedURLException:" + malformedURLException + " while loading default flavormap.properties file:" + string);
                }
                catch (IOException iOException) {
                    System.err.println("IOException:" + iOException + " while loading default flavormap.properties file:" + string);
                }
                return null;
            }
        });
        BufferedReader bufferedReader2 = AccessController.doPrivileged(new PrivilegedAction<BufferedReader>(){

            @Override
            public BufferedReader run() {
                String string = Toolkit.getProperty("AWT.DnD.flavorMapFileURL", null);
                if (string == null) {
                    return null;
                }
                try {
                    return new BufferedReader(new InputStreamReader(new URL(string).openStream(), "ISO-8859-1"));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("MalformedURLException:" + malformedURLException + " while reading AWT.DnD.flavorMapFileURL:" + string);
                }
                catch (IOException iOException) {
                    System.err.println("IOException:" + iOException + " while reading AWT.DnD.flavorMapFileURL:" + string);
                }
                return null;
            }
        });
        if (bufferedReader != null) {
            try {
                this.parseAndStoreReader(bufferedReader);
            }
            catch (IOException iOException) {
                System.err.println("IOException:" + iOException + " while parsing default flavormap.properties file");
            }
        }
        if (bufferedReader2 != null) {
            try {
                this.parseAndStoreReader(bufferedReader2);
            }
            catch (IOException iOException) {
                System.err.println("IOException:" + iOException + " while parsing AWT.DnD.flavorMapFileURL");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseAndStoreReader(BufferedReader var1_1) throws IOException {
        block6: while (true) {
            block20: {
                if ((var2_2 = var1_1.readLine()) == null) {
                    return;
                }
                if (var2_2.length() <= 0 || (var3_3 = var2_2.charAt(0)) == '#' || var3_3 == '!') continue;
                while (this.continueLine(var2_2)) {
                    var4_5 = var1_1.readLine();
                    if (var4_5 == null) {
                        var4_5 = "";
                    }
                    var5_7 = var2_2.substring(0, var2_2.length() - 1);
                    for (var6_8 = 0; var6_8 < var4_5.length() && " \t\r\n\f".indexOf(var4_5.charAt(var6_8)) != -1; ++var6_8) {
                    }
                    var4_5 = var4_5.substring(var6_8, var4_5.length());
                    var2_2 = var5_7 + var4_5;
                }
                var4_4 = var2_2.length();
                for (var5_6 = 0; var5_6 < var4_4 && " \t\r\n\f".indexOf(var2_2.charAt(var5_6)) != -1; ++var5_6) {
                }
                if (var5_6 == var4_4) continue;
                for (var6_8 = var5_6; var6_8 < var4_4; ++var6_8) {
                    var7_9 = var2_2.charAt(var6_8);
                    if (var7_9 == 92) {
                        ++var6_8;
                        continue;
                    }
                    if ("=: \t\r\n\f".indexOf(var7_9) != -1) break;
                }
                for (var7_9 = var6_8; var7_9 < var4_4 && " \t\r\n\f".indexOf(var2_2.charAt(var7_9)) != -1; ++var7_9) {
                }
                if (var7_9 < var4_4 && "=:".indexOf(var2_2.charAt(var7_9)) != -1) {
                    ++var7_9;
                }
                while (var7_9 < var4_4 && " \t\r\n\f".indexOf(var2_2.charAt(var7_9)) != -1) {
                    ++var7_9;
                }
                var8_10 = var2_2.substring(var5_6, var6_8);
                var9_11 = var6_8 < var4_4 ? var2_2.substring(var7_9, var4_4) : "";
                var8_10 = this.loadConvert(var8_10);
                var9_11 = this.loadConvert(var9_11);
                try {
                    var10_12 = new MimeType(var9_11);
                    if (!"text".equals(var10_12.getPrimaryType())) break block20;
                    var11_14 = var10_12.getParameter("charset");
                    if (DataTransferer.doesSubtypeSupportCharset(var10_12.getSubType(), (String)var11_14) && (var12_16 = DataTransferer.getInstance()) != null) {
                        var12_16.registerTextFlavorProperties(var8_10, (String)var11_14, var10_12.getParameter("eoln"), var10_12.getParameter("terminators"));
                    }
                    var10_12.removeParameter("charset");
                    var10_12.removeParameter("class");
                    var10_12.removeParameter("eoln");
                    var10_12.removeParameter("terminators");
                    var9_11 = var10_12.toString();
                }
                catch (MimeTypeParseException var10_13) {
                    var10_13.printStackTrace();
                    continue;
                }
            }
            try {
                var10_12 = new DataFlavor(var9_11);
            }
            catch (Exception var11_15) {
                try {
                    var10_12 = new DataFlavor(var9_11, (String)null);
                }
                catch (Exception var12_17) {
                    var12_17.printStackTrace();
                    continue;
                }
            }
            var11_14 = new LinkedHashSet<E>();
            var11_14.add(var10_12);
            if ("text".equals(var10_12.getPrimaryType())) {
                var11_14.addAll(SystemFlavorMap.convertMimeTypeToDataFlavors(var9_11));
            }
            var12_16 = var11_14.iterator();
            while (true) {
                if (var12_16.hasNext()) ** break;
                continue block6;
                var13_18 = (DataFlavor)var12_16.next();
                this.store(var13_18, var8_10, this.getFlavorToNative());
                this.store(var8_10, var13_18, this.getNativeToFlavor());
            }
            break;
        }
    }

    private boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private String loadConvert(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuilder.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuilder.append((char)n3);
                continue;
            }
            stringBuilder.append((char)n3);
        }
        return stringBuilder.toString();
    }

    private <H, L> void store(H h, L l, Map<H, List<L>> map) {
        List<L> list = map.get(h);
        if (list == null) {
            list = new ArrayList<L>(1);
            map.put(h, list);
        }
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    private List<DataFlavor> nativeToFlavorLookup(String string) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = this.getNativeToFlavor().get(string);
        if (string != null && !this.disabledMappingGenerationKeys.contains(string) && (object2 = DataTransferer.getInstance()) != null && !(object = ((DataTransferer)object2).getPlatformMappingsForNative(string)).isEmpty()) {
            if (arrayList != null) {
                object.removeAll(new HashSet(arrayList));
                object.addAll(arrayList);
            }
            arrayList = object;
        }
        if (arrayList == null && SystemFlavorMap.isJavaMIMEType(string)) {
            object2 = SystemFlavorMap.decodeJavaMIMEType(string);
            object = null;
            try {
                object = new DataFlavor((String)object2);
            }
            catch (Exception exception) {
                System.err.println("Exception \"" + exception.getClass().getName() + ": " + exception.getMessage() + "\"while constructing DataFlavor for: " + (String)object2);
            }
            if (object != null) {
                arrayList = new ArrayList<Object>(1);
                this.getNativeToFlavor().put(string, arrayList);
                arrayList.add(object);
                this.getFlavorsForNativeCache.remove(string);
                this.getFlavorsForNativeCache.remove(null);
                List<String> list = this.getFlavorToNative().get(object);
                if (list == null) {
                    list = new ArrayList<String>(1);
                    this.getFlavorToNative().put((DataFlavor)object, list);
                }
                list.add(string);
                this.getNativesForFlavorCache.remove(object);
                this.getNativesForFlavorCache.remove(null);
            }
        }
        return arrayList != null ? arrayList : new ArrayList(0);
    }

    private List<String> flavorToNativeLookup(DataFlavor dataFlavor, boolean bl) {
        List<DataFlavor> list;
        Object object;
        List<DataFlavor> list2 = this.getFlavorToNative().get(dataFlavor);
        if (dataFlavor != null && !this.disabledMappingGenerationKeys.contains(dataFlavor) && (object = DataTransferer.getInstance()) != null && !(list = ((DataTransferer)object).getPlatformMappingsForFlavor(dataFlavor)).isEmpty()) {
            if (list2 != null) {
                list.removeAll(new HashSet(list2));
                list.addAll(list2);
            }
            list2 = list;
        }
        if (list2 == null) {
            if (bl) {
                object = SystemFlavorMap.encodeDataFlavor(dataFlavor);
                list2 = new ArrayList<String>(1);
                this.getFlavorToNative().put(dataFlavor, list2);
                list2.add((DataFlavor)object);
                this.getNativesForFlavorCache.remove(dataFlavor);
                this.getNativesForFlavorCache.remove(null);
                list = this.getNativeToFlavor().get(object);
                if (list == null) {
                    list = new ArrayList<DataFlavor>(1);
                    this.getNativeToFlavor().put((String)object, list);
                }
                list.add(dataFlavor);
                this.getFlavorsForNativeCache.remove(object);
                this.getFlavorsForNativeCache.remove(null);
            } else {
                list2 = new ArrayList<String>(0);
            }
        }
        return list2;
    }

    @Override
    public synchronized List<String> getNativesForFlavor(DataFlavor dataFlavor) {
        List<String> list = null;
        SoftReference<List<String>> softReference = this.getNativesForFlavorCache.get(dataFlavor);
        if (softReference != null && (list = softReference.get()) != null) {
            return new ArrayList<String>(list);
        }
        if (dataFlavor == null) {
            list = new ArrayList<String>(this.getNativeToFlavor().keySet());
        } else if (this.disabledMappingGenerationKeys.contains(dataFlavor)) {
            list = this.flavorToNativeLookup(dataFlavor, false);
        } else if (DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            List<String> list2;
            if ("text".equals(dataFlavor.getPrimaryType()) && (list = this.getAllNativesForType(dataFlavor.mimeType.getBaseType())) != null) {
                list = new ArrayList<String>(list);
            }
            if ((list2 = this.getAllNativesForType(TEXT_PLAIN_BASE_TYPE)) != null && !list2.isEmpty()) {
                list2 = new ArrayList<String>(list2);
                if (list != null && !list.isEmpty()) {
                    list2.removeAll(new HashSet<String>(list));
                    list.addAll(list2);
                } else {
                    list = list2;
                }
            }
            if (list == null || list.isEmpty()) {
                list = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                List<String> list3 = this.flavorToNativeLookup(dataFlavor, false);
                if (!list3.isEmpty()) {
                    list3 = new ArrayList<String>(list3);
                    list3.removeAll(new HashSet<String>(list));
                    list.addAll(list3);
                }
            }
        } else if (DataTransferer.isFlavorNoncharsetTextType(dataFlavor)) {
            list = this.getAllNativesForType(dataFlavor.mimeType.getBaseType());
            if (list == null || list.isEmpty()) {
                list = this.flavorToNativeLookup(dataFlavor, true);
            } else {
                List<String> list4 = this.flavorToNativeLookup(dataFlavor, false);
                if (!list4.isEmpty()) {
                    list = new ArrayList<String>(list);
                    list4 = new ArrayList<String>(list4);
                    list4.removeAll(new HashSet<String>(list));
                    list.addAll(list4);
                }
            }
        } else {
            list = this.flavorToNativeLookup(dataFlavor, true);
        }
        this.getNativesForFlavorCache.put(dataFlavor, new SoftReference<List<String>>(list));
        return new ArrayList<String>(list);
    }

    @Override
    public synchronized List<DataFlavor> getFlavorsForNative(String string) {
        List<Object> list;
        Collection<DataFlavor> collection;
        SoftReference<List<DataFlavor>> softReference = this.getFlavorsForNativeCache.get(string);
        if (softReference != null && (collection = softReference.get()) != null) {
            return new ArrayList<DataFlavor>(collection);
        }
        collection = new LinkedHashSet();
        if (string == null) {
            list = this.getNativesForFlavor(null);
            for (String string2 : list) {
                List<DataFlavor> list2 = this.getFlavorsForNative(string2);
                for (DataFlavor dataFlavor : list2) {
                    ((HashSet)collection).add(dataFlavor);
                }
            }
        } else {
            list = this.nativeToFlavorLookup(string);
            if (this.disabledMappingGenerationKeys.contains(string)) {
                return list;
            }
            List<DataFlavor> list3 = this.nativeToFlavorLookup(string);
            for (DataFlavor dataFlavor : list3) {
                ((HashSet)collection).add(dataFlavor);
                if (!"text".equals(dataFlavor.getPrimaryType())) continue;
                try {
                    ((AbstractCollection)collection).addAll(SystemFlavorMap.convertMimeTypeToDataFlavors(new MimeType(dataFlavor.getMimeType()).getBaseType()));
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    mimeTypeParseException.printStackTrace();
                }
            }
        }
        list = new ArrayList<DataFlavor>(collection);
        this.getFlavorsForNativeCache.put(string, new SoftReference<List<Object>>(list));
        return new ArrayList<Object>(list);
    }

    private static Set<DataFlavor> convertMimeTypeToDataFlavors(String string) {
        String string2;
        LinkedHashSet<DataFlavor> linkedHashSet;
        block19: {
            linkedHashSet = new LinkedHashSet<DataFlavor>();
            string2 = null;
            try {
                String[] stringArray = new MimeType(string);
                string2 = stringArray.getSubType();
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                if ($assertionsDisabled) break block19;
                throw new AssertionError();
            }
        }
        if (DataTransferer.doesSubtypeSupportCharset(string2, null)) {
            Object object;
            if (TEXT_PLAIN_BASE_TYPE.equals(string)) {
                linkedHashSet.add(DataFlavor.stringFlavor);
            }
            for (String string3 : UNICODE_TEXT_CLASSES) {
                String string4 = string + ";charset=Unicode;class=" + string3;
                LinkedHashSet<String> object4 = SystemFlavorMap.handleHtmlMimeTypes(string, string4);
                for (Object object2 : object4) {
                    object = null;
                    try {
                        object = new DataFlavor((String)object2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    linkedHashSet.add((DataFlavor)object);
                }
            }
            for (String string5 : DataTransferer.standardEncodings()) {
                for (String string3 : ENCODED_TEXT_CLASSES) {
                    Object object2;
                    String string4 = string + ";charset=" + string5 + ";class=" + string3;
                    object2 = SystemFlavorMap.handleHtmlMimeTypes(string, string4);
                    object = ((HashSet)object2).iterator();
                    while (object.hasNext()) {
                        String string6 = (String)object.next();
                        DataFlavor dataFlavor = null;
                        try {
                            dataFlavor = new DataFlavor(string6);
                            if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
                                dataFlavor = DataFlavor.plainTextFlavor;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        linkedHashSet.add(dataFlavor);
                    }
                }
            }
            if (TEXT_PLAIN_BASE_TYPE.equals(string)) {
                linkedHashSet.add(DataFlavor.plainTextFlavor);
            }
        } else {
            for (String string7 : ENCODED_TEXT_CLASSES) {
                DataFlavor dataFlavor = null;
                try {
                    dataFlavor = new DataFlavor(string + ";class=" + string7);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                linkedHashSet.add(dataFlavor);
            }
        }
        return linkedHashSet;
    }

    private static LinkedHashSet<String> handleHtmlMimeTypes(String string, String string2) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (HTML_TEXT_BASE_TYPE.equals(string)) {
            for (String string3 : htmlDocumntTypes) {
                linkedHashSet.add(string2 + ";document=" + string3);
            }
        } else {
            linkedHashSet.add(string2);
        }
        return linkedHashSet;
    }

    @Override
    public synchronized Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        Object object;
        if (dataFlavorArray == null) {
            object = this.getFlavorsForNative(null);
            dataFlavorArray = new DataFlavor[object.size()];
            object.toArray(dataFlavorArray);
        }
        object = new HashMap(dataFlavorArray.length, 1.0f);
        for (DataFlavor dataFlavor : dataFlavorArray) {
            List<String> list = this.getNativesForFlavor(dataFlavor);
            String string = list.isEmpty() ? null : list.get(0);
            object.put(dataFlavor, string);
        }
        return object;
    }

    @Override
    public synchronized Map<String, DataFlavor> getFlavorsForNatives(String[] stringArray) {
        Object object;
        if (stringArray == null) {
            object = this.getNativesForFlavor(null);
            stringArray = new String[object.size()];
            object.toArray(stringArray);
        }
        object = new HashMap(stringArray.length, 1.0f);
        for (String string : stringArray) {
            List<DataFlavor> list = this.getFlavorsForNative(string);
            DataFlavor dataFlavor = list.isEmpty() ? null : list.get(0);
            object.put(string, dataFlavor);
        }
        return object;
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor dataFlavor, String string) {
        if (dataFlavor == null || string == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        List<String> list = this.getFlavorToNative().get(dataFlavor);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.getFlavorToNative().put(dataFlavor, list);
        } else if (list.contains(string)) {
            return;
        }
        list.add(string);
        this.getNativesForFlavorCache.remove(dataFlavor);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void setNativesForFlavor(DataFlavor dataFlavor, String[] stringArray) {
        if (dataFlavor == null || stringArray == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.getFlavorToNative().remove(dataFlavor);
        for (String string : stringArray) {
            this.addUnencodedNativeForFlavor(dataFlavor, string);
        }
        this.disabledMappingGenerationKeys.add(dataFlavor);
        this.getNativesForFlavorCache.remove(dataFlavor);
        this.getNativesForFlavorCache.remove(null);
    }

    public synchronized void addFlavorForUnencodedNative(String string, DataFlavor dataFlavor) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        List<DataFlavor> list = this.getNativeToFlavor().get(string);
        if (list == null) {
            list = new ArrayList<DataFlavor>(1);
            this.getNativeToFlavor().put(string, list);
        } else if (list.contains(dataFlavor)) {
            return;
        }
        list.add(dataFlavor);
        this.getFlavorsForNativeCache.remove(string);
        this.getFlavorsForNativeCache.remove(null);
    }

    public synchronized void setFlavorsForNative(String string, DataFlavor[] dataFlavorArray) {
        if (string == null || dataFlavorArray == null) {
            throw new NullPointerException("null arguments not permitted");
        }
        this.getNativeToFlavor().remove(string);
        for (DataFlavor dataFlavor : dataFlavorArray) {
            this.addFlavorForUnencodedNative(string, dataFlavor);
        }
        this.disabledMappingGenerationKeys.add(string);
        this.getFlavorsForNativeCache.remove(string);
        this.getFlavorsForNativeCache.remove(null);
    }

    public static String encodeJavaMIMEType(String string) {
        return string != null ? JavaMIME + string : null;
    }

    public static String encodeDataFlavor(DataFlavor dataFlavor) {
        return dataFlavor != null ? SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType()) : null;
    }

    public static boolean isJavaMIMEType(String string) {
        return string != null && string.startsWith(JavaMIME, 0);
    }

    public static String decodeJavaMIMEType(String string) {
        return SystemFlavorMap.isJavaMIMEType(string) ? string.substring(JavaMIME.length(), string.length()).trim() : null;
    }

    public static DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
        return string2 != null ? new DataFlavor(string2) : null;
    }

    private List<String> getAllNativesForType(String string) {
        LinkedHashSet<String> linkedHashSet = null;
        for (DataFlavor dataFlavor : SystemFlavorMap.convertMimeTypeToDataFlavors(string)) {
            List<String> list = this.getFlavorToNative().get(dataFlavor);
            if (list == null || list.isEmpty()) continue;
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet<String>();
            }
            linkedHashSet.addAll(list);
        }
        return linkedHashSet == null ? null : new ArrayList(linkedHashSet);
    }
}

