/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.xml;

import com.sun.istack.internal.Nullable;
import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.xml.NamedNodeMapIterator;
import com.sun.xml.internal.ws.util.xml.NodeListIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlUtil {
    private static final String ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final Logger LOGGER = Logger.getLogger(XmlUtil.class.getName());
    private static boolean XML_SECURITY_DISABLED;
    static final TransformerFactory transformerFactory;
    static final SAXParserFactory saxParserFactory;
    public static final ErrorHandler DRACONIAN_ERROR_HANDLER;

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getAttributeOrNull(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getAttributeNSOrNull(Element element, String string, String string2) {
        Attr attr = element.getAttributeNodeNS(string2, string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getAttributeNSOrNull(Element element, QName qName) {
        Attr attr = element.getAttributeNodeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static Iterator getAllChildren(Element element) {
        return new NodeListIterator(element.getChildNodes());
    }

    public static Iterator getAllAttributes(Element element) {
        return new NamedNodeMapIterator(element.getAttributes());
    }

    public static List<String> parseTokenList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String getTextForNode(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof Text) {
                stringBuilder.append(node2.getNodeValue());
                continue;
            }
            if (node2 instanceof EntityReference) {
                String string = XmlUtil.getTextForNode(node2);
                if (string == null) {
                    return null;
                }
                stringBuilder.append(string);
                continue;
            }
            return null;
        }
        return stringBuilder.toString();
    }

    public static InputStream getUTF8Stream(String string) {
        try {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayBuffer, "utf-8");
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
            return byteArrayBuffer.newInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException("should not happen");
        }
    }

    public static Transformer newTransformer() {
        try {
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException("Unable to create a JAXP transformer");
        }
    }

    public static <T extends Result> T identityTransform(Source source, T t) throws TransformerException, SAXException, ParserConfigurationException, IOException {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            TransformerHandler transformerHandler = ((SAXTransformerFactory)transformerFactory).newTransformerHandler();
            transformerHandler.setResult(t);
            XMLReader xMLReader = saxParserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(transformerHandler);
            xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY, transformerHandler);
            xMLReader.parse(XmlUtil.toInputSource(streamSource));
        } else {
            XmlUtil.newTransformer().transform(source, t);
        }
        return t;
    }

    private static InputSource toInputSource(StreamSource streamSource) {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(streamSource.getInputStream());
        inputSource.setCharacterStream(streamSource.getReader());
        inputSource.setPublicId(streamSource.getPublicId());
        inputSource.setSystemId(streamSource.getSystemId());
        return inputSource;
    }

    public static EntityResolver createEntityResolver(@Nullable URL uRL) {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        Catalog catalog = catalogManager.getCatalog();
        try {
            if (uRL != null) {
                catalog.parseCatalog(uRL);
            }
        }
        catch (IOException iOException) {
            throw new ServerRtException("server.rt.err", new Object[]{iOException});
        }
        return XmlUtil.workaroundCatalogResolver(catalog);
    }

    public static EntityResolver createDefaultCatalogResolver() {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Catalog catalog = catalogManager.getCatalog();
        try {
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources("META-INF/jax-ws-catalog.xml") : classLoader.getResources("META-INF/jax-ws-catalog.xml");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                catalog.parseCatalog(uRL);
            }
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return XmlUtil.workaroundCatalogResolver(catalog);
    }

    private static CatalogResolver workaroundCatalogResolver(final Catalog catalog) {
        CatalogManager catalogManager = new CatalogManager(){

            @Override
            public Catalog getCatalog() {
                return catalog;
            }
        };
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        return new CatalogResolver(catalogManager);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        return XmlUtil.newDocumentBuilderFactory(true);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(boolean bl) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlUtil.isXMLSecurityDisabled(bl));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.log(Level.WARNING, "Factory [{0}] doesn't support secure xml processing!", new Object[]{documentBuilderFactory.getClass().getName()});
        }
        return documentBuilderFactory;
    }

    public static TransformerFactory newTransformerFactory(boolean bl) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlUtil.isXMLSecurityDisabled(bl));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LOGGER.log(Level.WARNING, "Factory [{0}] doesn't support secure xml processing!", new Object[]{transformerFactory.getClass().getName()});
        }
        return transformerFactory;
    }

    public static TransformerFactory newTransformerFactory() {
        return XmlUtil.newTransformerFactory(true);
    }

    public static SAXParserFactory newSAXParserFactory(boolean bl) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlUtil.isXMLSecurityDisabled(bl));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Factory [{0}] doesn't support secure xml processing!", new Object[]{sAXParserFactory.getClass().getName()});
        }
        return sAXParserFactory;
    }

    public static XPathFactory newXPathFactory(boolean bl) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        try {
            xPathFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlUtil.isXMLSecurityDisabled(bl));
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            LOGGER.log(Level.WARNING, "Factory [{0}] doesn't support secure xml processing!", new Object[]{xPathFactory.getClass().getName()});
        }
        return xPathFactory;
    }

    public static XMLInputFactory newXMLInputFactory(boolean bl) {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        if (XmlUtil.isXMLSecurityDisabled(bl)) {
            xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
            xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        return xMLInputFactory;
    }

    private static boolean isXMLSecurityDisabled(boolean bl) {
        return XML_SECURITY_DISABLED || bl;
    }

    public static SchemaFactory allowExternalAccess(SchemaFactory schemaFactory, String string, boolean bl) {
        block7: {
            if (XmlUtil.isXMLSecurityDisabled(bl)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Xml Security disabled, no JAXP xsd external access configuration necessary.");
                }
                return schemaFactory;
            }
            if (System.getProperty("javax.xml.accessExternalSchema") != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Detected explicitly JAXP configuration, no JAXP xsd external access configuration necessary.");
                }
                return schemaFactory;
            }
            try {
                schemaFactory.setProperty(ACCESS_EXTERNAL_SCHEMA, string);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Property \"{0}\" is supported and has been successfully set by used JAXP implementation.", new Object[]{ACCESS_EXTERNAL_SCHEMA});
                }
            }
            catch (SAXException sAXException) {
                if (!LOGGER.isLoggable(Level.CONFIG)) break block7;
                LOGGER.log(Level.CONFIG, "Property \"{0}\" is not supported by used JAXP implementation.", new Object[]{ACCESS_EXTERNAL_SCHEMA});
            }
        }
        return schemaFactory;
    }

    static {
        String string = System.getProperty("com.sun.xml.internal.ws.disableXmlSecurity");
        XML_SECURITY_DISABLED = string == null || Boolean.valueOf(string) == false;
        transformerFactory = XmlUtil.newTransformerFactory();
        saxParserFactory = XmlUtil.newSAXParserFactory(true);
        saxParserFactory.setNamespaceAware(true);
        DRACONIAN_ERROR_HANDLER = new ErrorHandler(){

            @Override
            public void warning(SAXParseException sAXParseException) {
            }

            @Override
            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }
        };
    }
}

