/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.streaming;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.resources.StreamingMessages;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public abstract class XMLStreamReaderFactory {
    private static final Logger LOGGER = Logger.getLogger(XMLStreamReaderFactory.class.getName());
    @NotNull
    private static volatile XMLStreamReaderFactory theInstance;
    private static final String CLASS_NAME_OF_WSTXINPUTFACTORY = "com.ctc.wstx.stax.WstxInputFactory";

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xMLInputFactory;
        block4: {
            xMLInputFactory = null;
            if (XMLStreamReaderFactory.getProperty(XMLStreamReaderFactory.class.getName() + ".woodstox").booleanValue()) {
                try {
                    xMLInputFactory = (XMLInputFactory)Class.forName(CLASS_NAME_OF_WSTXINPUTFACTORY).newInstance();
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, StreamingMessages.WOODSTOX_CANT_LOAD(CLASS_NAME_OF_WSTXINPUTFACTORY), exception);
                }
            }
        }
        if (xMLInputFactory == null) {
            xMLInputFactory = XmlUtil.newXMLInputFactory(true);
        }
        xMLInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        return xMLInputFactory;
    }

    public static void set(XMLStreamReaderFactory xMLStreamReaderFactory) {
        if (xMLStreamReaderFactory == null) {
            throw new IllegalArgumentException();
        }
        theInstance = xMLStreamReaderFactory;
    }

    public static XMLStreamReaderFactory get() {
        return theInstance;
    }

    public static XMLStreamReader create(InputSource inputSource, boolean bl) {
        try {
            if (inputSource.getCharacterStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), inputSource.getCharacterStream(), bl);
            }
            if (inputSource.getByteStream() != null) {
                return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), inputSource.getByteStream(), bl);
            }
            return XMLStreamReaderFactory.get().doCreate(inputSource.getSystemId(), new URL(inputSource.getSystemId()).openStream(), bl);
        }
        catch (IOException iOException) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{iOException});
        }
    }

    public static XMLStreamReader create(@Nullable String string, InputStream inputStream, boolean bl) {
        return XMLStreamReaderFactory.get().doCreate(string, inputStream, bl);
    }

    public static XMLStreamReader create(@Nullable String string, InputStream inputStream, @Nullable String string2, boolean bl) {
        return string2 == null ? XMLStreamReaderFactory.create(string, inputStream, bl) : XMLStreamReaderFactory.get().doCreate(string, inputStream, string2, bl);
    }

    public static XMLStreamReader create(@Nullable String string, Reader reader, boolean bl) {
        return XMLStreamReaderFactory.get().doCreate(string, reader, bl);
    }

    public static void recycle(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderFactory.get().doRecycle(xMLStreamReader);
        if (xMLStreamReader instanceof RecycleAware) {
            ((RecycleAware)((Object)xMLStreamReader)).onRecycled();
        }
    }

    public abstract XMLStreamReader doCreate(String var1, InputStream var2, boolean var3);

    private XMLStreamReader doCreate(String string, InputStream inputStream, @NotNull String string2, boolean bl) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(inputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{unsupportedEncodingException});
        }
        return this.doCreate(string, inputStreamReader, bl);
    }

    public abstract XMLStreamReader doCreate(String var1, Reader var2, boolean var3);

    public abstract void doRecycle(XMLStreamReader var1);

    private static int buildIntegerValue(String string, int n) {
        block4: {
            String string2 = System.getProperty(string);
            if (string2 != null && string2.length() > 0) {
                try {
                    Integer n2 = Integer.parseInt(string2);
                    if (n2 > 0) {
                        return n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, StreamingMessages.INVALID_PROPERTY_VALUE_INTEGER(string, string2, Integer.toString(n)), numberFormatException);
                }
            }
        }
        return n;
    }

    private static long buildLongValue(String string, long l) {
        block4: {
            String string2 = System.getProperty(string);
            if (string2 != null && string2.length() > 0) {
                try {
                    long l2 = Long.parseLong(string2);
                    if (l2 > 0L) {
                        return l2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, StreamingMessages.INVALID_PROPERTY_VALUE_LONG(string, string2, Long.toString(l)), numberFormatException);
                }
            }
        }
        return l;
    }

    private static Boolean getProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String string2 = System.getProperty(string);
                return string2 != null ? Boolean.valueOf(string2) : Boolean.FALSE;
            }
        });
    }

    static {
        XMLInputFactory xMLInputFactory = XMLStreamReaderFactory.getXMLInputFactory();
        XMLStreamReaderFactory xMLStreamReaderFactory = null;
        if (!XMLStreamReaderFactory.getProperty(XMLStreamReaderFactory.class.getName() + ".noPool").booleanValue()) {
            xMLStreamReaderFactory = Zephyr.newInstance(xMLInputFactory);
        }
        if (xMLStreamReaderFactory == null && xMLInputFactory.getClass().getName().equals(CLASS_NAME_OF_WSTXINPUTFACTORY)) {
            xMLStreamReaderFactory = new Woodstox(xMLInputFactory);
        }
        if (xMLStreamReaderFactory == null) {
            xMLStreamReaderFactory = new Default();
        }
        theInstance = xMLStreamReaderFactory;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "XMLStreamReaderFactory instance is = {0}", theInstance);
        }
    }

    public static final class Default
    extends XMLStreamReaderFactory {
        private final ThreadLocal<XMLInputFactory> xif = new ThreadLocal<XMLInputFactory>(){

            @Override
            public XMLInputFactory initialValue() {
                return XMLStreamReaderFactory.getXMLInputFactory();
            }
        };

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                return this.xif.get().createXMLStreamReader(string, inputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                return this.xif.get().createXMLStreamReader(string, reader);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public void doRecycle(XMLStreamReader xMLStreamReader) {
        }
    }

    public static class NoLock
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;

        public NoLock(XMLInputFactory xMLInputFactory) {
            this.xif = xMLInputFactory;
        }

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                return this.xif.createXMLStreamReader(string, inputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                return this.xif.createXMLStreamReader(string, reader);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public void doRecycle(XMLStreamReader xMLStreamReader) {
        }
    }

    public static interface RecycleAware {
        public void onRecycled();
    }

    public static final class Woodstox
    extends NoLock {
        public static final String PROPERTY_MAX_ATTRIBUTES_PER_ELEMENT = "xml.ws.maximum.AttributesPerElement";
        public static final String PROPERTY_MAX_ATTRIBUTE_SIZE = "xml.ws.maximum.AttributeSize";
        public static final String PROPERTY_MAX_CHILDREN_PER_ELEMENT = "xml.ws.maximum.ChildrenPerElement";
        public static final String PROPERTY_MAX_ELEMENT_COUNT = "xml.ws.maximum.ElementCount";
        public static final String PROPERTY_MAX_ELEMENT_DEPTH = "xml.ws.maximum.ElementDepth";
        public static final String PROPERTY_MAX_CHARACTERS = "xml.ws.maximum.Characters";
        private static final int DEFAULT_MAX_ATTRIBUTES_PER_ELEMENT = 500;
        private static final int DEFAULT_MAX_ATTRIBUTE_SIZE = 524288;
        private static final int DEFAULT_MAX_CHILDREN_PER_ELEMENT = Integer.MAX_VALUE;
        private static final int DEFAULT_MAX_ELEMENT_DEPTH = 500;
        private static final long DEFAULT_MAX_ELEMENT_COUNT = Integer.MAX_VALUE;
        private static final long DEFAULT_MAX_CHARACTERS = Long.MAX_VALUE;
        private int maxAttributesPerElement = 500;
        private int maxAttributeSize = 524288;
        private int maxChildrenPerElement = Integer.MAX_VALUE;
        private int maxElementDepth = 500;
        private long maxElementCount = Integer.MAX_VALUE;
        private long maxCharacters = Long.MAX_VALUE;
        private static final String P_MAX_ATTRIBUTES_PER_ELEMENT = "com.ctc.wstx.maxAttributesPerElement";
        private static final String P_MAX_ATTRIBUTE_SIZE = "com.ctc.wstx.maxAttributeSize";
        private static final String P_MAX_CHILDREN_PER_ELEMENT = "com.ctc.wstx.maxChildrenPerElement";
        private static final String P_MAX_ELEMENT_COUNT = "com.ctc.wstx.maxElementCount";
        private static final String P_MAX_ELEMENT_DEPTH = "com.ctc.wstx.maxElementDepth";
        private static final String P_MAX_CHARACTERS = "com.ctc.wstx.maxCharacters";
        private static final String P_INTERN_NSURIS = "org.codehaus.stax2.internNsUris";

        public Woodstox(XMLInputFactory xMLInputFactory) {
            super(xMLInputFactory);
            if (xMLInputFactory.isPropertySupported(P_INTERN_NSURIS)) {
                xMLInputFactory.setProperty(P_INTERN_NSURIS, true);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "org.codehaus.stax2.internNsUris is {0}", true);
                }
            }
            if (xMLInputFactory.isPropertySupported(P_MAX_ATTRIBUTES_PER_ELEMENT)) {
                this.maxAttributesPerElement = XMLStreamReaderFactory.buildIntegerValue(PROPERTY_MAX_ATTRIBUTES_PER_ELEMENT, 500);
                xMLInputFactory.setProperty(P_MAX_ATTRIBUTES_PER_ELEMENT, this.maxAttributesPerElement);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "com.ctc.wstx.maxAttributesPerElement is {0}", this.maxAttributesPerElement);
                }
            }
            if (xMLInputFactory.isPropertySupported(P_MAX_ATTRIBUTE_SIZE)) {
                this.maxAttributeSize = XMLStreamReaderFactory.buildIntegerValue(PROPERTY_MAX_ATTRIBUTE_SIZE, 524288);
                xMLInputFactory.setProperty(P_MAX_ATTRIBUTE_SIZE, this.maxAttributeSize);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "com.ctc.wstx.maxAttributeSize is {0}", this.maxAttributeSize);
                }
            }
            if (xMLInputFactory.isPropertySupported(P_MAX_CHILDREN_PER_ELEMENT)) {
                this.maxChildrenPerElement = XMLStreamReaderFactory.buildIntegerValue(PROPERTY_MAX_CHILDREN_PER_ELEMENT, Integer.MAX_VALUE);
                xMLInputFactory.setProperty(P_MAX_CHILDREN_PER_ELEMENT, this.maxChildrenPerElement);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "com.ctc.wstx.maxChildrenPerElement is {0}", this.maxChildrenPerElement);
                }
            }
            if (xMLInputFactory.isPropertySupported(P_MAX_ELEMENT_DEPTH)) {
                this.maxElementDepth = XMLStreamReaderFactory.buildIntegerValue(PROPERTY_MAX_ELEMENT_DEPTH, 500);
                xMLInputFactory.setProperty(P_MAX_ELEMENT_DEPTH, this.maxElementDepth);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "com.ctc.wstx.maxElementDepth is {0}", this.maxElementDepth);
                }
            }
            if (xMLInputFactory.isPropertySupported(P_MAX_ELEMENT_COUNT)) {
                this.maxElementCount = XMLStreamReaderFactory.buildLongValue(PROPERTY_MAX_ELEMENT_COUNT, Integer.MAX_VALUE);
                xMLInputFactory.setProperty(P_MAX_ELEMENT_COUNT, this.maxElementCount);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "com.ctc.wstx.maxElementCount is {0}", this.maxElementCount);
                }
            }
            if (xMLInputFactory.isPropertySupported(P_MAX_CHARACTERS)) {
                this.maxCharacters = XMLStreamReaderFactory.buildLongValue(PROPERTY_MAX_CHARACTERS, Long.MAX_VALUE);
                xMLInputFactory.setProperty(P_MAX_CHARACTERS, this.maxCharacters);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "com.ctc.wstx.maxCharacters is {0}", this.maxCharacters);
                }
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            return super.doCreate(string, inputStream, bl);
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            return super.doCreate(string, reader, bl);
        }
    }

    private static final class Zephyr
    extends XMLStreamReaderFactory {
        private final XMLInputFactory xif;
        private final ThreadLocal<XMLStreamReader> pool = new ThreadLocal();
        private final Method setInputSourceMethod;
        private final Method resetMethod;
        private final Class zephyrClass;

        @Nullable
        public static XMLStreamReaderFactory newInstance(XMLInputFactory xMLInputFactory) {
            try {
                Class<?> clazz = xMLInputFactory.createXMLStreamReader(new StringReader("<foo/>")).getClass();
                if (!clazz.getName().startsWith("com.sun.xml.internal.stream.")) {
                    return null;
                }
                return new Zephyr(xMLInputFactory, clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            catch (XMLStreamException xMLStreamException) {
                return null;
            }
        }

        public Zephyr(XMLInputFactory xMLInputFactory, Class clazz) throws NoSuchMethodException {
            this.zephyrClass = clazz;
            this.setInputSourceMethod = clazz.getMethod("setInputSource", InputSource.class);
            this.resetMethod = clazz.getMethod("reset", new Class[0]);
            try {
                xMLInputFactory.setProperty("reuse-instance", false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.xif = xMLInputFactory;
        }

        @Nullable
        private XMLStreamReader fetch() {
            XMLStreamReader xMLStreamReader = this.pool.get();
            if (xMLStreamReader == null) {
                return null;
            }
            this.pool.set(null);
            return xMLStreamReader;
        }

        @Override
        public void doRecycle(XMLStreamReader xMLStreamReader) {
            if (this.zephyrClass.isInstance(xMLStreamReader)) {
                this.pool.set(xMLStreamReader);
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, InputStream inputStream, boolean bl) {
            try {
                XMLStreamReader xMLStreamReader = this.fetch();
                if (xMLStreamReader == null) {
                    return this.xif.createXMLStreamReader(string, inputStream);
                }
                InputSource inputSource = new InputSource(string);
                inputSource.setByteStream(inputStream);
                this.reuse(xMLStreamReader, inputSource);
                return xMLStreamReader;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{illegalAccessException});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{invocationTargetException});
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        @Override
        public XMLStreamReader doCreate(String string, Reader reader, boolean bl) {
            try {
                XMLStreamReader xMLStreamReader = this.fetch();
                if (xMLStreamReader == null) {
                    return this.xif.createXMLStreamReader(string, reader);
                }
                InputSource inputSource = new InputSource(string);
                inputSource.setCharacterStream(reader);
                this.reuse(xMLStreamReader, inputSource);
                return xMLStreamReader;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{illegalAccessException});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable == null) {
                    throwable = invocationTargetException;
                }
                throw new XMLReaderException("stax.cantCreate", new Object[]{throwable});
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLReaderException("stax.cantCreate", new Object[]{xMLStreamException});
            }
        }

        private void reuse(XMLStreamReader xMLStreamReader, InputSource inputSource) throws IllegalAccessException, InvocationTargetException {
            this.resetMethod.invoke(xMLStreamReader, new Object[0]);
            this.setInputSourceMethod.invoke(xMLStreamReader, inputSource);
        }
    }
}

