/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api;

import com.sun.istack.internal.Nullable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.xml.ws.WebServiceException;

public final class EndpointAddress {
    @Nullable
    private URL url;
    private final URI uri;
    private final String stringForm;
    private volatile boolean dontUseProxyMethod;
    private Proxy proxy;

    public EndpointAddress(URI uRI) {
        this.uri = uRI;
        this.stringForm = uRI.toString();
        try {
            this.initURL();
            this.proxy = this.chooseProxy();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public EndpointAddress(String string) throws URISyntaxException {
        this.uri = new URI(string);
        this.stringForm = string;
        try {
            this.initURL();
            this.proxy = this.chooseProxy();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void initURL() throws MalformedURLException {
        String string = this.uri.getScheme();
        if (string == null) {
            this.url = new URL(this.uri.toString());
            return;
        }
        this.url = "http".equals(string = string.toLowerCase()) || "https".equals(string) ? new URL(this.uri.toASCIIString()) : this.uri.toURL();
    }

    public static EndpointAddress create(String string) {
        try {
            return new EndpointAddress(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new WebServiceException("Illegal endpoint address: " + string, uRISyntaxException);
        }
    }

    private Proxy chooseProxy() {
        ProxySelector proxySelector = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

            @Override
            public ProxySelector run() {
                return ProxySelector.getDefault();
            }
        });
        if (proxySelector == null) {
            return Proxy.NO_PROXY;
        }
        if (!proxySelector.getClass().getName().equals("sun.net.spi.DefaultProxySelector")) {
            return null;
        }
        Iterator<Proxy> iterator = proxySelector.select(this.uri).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return Proxy.NO_PROXY;
    }

    public URL getURL() {
        return this.url;
    }

    public URI getURI() {
        return this.uri;
    }

    public URLConnection openConnection() throws IOException {
        if (this.url == null) {
            throw new WebServiceException("URI=" + this.uri + " doesn't have the corresponding URL");
        }
        if (this.proxy != null && !this.dontUseProxyMethod) {
            try {
                return this.url.openConnection(this.proxy);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.dontUseProxyMethod = true;
            }
        }
        return this.url.openConnection();
    }

    public String toString() {
        return this.stringForm;
    }
}

