/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.output;

import com.sun.xml.internal.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;

public final class Encoded {
    public byte[] buf;
    public int len;
    private static final byte[][] entities = new byte[128][];
    private static final byte[][] attributeEntities = new byte[128][];

    public Encoded() {
    }

    public Encoded(String string) {
        this.set(string);
    }

    public void ensureSize(int n) {
        if (this.buf == null || this.buf.length < n) {
            this.buf = new byte[n];
        }
    }

    public final void set(String string) {
        int n = string.length();
        this.ensureSize(n * 3 + 1);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                if (c > '\u07ff') {
                    if ('\ud800' <= c && c <= '\udfff') {
                        int n3 = ((c & 0x3FF) << 10 | string.charAt(++i) & 0x3FF) + 65536;
                        this.buf[n2++] = (byte)(0xF0 | n3 >> 18);
                        this.buf[n2++] = (byte)(0x80 | n3 >> 12 & 0x3F);
                        this.buf[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                        this.buf[n2++] = (byte)(128 + (n3 & 0x3F));
                        continue;
                    }
                    this.buf[n2++] = (byte)(224 + (c >> 12));
                    this.buf[n2++] = (byte)(128 + (c >> 6 & 0x3F));
                } else {
                    this.buf[n2++] = (byte)(192 + (c >> 6));
                }
                this.buf[n2++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            this.buf[n2++] = (byte)c;
        }
        this.len = n2;
    }

    public final void setEscape(String string, boolean bl) {
        int n = string.length();
        this.ensureSize(n * 6 + 1);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n3 = n2;
            if (c > '\u007f') {
                if (c > '\u07ff') {
                    if ('\ud800' <= c && c <= '\udfff') {
                        int n4 = ((c & 0x3FF) << 10 | string.charAt(++i) & 0x3FF) + 65536;
                        this.buf[n2++] = (byte)(0xF0 | n4 >> 18);
                        this.buf[n2++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                        this.buf[n2++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                        this.buf[n2++] = (byte)(128 + (n4 & 0x3F));
                        continue;
                    }
                    this.buf[n3++] = (byte)(224 + (c >> 12));
                    this.buf[n3++] = (byte)(128 + (c >> 6 & 0x3F));
                } else {
                    this.buf[n3++] = (byte)(192 + (c >> 6));
                }
                this.buf[n3++] = (byte)(128 + (c & 0x3F));
            } else {
                byte[] byArray = attributeEntities[c];
                if (byArray != null) {
                    if (bl || entities[c] != null) {
                        n3 = this.writeEntity(byArray, n3);
                    } else {
                        this.buf[n3++] = (byte)c;
                    }
                } else {
                    this.buf[n3++] = (byte)c;
                }
            }
            n2 = n3;
        }
        this.len = n2;
    }

    private int writeEntity(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.buf, n, byArray.length);
        return n + byArray.length;
    }

    public final void write(UTF8XmlOutput uTF8XmlOutput) throws IOException {
        uTF8XmlOutput.write(this.buf, 0, this.len);
    }

    public void append(char c) {
        this.buf[this.len++] = (byte)c;
    }

    public void compact() {
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        this.buf = byArray;
    }

    private static void add(char c, String string, boolean bl) {
        byte[] byArray = UTF8XmlOutput.toBytes(string);
        Encoded.attributeEntities[c] = byArray;
        if (!bl) {
            Encoded.entities[c] = byArray;
        }
    }

    static {
        Encoded.add('&', "&amp;", false);
        Encoded.add('<', "&lt;", false);
        Encoded.add('>', "&gt;", false);
        Encoded.add('\"', "&quot;", true);
        Encoded.add('\t', "&#x9;", true);
        Encoded.add('\r', "&#xD;", false);
        Encoded.add('\n', "&#xA;", true);
    }
}

