/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.io.ASCIIReader;
import com.sun.org.apache.xerces.internal.impl.io.UCSReader;
import com.sun.org.apache.xerces.internal.impl.io.UTF8Reader;
import com.sun.org.apache.xerces.internal.util.EncodingMap;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLStringBuffer;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.xml.internal.stream.Entity;
import com.sun.xml.internal.stream.XMLBufferListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Vector;

public class XMLEntityScanner
implements XMLLocator {
    protected Entity.ScannedEntity fCurrentEntity = null;
    protected int fBufferSize = 8192;
    protected XMLEntityManager fEntityManager;
    private static final boolean DEBUG_ENCODINGS = false;
    private Vector listeners = new Vector();
    private static final boolean[] VALID_NAMES;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_SKIP_STRING = false;
    private static final EOFException END_OF_DOCUMENT_ENTITY;
    protected SymbolTable fSymbolTable = null;
    protected XMLErrorReporter fErrorReporter = null;
    int[] whiteSpaceLookup = new int[100];
    int whiteSpaceLen = 0;
    boolean whiteSpaceInfoNeeded = true;
    protected boolean fAllowJavaEncodings;
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected PropertyManager fPropertyManager = null;
    boolean isExternal = false;
    boolean xmlVersionSetExplicitly = false;

    public XMLEntityScanner() {
    }

    public XMLEntityScanner(PropertyManager propertyManager, XMLEntityManager xMLEntityManager) {
        this.fEntityManager = xMLEntityManager;
        this.reset(propertyManager);
    }

    public final void setBufferSize(int n) {
        this.fBufferSize = n;
    }

    public void reset(PropertyManager propertyManager) {
        this.fSymbolTable = (SymbolTable)propertyManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty(ERROR_REPORTER);
        this.fCurrentEntity = null;
        this.whiteSpaceLen = 0;
        this.whiteSpaceInfoNeeded = true;
        this.listeners.clear();
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fAllowJavaEncodings = xMLComponentManager.getFeature(ALLOW_JAVA_ENCODINGS, false);
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fCurrentEntity = null;
        this.whiteSpaceLen = 0;
        this.whiteSpaceInfoNeeded = true;
        this.listeners.clear();
    }

    public final void reset(SymbolTable symbolTable, XMLEntityManager xMLEntityManager, XMLErrorReporter xMLErrorReporter) {
        this.fCurrentEntity = null;
        this.fSymbolTable = symbolTable;
        this.fEntityManager = xMLEntityManager;
        this.fErrorReporter = xMLErrorReporter;
    }

    @Override
    public final String getXMLVersion() {
        if (this.fCurrentEntity != null) {
            return this.fCurrentEntity.xmlVersion;
        }
        return null;
    }

    public final void setXMLVersion(String string) {
        this.xmlVersionSetExplicitly = true;
        this.fCurrentEntity.xmlVersion = string;
    }

    public final void setCurrentEntity(Entity.ScannedEntity scannedEntity) {
        this.fCurrentEntity = scannedEntity;
        if (this.fCurrentEntity != null) {
            this.isExternal = this.fCurrentEntity.isExternal();
        }
    }

    public Entity.ScannedEntity getCurrentEntity() {
        return this.fCurrentEntity;
    }

    @Override
    public final String getBaseSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getExpandedSystemId() : null;
    }

    public void setBaseSystemId(String string) {
    }

    @Override
    public final int getLineNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.lineNumber : -1;
    }

    public void setLineNumber(int n) {
    }

    @Override
    public final int getColumnNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.columnNumber : -1;
    }

    public void setColumnNumber(int n) {
    }

    @Override
    public final int getCharacterOffset() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.fTotalCountTillLastLoad + this.fCurrentEntity.position : -1;
    }

    @Override
    public final String getExpandedSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getExpandedSystemId() : null;
    }

    public void setExpandedSystemId(String string) {
    }

    @Override
    public final String getLiteralSystemId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getLiteralSystemId() : null;
    }

    public void setLiteralSystemId(String string) {
    }

    @Override
    public final String getPublicId() {
        return this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null ? this.fCurrentEntity.entityLocation.getPublicId() : null;
    }

    public void setPublicId(String string) {
    }

    public void setVersion(String string) {
        this.fCurrentEntity.version = string;
    }

    public String getVersion() {
        if (this.fCurrentEntity != null) {
            return this.fCurrentEntity.version;
        }
        return null;
    }

    @Override
    public final String getEncoding() {
        if (this.fCurrentEntity != null) {
            return this.fCurrentEntity.encoding;
        }
        return null;
    }

    public final void setEncoding(String string) throws IOException {
        if (!(this.fCurrentEntity.stream == null || this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.equals(string))) {
            if (this.fCurrentEntity.encoding != null && this.fCurrentEntity.encoding.startsWith("UTF-16")) {
                String string2 = string.toUpperCase(Locale.ENGLISH);
                if (string2.equals("UTF-16")) {
                    return;
                }
                if (string2.equals("ISO-10646-UCS-4")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 8) : new UCSReader(this.fCurrentEntity.stream, 4);
                    return;
                }
                if (string2.equals("ISO-10646-UCS-2")) {
                    this.fCurrentEntity.reader = this.fCurrentEntity.encoding.equals("UTF-16BE") ? new UCSReader(this.fCurrentEntity.stream, 2) : new UCSReader(this.fCurrentEntity.stream, 1);
                    return;
                }
            }
            this.fCurrentEntity.reader = this.createReader(this.fCurrentEntity.stream, string, null);
            this.fCurrentEntity.encoding = string;
        }
    }

    public final boolean isExternal() {
        return this.fCurrentEntity.isExternal();
    }

    public int getChar(int n) throws IOException {
        if (this.arrangeCapacity(n + 1, false)) {
            return this.fCurrentEntity.ch[this.fCurrentEntity.position + n];
        }
        return -1;
    }

    public int peekChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        int n = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (this.isExternal) {
            return n != 13 ? n : 10;
        }
        return n;
    }

    public int scanChar() throws IOException {
        int n;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if ((n = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 10 || n == 13 && this.isExternal) {
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = (char)n;
                this.load(1, false);
            }
            if (n == 13 && this.isExternal) {
                if (this.fCurrentEntity.ch[this.fCurrentEntity.position++] != '\n') {
                    --this.fCurrentEntity.position;
                }
                n = 10;
            }
        }
        ++this.fCurrentEntity.columnNumber;
        return n;
    }

    public String scanNmtoken() throws IOException {
        Object object;
        int n;
        char c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        int n2 = this.fCurrentEntity.position;
        boolean bl = false;
        while (bl = (c = this.fCurrentEntity.ch[this.fCurrentEntity.position]) < '\u007f' ? VALID_NAMES[c] : XMLChar.isName(c)) {
            if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            n = this.fCurrentEntity.position - n2;
            this.invokeListeners(n);
            if (n == this.fCurrentEntity.fBufferSize) {
                object = new char[this.fCurrentEntity.fBufferSize * 2];
                System.arraycopy(this.fCurrentEntity.ch, n2, object, 0, n);
                this.fCurrentEntity.ch = (char[])object;
                this.fCurrentEntity.fBufferSize *= 2;
            } else {
                System.arraycopy(this.fCurrentEntity.ch, n2, this.fCurrentEntity.ch, 0, n);
            }
            n2 = 0;
            if (!this.load(n, false)) continue;
            break;
        }
        n = this.fCurrentEntity.position - n2;
        this.fCurrentEntity.columnNumber += n;
        object = null;
        if (n > 0) {
            object = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n2, n);
        }
        return object;
    }

    public String scanName() throws IOException {
        int n;
        int n2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if (XMLChar.isNameStart(this.fCurrentEntity.ch[n2 = this.fCurrentEntity.position++])) {
            char c;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[n2];
                n2 = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    return string;
                }
            }
            n = 0;
            while ((n = (c = this.fCurrentEntity.ch[this.fCurrentEntity.position]) < '\u007f' ? VALID_NAMES[c] : (int)(XMLChar.isName(c) ? 1 : 0)) != 0) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                int n3 = this.fCurrentEntity.position - n2;
                this.invokeListeners(n3);
                if (n3 == this.fCurrentEntity.fBufferSize) {
                    char[] cArray = new char[this.fCurrentEntity.fBufferSize * 2];
                    System.arraycopy(this.fCurrentEntity.ch, n2, cArray, 0, n3);
                    this.fCurrentEntity.ch = cArray;
                    this.fCurrentEntity.fBufferSize *= 2;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, n2, this.fCurrentEntity.ch, 0, n3);
                }
                n2 = 0;
                if (!this.load(n3, false)) continue;
                break;
            }
        }
        n = this.fCurrentEntity.position - n2;
        this.fCurrentEntity.columnNumber += n;
        String string = n > 0 ? this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n2, n) : null;
        return string;
    }

    public boolean scanQName(QName qName) throws IOException {
        int n;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if (XMLChar.isNameStart(this.fCurrentEntity.ch[n = this.fCurrentEntity.position++])) {
            Object object;
            int n2;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[n];
                n = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    qName.setValues(null, string, string, null);
                    return true;
                }
            }
            int n3 = -1;
            boolean bl = false;
            while (bl = (n2 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) < 127 ? VALID_NAMES[n2] : XMLChar.isName(n2)) {
                if (n2 == 58) {
                    if (n3 != -1) break;
                    n3 = this.fCurrentEntity.position;
                }
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                int n4 = this.fCurrentEntity.position - n;
                this.invokeListeners(n4);
                if (n4 == this.fCurrentEntity.fBufferSize) {
                    object = new char[this.fCurrentEntity.fBufferSize * 2];
                    System.arraycopy(this.fCurrentEntity.ch, n, object, 0, n4);
                    this.fCurrentEntity.ch = (char[])object;
                    this.fCurrentEntity.fBufferSize *= 2;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, n, this.fCurrentEntity.ch, 0, n4);
                }
                if (n3 != -1) {
                    n3 -= n;
                }
                n = 0;
                if (!this.load(n4, false)) continue;
                break;
            }
            n2 = this.fCurrentEntity.position - n;
            this.fCurrentEntity.columnNumber += n2;
            if (n2 > 0) {
                String string = null;
                object = null;
                String string2 = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n, n2);
                if (n3 != -1) {
                    int n5 = n3 - n;
                    string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n, n5);
                    int n6 = n2 - n5 - 1;
                    object = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n3 + 1, n6);
                } else {
                    object = string2;
                }
                qName.setValues(string, (String)object, string2, null);
                return true;
            }
        }
        return false;
    }

    public int scanContent(XMLString xMLString) throws IOException {
        int n;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.invokeListeners(0);
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
        }
        int n2 = this.fCurrentEntity.position;
        int n3 = this.fCurrentEntity.ch[n2];
        int n4 = 0;
        if (n3 == 10 || n3 == 13 && this.isExternal) {
            do {
                if ((n3 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && this.isExternal) {
                    ++n4;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        n2 = 0;
                        this.invokeListeners(n4);
                        this.fCurrentEntity.position = n4;
                        if (this.load(n4, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++n2;
                        continue;
                    }
                    ++n4;
                    continue;
                }
                if (n3 == 10) {
                    ++n4;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    n2 = 0;
                    this.invokeListeners(n4);
                    this.fCurrentEntity.position = n4;
                    if (!this.load(n4, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (n = n2; n < this.fCurrentEntity.position; ++n) {
                this.fCurrentEntity.ch[n] = 10;
            }
            n = this.fCurrentEntity.position - n2;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                xMLString.setValues(this.fCurrentEntity.ch, n2, n);
                return -1;
            }
        }
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if (XMLChar.isContent(n3 = this.fCurrentEntity.ch[this.fCurrentEntity.position++])) continue;
            --this.fCurrentEntity.position;
            break;
        }
        n = this.fCurrentEntity.position - n2;
        this.fCurrentEntity.columnNumber += n - n4;
        xMLString.setValues(this.fCurrentEntity.ch, n2, n);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            n3 = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (n3 == 13 && this.isExternal) {
                n3 = 10;
            }
        } else {
            n3 = -1;
        }
        return n3;
    }

    public int scanLiteral(int n, XMLString xMLString) throws IOException {
        int n2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.invokeListeners(0);
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
        }
        int n3 = this.fCurrentEntity.position;
        int n4 = this.fCurrentEntity.ch[n3];
        int n5 = 0;
        if (this.whiteSpaceInfoNeeded) {
            this.whiteSpaceLen = 0;
        }
        if (n4 == 10 || n4 == 13 && this.isExternal) {
            do {
                if ((n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && this.isExternal) {
                    ++n5;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        this.invokeListeners(n5);
                        n3 = 0;
                        this.fCurrentEntity.position = n5;
                        if (this.load(n5, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++n3;
                        continue;
                    }
                    ++n5;
                    continue;
                }
                if (n4 == 10) {
                    ++n5;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    n3 = 0;
                    this.invokeListeners(n5);
                    this.fCurrentEntity.position = n5;
                    if (!this.load(n5, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            n2 = 0;
            for (n2 = n3; n2 < this.fCurrentEntity.position; ++n2) {
                this.fCurrentEntity.ch[n2] = 10;
                this.storeWhiteSpace(n2);
            }
            int n6 = this.fCurrentEntity.position - n3;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                xMLString.setValues(this.fCurrentEntity.ch, n3, n6);
                return -1;
            }
        }
        while (this.fCurrentEntity.position < this.fCurrentEntity.count && ((n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position]) != n || this.fCurrentEntity.literal && !this.isExternal) && n4 != 37 && XMLChar.isContent(n4)) {
            if (this.whiteSpaceInfoNeeded && n4 == 9) {
                this.storeWhiteSpace(this.fCurrentEntity.position);
            }
            ++this.fCurrentEntity.position;
        }
        n2 = this.fCurrentEntity.position - n3;
        this.fCurrentEntity.columnNumber += n2 - n5;
        xMLString.setValues(this.fCurrentEntity.ch, n3, n2);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (n4 == n && this.fCurrentEntity.literal) {
                n4 = -1;
            }
        } else {
            n4 = -1;
        }
        return n4;
    }

    private void storeWhiteSpace(int n) {
        if (this.whiteSpaceLen >= this.whiteSpaceLookup.length) {
            int[] nArray = new int[this.whiteSpaceLookup.length + 100];
            System.arraycopy(this.whiteSpaceLookup, 0, nArray, 0, this.whiteSpaceLookup.length);
            this.whiteSpaceLookup = nArray;
        }
        this.whiteSpaceLookup[this.whiteSpaceLen++] = n;
    }

    public boolean scanData(String string, XMLStringBuffer xMLStringBuffer) throws IOException {
        boolean bl = false;
        int n = string.length();
        char c = string.charAt(0);
        do {
            int n2;
            int n3;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.load(0, true);
            }
            boolean bl2 = false;
            while (this.fCurrentEntity.position > this.fCurrentEntity.count - n && !bl2) {
                System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
                bl2 = this.load(this.fCurrentEntity.count - this.fCurrentEntity.position, false);
                this.fCurrentEntity.position = 0;
                this.fCurrentEntity.startPosition = 0;
            }
            if (this.fCurrentEntity.position > this.fCurrentEntity.count - n) {
                n3 = this.fCurrentEntity.count - this.fCurrentEntity.position;
                xMLStringBuffer.append(this.fCurrentEntity.ch, this.fCurrentEntity.position, n3);
                this.fCurrentEntity.columnNumber += this.fCurrentEntity.count;
                this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                this.fCurrentEntity.position = this.fCurrentEntity.count;
                this.fCurrentEntity.startPosition = this.fCurrentEntity.count;
                this.load(0, true);
                return false;
            }
            n3 = this.fCurrentEntity.position;
            char c2 = this.fCurrentEntity.ch[n3];
            int n4 = 0;
            if (c2 == '\n' || c2 == '\r' && this.isExternal) {
                do {
                    if ((c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == '\r' && this.isExternal) {
                        ++n4;
                        ++this.fCurrentEntity.lineNumber;
                        this.fCurrentEntity.columnNumber = 1;
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                            n3 = 0;
                            this.invokeListeners(n4);
                            this.fCurrentEntity.position = n4;
                            if (this.load(n4, false)) break;
                        }
                        if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                            ++this.fCurrentEntity.position;
                            ++n3;
                            continue;
                        }
                        ++n4;
                        continue;
                    }
                    if (c2 == '\n') {
                        ++n4;
                        ++this.fCurrentEntity.lineNumber;
                        this.fCurrentEntity.columnNumber = 1;
                        if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                        n3 = 0;
                        this.invokeListeners(n4);
                        this.fCurrentEntity.position = n4;
                        this.fCurrentEntity.count = n4;
                        if (!this.load(n4, false)) continue;
                        break;
                    }
                    --this.fCurrentEntity.position;
                    break;
                } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
                for (n2 = n3; n2 < this.fCurrentEntity.position; ++n2) {
                    this.fCurrentEntity.ch[n2] = 10;
                }
                n2 = this.fCurrentEntity.position - n3;
                if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                    xMLStringBuffer.append(this.fCurrentEntity.ch, n3, n2);
                    return true;
                }
            }
            block4: while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                if ((c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == c) {
                    n2 = this.fCurrentEntity.position - 1;
                    for (int i = 1; i < n; ++i) {
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                            this.fCurrentEntity.position -= i;
                            break block4;
                        }
                        c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
                        if (string.charAt(i) == c2) continue;
                        this.fCurrentEntity.position -= i;
                        break;
                    }
                    if (this.fCurrentEntity.position != n2 + n) continue;
                    bl = true;
                    break;
                }
                if (c2 == '\n' || this.isExternal && c2 == '\r') {
                    --this.fCurrentEntity.position;
                    break;
                }
                if (!XMLChar.isInvalid(c2)) continue;
                --this.fCurrentEntity.position;
                n2 = this.fCurrentEntity.position - n3;
                this.fCurrentEntity.columnNumber += n2 - n4;
                xMLStringBuffer.append(this.fCurrentEntity.ch, n3, n2);
                return true;
            }
            n2 = this.fCurrentEntity.position - n3;
            this.fCurrentEntity.columnNumber += n2 - n4;
            if (bl) {
                n2 -= n;
            }
            xMLStringBuffer.append(this.fCurrentEntity.ch, n3, n2);
        } while (!bl);
        return !bl;
    }

    public boolean skipChar(int n) throws IOException {
        char c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == n) {
            ++this.fCurrentEntity.position;
            if (n == 10) {
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
            } else {
                ++this.fCurrentEntity.columnNumber;
            }
            return true;
        }
        if (n == 10 && c == '\r' && this.isExternal) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.invokeListeners(1);
                this.fCurrentEntity.ch[0] = c;
                this.load(1, false);
            }
            ++this.fCurrentEntity.position;
            if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                ++this.fCurrentEntity.position;
            }
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            return true;
        }
        return false;
    }

    public boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    public boolean skipSpaces() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.invokeListeners(0);
            this.load(0, true);
        }
        if (this.fCurrentEntity == null) {
            return false;
        }
        char c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (XMLChar.isSpace(c)) {
            do {
                boolean bl = false;
                if (c == '\n' || this.isExternal && c == '\r') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.invokeListeners(0);
                        this.fCurrentEntity.ch[0] = c;
                        bl = this.load(1, true);
                        if (!bl) {
                            this.fCurrentEntity.position = 0;
                        } else if (this.fCurrentEntity == null) {
                            return true;
                        }
                    }
                    if (c == '\r' && this.isExternal && this.fCurrentEntity.ch[++this.fCurrentEntity.position] != '\n') {
                        --this.fCurrentEntity.position;
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!bl) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.invokeListeners(0);
                this.load(0, true);
                if (this.fCurrentEntity != null) continue;
                return true;
            } while (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position]));
            return true;
        }
        return false;
    }

    public boolean arrangeCapacity(int n) throws IOException {
        return this.arrangeCapacity(n, false);
    }

    public boolean arrangeCapacity(int n, boolean bl) throws IOException {
        if (this.fCurrentEntity.count - this.fCurrentEntity.position >= n) {
            return true;
        }
        boolean bl2 = false;
        while (this.fCurrentEntity.count - this.fCurrentEntity.position < n) {
            if (this.fCurrentEntity.ch.length - this.fCurrentEntity.position < n) {
                this.invokeListeners(0);
                System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
                this.fCurrentEntity.count -= this.fCurrentEntity.position;
                this.fCurrentEntity.position = 0;
            }
            if (this.fCurrentEntity.count - this.fCurrentEntity.position >= n) continue;
            int n2 = this.fCurrentEntity.position;
            this.invokeListeners(n2);
            bl2 = this.load(this.fCurrentEntity.count, bl);
            this.fCurrentEntity.position = n2;
            if (!bl2) continue;
            break;
        }
        return this.fCurrentEntity.count - this.fCurrentEntity.position >= n;
    }

    public boolean skipString(String string) throws IOException {
        int n = string.length();
        if (this.arrangeCapacity(n, false)) {
            int n2 = this.fCurrentEntity.position;
            int n3 = this.fCurrentEntity.position + n - 1;
            int n4 = n - 1;
            while (string.charAt(n4--) == this.fCurrentEntity.ch[n3]) {
                if (n3-- != n2) continue;
                this.fCurrentEntity.position += n;
                this.fCurrentEntity.columnNumber += n;
                return true;
            }
        }
        return false;
    }

    public boolean skipString(char[] cArray) throws IOException {
        int n = cArray.length;
        if (this.arrangeCapacity(n, false)) {
            int n2 = this.fCurrentEntity.position;
            int n3 = this.fCurrentEntity.position + n;
            for (int i = 0; i < n; ++i) {
                if (this.fCurrentEntity.ch[n2++] == cArray[i]) continue;
                return false;
            }
            this.fCurrentEntity.position += n;
            this.fCurrentEntity.columnNumber += n;
            return true;
        }
        return false;
    }

    final boolean load(int n, boolean bl) throws IOException {
        this.fCurrentEntity.fTotalCountTillLastLoad += this.fCurrentEntity.fLastCount;
        int n2 = this.fCurrentEntity.ch.length - n;
        if (!this.fCurrentEntity.mayReadChunks && n2 > 64) {
            n2 = 64;
        }
        int n3 = this.fCurrentEntity.reader.read(this.fCurrentEntity.ch, n, n2);
        boolean bl2 = false;
        if (n3 != -1) {
            if (n3 != 0) {
                this.fCurrentEntity.fLastCount = n3;
                this.fCurrentEntity.count = n3 + n;
                this.fCurrentEntity.position = n;
            }
        } else {
            this.fCurrentEntity.count = n;
            this.fCurrentEntity.position = n;
            bl2 = true;
            if (bl) {
                this.fEntityManager.endEntity();
                if (this.fCurrentEntity == null) {
                    throw END_OF_DOCUMENT_ENTITY;
                }
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    this.load(0, true);
                }
            }
        }
        return bl2;
    }

    protected Reader createReader(InputStream inputStream, String string, Boolean bl) throws IOException {
        String string2;
        String string3;
        if (string == null) {
            string = "UTF-8";
        }
        if ((string3 = string.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fCurrentEntity.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string3.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, this.fCurrentEntity.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string3.equals("ISO-10646-UCS-4")) {
            if (bl != null) {
                boolean bl2 = bl;
                if (bl2) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        if (string3.equals("ISO-10646-UCS-2")) {
            if (bl != null) {
                boolean bl3 = bl;
                if (bl3) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{string}, (short)2);
        }
        boolean bl4 = XMLChar.isValidIANAEncoding(string);
        boolean bl5 = XMLChar.isValidJavaEncoding(string);
        if (!bl4 || this.fAllowJavaEncodings && !bl5) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
            string = "ISO-8859-1";
        }
        if ((string2 = EncodingMap.getIANA2JavaMapping(string3)) == null) {
            if (this.fAllowJavaEncodings) {
                string2 = string;
            } else {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{string}, (short)2);
                string2 = "ISO8859_1";
            }
        } else if (string2.equals("ASCII")) {
            return new ASCIIReader(inputStream, this.fBufferSize, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        return new InputStreamReader(inputStream, string2);
    }

    protected Object[] getEncodingName(byte[] byArray, int n) {
        if (n < 2) {
            return new Object[]{"UTF-8", null};
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 255 && n3 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n < 3) {
            return new Object[]{"UTF-8", null};
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return new Object[]{"UTF-8", null};
        }
        if (n < 4) {
            return new Object[]{"UTF-8", null};
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return new Object[]{"CP037", null};
        }
        return new Object[]{"UTF-8", null};
    }

    final void print() {
    }

    public void registerListener(XMLBufferListener xMLBufferListener) {
        if (!this.listeners.contains(xMLBufferListener)) {
            this.listeners.add(xMLBufferListener);
        }
    }

    private void invokeListeners(int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            XMLBufferListener xMLBufferListener = (XMLBufferListener)this.listeners.get(i);
            xMLBufferListener.refresh(n);
        }
    }

    public final boolean skipDeclSpaces() throws IOException {
        char c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
            boolean bl = this.fCurrentEntity.isExternal();
            do {
                boolean bl2 = false;
                if (c == '\n' || bl && c == '\r') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.fCurrentEntity.ch[0] = c;
                        bl2 = this.load(1, true);
                        if (!bl2) {
                            this.fCurrentEntity.position = 0;
                        }
                    }
                    if (c == '\r' && bl && this.fCurrentEntity.ch[++this.fCurrentEntity.position] != '\n') {
                        --this.fCurrentEntity.position;
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!bl2) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.load(0, true);
            } while (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position]));
            return true;
        }
        return false;
    }

    static {
        int n;
        VALID_NAMES = new boolean[127];
        END_OF_DOCUMENT_ENTITY = new EOFException(){
            private static final long serialVersionUID = 980337771224675268L;

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        for (n = 65; n <= 90; ++n) {
            XMLEntityScanner.VALID_NAMES[n] = true;
        }
        for (n = 97; n <= 122; ++n) {
            XMLEntityScanner.VALID_NAMES[n] = true;
        }
        for (n = 48; n <= 57; ++n) {
            XMLEntityScanner.VALID_NAMES[n] = true;
        }
        XMLEntityScanner.VALID_NAMES[45] = true;
        XMLEntityScanner.VALID_NAMES[46] = true;
        XMLEntityScanner.VALID_NAMES[58] = true;
        XMLEntityScanner.VALID_NAMES[95] = true;
    }
}

