/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management;

import com.sun.jmx.mbeanserver.Util;
import com.sun.management.MissionControlMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public final class MissionControl
extends StandardMBean
implements MissionControlMXBean {
    private static final ObjectName MBEAN_NAME = Util.newObjectName("com.sun.management:type=MissionControl");
    private MBeanServer server;

    public MissionControl() {
        super(MissionControlMXBean.class, true);
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        return MBEAN_NAME;
    }

    @Override
    public void unregisterMBeans() {
        this.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() {
                FlightRecorderHelper.unregisterWithMBeanServer(MissionControl.this.server);
                return null;
            }
        });
    }

    @Override
    public void registerMBeans() {
        this.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws MalformedObjectNameException {
                if (!MissionControl.this.server.isRegistered(new ObjectName("com.oracle.jrockit:type=FlightRecorder")) && FlightRecorderHelper.isActive()) {
                    FlightRecorderHelper.registerWithMBeanServer(MissionControl.this.server);
                }
                return null;
            }
        });
    }

    private void doPrivileged(PrivilegedExceptionAction<Void> privilegedExceptionAction) {
        try {
            AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static class FlightRecorderHelper {
        static final String MBEAN_NAME = "com.oracle.jrockit:type=FlightRecorder";
        private static final Class<?> FLIGHTRECORDER_CLASS = FlightRecorderHelper.getClass("com.oracle.jrockit.jfr.FlightRecorder");
        private static final Method ISACTIVE_METHOD = FlightRecorderHelper.getMethod(FLIGHTRECORDER_CLASS, "isActive", new Class[0]);
        private static final Method REGISTERWITHMBEANSERVER_METHOD = FlightRecorderHelper.getMethod(FLIGHTRECORDER_CLASS, "registerWithMBeanServer", MBeanServer.class);
        private static final Method UNREGISTERWITHMBEANSERVER_METHOD = FlightRecorderHelper.getMethod(FLIGHTRECORDER_CLASS, "unregisterWithMBeanServer", MBeanServer.class);

        private FlightRecorderHelper() {
        }

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, FlightRecorderHelper.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalError("jfr.jar missing?", classNotFoundException);
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InternalError(noSuchMethodException);
            }
        }

        private static Object invokeStatic(Method method, Object ... objectArray) {
            try {
                return method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new InternalError(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
        }

        static boolean isActive() {
            return (Boolean)FlightRecorderHelper.invokeStatic(ISACTIVE_METHOD, new Object[0]);
        }

        static void registerWithMBeanServer(MBeanServer mBeanServer) {
            FlightRecorderHelper.invokeStatic(REGISTERWITHMBEANSERVER_METHOD, mBeanServer);
        }

        static void unregisterWithMBeanServer(MBeanServer mBeanServer) {
            FlightRecorderHelper.invokeStatic(UNREGISTERWITHMBEANSERVER_METHOD, mBeanServer);
        }
    }
}

