/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Objects;

public abstract class Cache<K, V> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private final boolean identity;
    private final Kind keyKind;
    private final Kind valueKind;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private volatile CacheEntry<K, V>[] table = this.newTable(8);
    private int threshold = 6;
    private int size;

    public abstract V create(K var1);

    public Cache(Kind kind, Kind kind2) {
        this(kind, kind2, false);
    }

    public Cache(Kind kind, Kind kind2, boolean bl) {
        Objects.requireNonNull(kind, "keyKind");
        Objects.requireNonNull(kind2, "valueKind");
        this.keyKind = kind;
        this.valueKind = kind2;
        this.identity = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K k) {
        Objects.requireNonNull(k, "key");
        this.removeStaleEntries();
        int n = this.hash(k);
        Object[] objectArray = this.table;
        V v = this.getEntryValue(k, n, (CacheEntry<K, V>)objectArray[Cache.index(n, objectArray)]);
        if (v != null) {
            return v;
        }
        ReferenceQueue<Object> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            int n2 = Cache.index(n, this.table);
            v = this.getEntryValue(k, n, this.table[n2]);
            if (v != null) {
                return v;
            }
            V v2 = this.create(k);
            Objects.requireNonNull(v2, "value");
            this.table[n2] = new CacheEntry(n, k, v2, this.table[n2]);
            if (++this.size >= this.threshold) {
                if (this.table.length == 0x40000000) {
                    this.threshold = Integer.MAX_VALUE;
                } else {
                    this.removeStaleEntries();
                    objectArray = this.newTable(this.table.length << 1);
                    this.transfer(this.table, (CacheEntry<K, V>[])objectArray);
                    if (this.size >= this.threshold / 2) {
                        this.table = objectArray;
                        this.threshold <<= 1;
                    } else {
                        this.transfer((CacheEntry<K, V>[])objectArray, this.table);
                    }
                    this.removeStaleEntries();
                }
            }
            return v2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(K k) {
        if (k != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                CacheEntry cacheEntry;
                this.removeStaleEntries();
                int n = this.hash(k);
                int n2 = Cache.index(n, this.table);
                CacheEntry cacheEntry2 = cacheEntry = this.table[n2];
                while (cacheEntry2 != null) {
                    CacheEntry cacheEntry3 = cacheEntry2.next;
                    if (cacheEntry2.matches(n, k)) {
                        if (cacheEntry2 == cacheEntry) {
                            this.table[n2] = cacheEntry3;
                        } else {
                            cacheEntry.next = cacheEntry3;
                        }
                        cacheEntry2.unlink();
                        break;
                    }
                    cacheEntry = cacheEntry2;
                    cacheEntry2 = cacheEntry3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReferenceQueue<Object> referenceQueue = this.queue;
        synchronized (referenceQueue) {
            int n = this.table.length;
            while (0 < n--) {
                CacheEntry cacheEntry = this.table[n];
                while (cacheEntry != null) {
                    CacheEntry cacheEntry2 = cacheEntry.next;
                    cacheEntry.unlink();
                    cacheEntry = cacheEntry2;
                }
                this.table[n] = null;
            }
            while (null != this.queue.poll()) {
            }
        }
    }

    private int hash(Object object) {
        if (this.identity) {
            int n = System.identityHashCode(object);
            return (n << 1) - (n << 8);
        }
        int n = object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int index(int n, Object[] objectArray) {
        return n & objectArray.length - 1;
    }

    private CacheEntry<K, V>[] newTable(int n) {
        return new CacheEntry[n];
    }

    private V getEntryValue(K k, int n, CacheEntry<K, V> cacheEntry) {
        while (cacheEntry != null) {
            if (cacheEntry.matches(n, k)) {
                return (V)cacheEntry.value.getReferent();
            }
            cacheEntry = cacheEntry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleEntries() {
        Reference<Object> reference = this.queue.poll();
        if (reference != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                block3: do {
                    CacheEntry cacheEntry;
                    Ref ref;
                    CacheEntry cacheEntry2;
                    if (!(reference instanceof Ref) || (cacheEntry2 = (CacheEntry)(ref = (Ref)((Object)reference)).getOwner()) == null) continue;
                    int n = Cache.index(cacheEntry2.hash, this.table);
                    CacheEntry cacheEntry3 = cacheEntry = this.table[n];
                    while (cacheEntry3 != null) {
                        CacheEntry cacheEntry4 = cacheEntry3.next;
                        if (cacheEntry3 == cacheEntry2) {
                            if (cacheEntry3 == cacheEntry) {
                                this.table[n] = cacheEntry4;
                            } else {
                                cacheEntry.next = cacheEntry4;
                            }
                            cacheEntry3.unlink();
                            continue block3;
                        }
                        cacheEntry = cacheEntry3;
                        cacheEntry3 = cacheEntry4;
                    }
                } while ((reference = this.queue.poll()) != null);
            }
        }
    }

    private void transfer(CacheEntry<K, V>[] cacheEntryArray, CacheEntry<K, V>[] cacheEntryArray2) {
        int n = cacheEntryArray.length;
        while (0 < n--) {
            CacheEntry cacheEntry = cacheEntryArray[n];
            cacheEntryArray[n] = null;
            while (cacheEntry != null) {
                CacheEntry cacheEntry2 = cacheEntry.next;
                if (cacheEntry.key.isStale() || cacheEntry.value.isStale()) {
                    cacheEntry.unlink();
                } else {
                    int n2 = Cache.index(cacheEntry.hash, cacheEntryArray2);
                    cacheEntry.next = (CacheEntry)cacheEntryArray2[n2];
                    cacheEntryArray2[n2] = cacheEntry;
                }
                cacheEntry = cacheEntry2;
            }
        }
    }

    private final class CacheEntry<K, V> {
        private final int hash;
        private final Ref<K> key;
        private final Ref<V> value;
        private volatile CacheEntry<K, V> next;

        private CacheEntry(int n, K k, V v, CacheEntry<K, V> cacheEntry) {
            this.hash = n;
            this.key = Cache.this.keyKind.create(this, k, Cache.this.queue);
            this.value = Cache.this.valueKind.create(this, v, Cache.this.queue);
            this.next = cacheEntry;
        }

        private boolean matches(int n, Object object) {
            if (this.hash != n) {
                return false;
            }
            K k = this.key.getReferent();
            return k == object || !Cache.this.identity && k != null && k.equals(object);
        }

        private void unlink() {
            this.next = null;
            this.key.removeOwner();
            this.value.removeOwner();
            Cache.this.size--;
        }
    }

    public static enum Kind {
        STRONG{

            @Override
            <T> Ref<T> create(Object object, T t, ReferenceQueue<? super T> referenceQueue) {
                return new Strong(object, t);
            }
        }
        ,
        SOFT{

            @Override
            <T> Ref<T> create(Object object, T t, ReferenceQueue<? super T> referenceQueue) {
                return t == null ? new Strong(object, t) : new Soft(object, t, referenceQueue);
            }
        }
        ,
        WEAK{

            @Override
            <T> Ref<T> create(Object object, T t, ReferenceQueue<? super T> referenceQueue) {
                return t == null ? new Strong(object, t) : new Weak(object, t, referenceQueue);
            }
        };


        abstract <T> Ref<T> create(Object var1, T var2, ReferenceQueue<? super T> var3);

        private static final class Soft<T>
        extends SoftReference<T>
        implements Ref<T> {
            private Object owner;

            private Soft(Object object, T t, ReferenceQueue<? super T> referenceQueue) {
                super(t, referenceQueue);
                this.owner = object;
            }

            @Override
            public Object getOwner() {
                return this.owner;
            }

            @Override
            public T getReferent() {
                return this.get();
            }

            @Override
            public boolean isStale() {
                return null == this.get();
            }

            @Override
            public void removeOwner() {
                this.owner = null;
            }
        }

        private static final class Strong<T>
        implements Ref<T> {
            private Object owner;
            private final T referent;

            private Strong(Object object, T t) {
                this.owner = object;
                this.referent = t;
            }

            @Override
            public Object getOwner() {
                return this.owner;
            }

            @Override
            public T getReferent() {
                return this.referent;
            }

            @Override
            public boolean isStale() {
                return false;
            }

            @Override
            public void removeOwner() {
                this.owner = null;
            }
        }

        private static final class Weak<T>
        extends WeakReference<T>
        implements Ref<T> {
            private Object owner;

            private Weak(Object object, T t, ReferenceQueue<? super T> referenceQueue) {
                super(t, referenceQueue);
                this.owner = object;
            }

            @Override
            public Object getOwner() {
                return this.owner;
            }

            @Override
            public T getReferent() {
                return this.get();
            }

            @Override
            public boolean isStale() {
                return null == this.get();
            }

            @Override
            public void removeOwner() {
                this.owner = null;
            }
        }
    }

    private static interface Ref<T> {
        public Object getOwner();

        public T getReferent();

        public boolean isStale();

        public void removeOwner();
    }
}

