/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.impl.ManagedResource;
import com.sun.prism.j2d.J2DTexturePool;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class J2DTexture
extends BaseTexture<J2DTexResource> {
    private final Updater updater;

    static J2DTexture create(PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n, int n2) {
        Updater updater;
        int n3;
        switch (pixelFormat) {
            case BYTE_RGB: {
                n3 = 5;
                updater = ThreeByteBgrUpdater.THREE_BYTE_BGR_INSTANCE;
                break;
            }
            case BYTE_GRAY: {
                n3 = 10;
                updater = Updater.GENERAL_INSTANCE;
                break;
            }
            case INT_ARGB_PRE: 
            case BYTE_BGRA_PRE: {
                n3 = 3;
                updater = IntArgbPreUpdater.INT_ARGB_PRE_INSTANCE;
                break;
            }
            default: {
                throw new InternalError("Unrecognized PixelFormat (" + (Object)((Object)pixelFormat) + ")!");
            }
        }
        J2DTexturePool j2DTexturePool = J2DTexturePool.instance;
        long l = J2DTexturePool.size(n, n2, n3);
        if (!j2DTexturePool.prepareForAllocation(l)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        return new J2DTexture(bufferedImage, pixelFormat, updater, wrapMode);
    }

    J2DTexture(BufferedImage bufferedImage, PixelFormat pixelFormat, Updater updater, Texture.WrapMode wrapMode) {
        super(new J2DTexResource(bufferedImage), pixelFormat, wrapMode, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.updater = updater;
    }

    J2DTexture(J2DTexture j2DTexture, Texture.WrapMode wrapMode) {
        super(j2DTexture, wrapMode);
        this.updater = j2DTexture.updater;
    }

    @Override
    protected Texture createSharedTexture(Texture.WrapMode wrapMode) {
        return new J2DTexture(this, wrapMode);
    }

    BufferedImage getBufferedImage() {
        return (BufferedImage)((J2DTexResource)this.resource).getResource();
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        BufferedImage bufferedImage = this.getBufferedImage();
        switch (pixelFormat) {
            case BYTE_RGB: {
                this.updater.updateFromByteBuffer(bufferedImage, (ByteBuffer)buffer, n, n2, n3, n4, n5, n6, n7, 0, 1, 2, -1, 3, true);
                return;
            }
            case BYTE_GRAY: {
                this.updater.updateFromByteBuffer(bufferedImage, (ByteBuffer)buffer, n, n2, n3, n4, n5, n6, n7, 0, 0, 0, -1, 1, true);
                return;
            }
            case INT_ARGB_PRE: {
                this.updater.updateFromIntBuffer(bufferedImage, (IntBuffer)buffer, n, n2, n3, n4, n5, n6, n7 / 4, true, true);
                return;
            }
            case BYTE_BGRA_PRE: {
                this.updater.updateFromByteBuffer(bufferedImage, (ByteBuffer)buffer, n, n2, n3, n4, n5, n6, n7, 2, 1, 0, 3, 4, true);
                return;
            }
        }
        throw new UnsupportedOperationException("Pixel format " + (Object)((Object)pixelFormat) + " not supported yet.");
    }

    @Override
    public void update(MediaFrame object, boolean bl) {
        Object object2;
        object.holdFrame();
        if (object.getPixelFormat() != PixelFormat.INT_ARGB_PRE) {
            object2 = object.convertToFormat(PixelFormat.INT_ARGB_PRE);
            object.releaseFrame();
            object = object2;
            if (null == object) {
                return;
            }
        }
        object2 = object.getBuffer();
        ((ByteBuffer)object2).position(object.offsetForPlane(0));
        BufferedImage bufferedImage = this.getBufferedImage();
        this.updater.updateFromIntBuffer(bufferedImage, ((ByteBuffer)object2).asIntBuffer(), 0, 0, 0, 0, object.getWidth(), object.getHeight(), object.strideForPlane(0) / 4, true, true);
        object.releaseFrame();
    }

    static class IntArgbPreUpdater
    extends Updater {
        static IntArgbPreUpdater INT_ARGB_PRE_INSTANCE = new IntArgbPreUpdater();

        private IntArgbPreUpdater() {
        }

        @Override
        void updateFromByteBuffer(BufferedImage bufferedImage, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl) {
            byte[] byArray;
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n13 = bufferedImage.getWidth();
            int n14 = n2 * n13 + n;
            int n15 = n4 * n7 + n3 * n12;
            int n16 = 255;
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n15 += byteBuffer.arrayOffset();
            } else {
                byArray = new byte[n5 * n12];
                byteBuffer.position(byteBuffer.position() + n15);
                n15 = 0;
            }
            n7 -= n12 * n5;
            for (int i = 0; i < n6; ++i) {
                if (!byteBuffer.hasArray()) {
                    byteBuffer.get(byArray);
                    if (n7 != 0) {
                        byteBuffer.position(byteBuffer.position() + n7);
                    }
                    n15 = 0;
                }
                for (int j = 0; j < n5; ++j) {
                    int n17;
                    int n18 = byArray[n15 + n8] & 0xFF;
                    int n19 = byArray[n15 + n9] & 0xFF;
                    int n20 = byArray[n15 + n10] & 0xFF;
                    if (n11 >= 0) {
                        n16 = byArray[n15 + n11] & 0xFF;
                        if (!bl && n16 != 255) {
                            if (n16 == 0) {
                                n20 = 0;
                                n19 = 0;
                                n18 = 0;
                            } else {
                                n18 = n18 * n16 / 255;
                                n19 = n19 * n16 / 255;
                                n20 = n20 * n16 / 255;
                            }
                        }
                    }
                    nArray[n14 + j] = n17 = n16 << 24 | n18 << 16 | n19 << 8 | n20;
                    n15 += n12;
                }
                n15 += n7;
                n14 += n13;
            }
        }

        @Override
        void updateFromIntBuffer(BufferedImage bufferedImage, IntBuffer intBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
            int[] nArray;
            int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int n8 = bufferedImage.getWidth();
            int n9 = n2 * n8 + n;
            int n10 = n4 * n7 + n3;
            if (intBuffer.hasArray()) {
                nArray = intBuffer.array();
                n10 += intBuffer.arrayOffset();
            } else {
                nArray = new int[n5];
                intBuffer.position(intBuffer.position() + n10);
                n10 = 0;
            }
            for (int i = 0; i < n6; ++i) {
                if (!intBuffer.hasArray()) {
                    intBuffer.get(nArray);
                    if (n7 - n5 != 0) {
                        intBuffer.position(intBuffer.position() + (n7 - n5));
                    }
                    n10 = 0;
                }
                for (int j = 0; j < n5; ++j) {
                    int n11 = nArray[n10 + j];
                    if (!bl) {
                        n11 |= 0xFF000000;
                    } else if (!bl2) {
                        int n12 = n11 >>> 24;
                        if (n12 == 0) {
                            n11 = 0;
                        } else if (n12 != 255) {
                            int n13 = n11 >> 16 & 0xFF;
                            int n14 = n11 >> 8 & 0xFF;
                            int n15 = n11 & 0xFF;
                            n13 = n13 * n12 / 255;
                            n14 = n14 * n12 / 255;
                            n15 = n15 * n12 / 255;
                            n11 = n12 << 24 | n13 << 16 | n14 << 8 | n15;
                        }
                    }
                    nArray2[n9 + j] = n11;
                }
                n10 += n7;
                n9 += n8;
            }
        }
    }

    static class J2DTexResource
    extends ManagedResource<BufferedImage> {
        public J2DTexResource(BufferedImage bufferedImage) {
            super(bufferedImage, J2DTexturePool.instance);
        }

        @Override
        public void free() {
            ((BufferedImage)this.resource).flush();
        }
    }

    static class ThreeByteBgrUpdater
    extends Updater {
        static ThreeByteBgrUpdater THREE_BYTE_BGR_INSTANCE = new ThreeByteBgrUpdater();

        private ThreeByteBgrUpdater() {
        }

        @Override
        void updateFromByteBuffer(BufferedImage bufferedImage, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl) {
            byte[] byArray;
            byte[] byArray2 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            int n13 = bufferedImage.getWidth() * 3;
            int n14 = n2 * n13 + n * 3;
            int n15 = n4 * n7 + n3 * n12;
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n15 += byteBuffer.arrayOffset();
            } else {
                byArray = new byte[n5 * n12];
                byteBuffer.position(byteBuffer.position() + n15);
                n15 = 0;
            }
            n7 -= n12 * n5;
            n13 -= 3 * n5;
            for (int i = 0; i < n6; ++i) {
                if (!byteBuffer.hasArray()) {
                    byteBuffer.get(byArray);
                    if (n7 != 0) {
                        byteBuffer.position(byteBuffer.position() + n7);
                    }
                    n15 = 0;
                }
                for (int j = 0; j < n5; ++j) {
                    byArray2[n14] = byArray[n15 + n10];
                    byArray2[n14 + 1] = byArray[n15 + n9];
                    byArray2[n14 + 2] = byArray[n15 + n8];
                    n15 += n12;
                    n14 += 3;
                }
                n15 += n7;
                n14 += n13;
            }
        }
    }

    static class Updater {
        static Updater GENERAL_INSTANCE = new Updater();

        private Updater() {
        }

        void updateFromByteBuffer(BufferedImage bufferedImage, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl) {
            byte[] byArray;
            int n13 = n4 * n7 + n3 * n12;
            int n14 = 255;
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n13 += byteBuffer.arrayOffset();
            } else {
                byArray = new byte[n5 * n12];
                byteBuffer.position(byteBuffer.position() + n13);
                n13 = 0;
            }
            n7 -= n12 * n5;
            for (int i = 0; i < n6; ++i) {
                if (!byteBuffer.hasArray()) {
                    byteBuffer.get(byArray);
                    if (n7 != 0) {
                        byteBuffer.position(byteBuffer.position() + n7);
                    }
                    n13 = 0;
                }
                for (int j = 0; j < n5; ++j) {
                    int n15 = byArray[n13 + n8] & 0xFF;
                    int n16 = byArray[n13 + n9] & 0xFF;
                    int n17 = byArray[n13 + n10] & 0xFF;
                    if (n11 >= 0) {
                        n14 = byArray[n13 + n11] & 0xFF;
                        if (bl && n14 != 255 && n14 != 0) {
                            n15 = n15 * 255 / n14;
                            n16 = n16 * 255 / n14;
                            n17 = n17 * 255 / n14;
                        }
                    }
                    int n18 = n14 << 24 | n15 << 16 | n16 << 8 | n17;
                    bufferedImage.setRGB(n + j, n2 + i, n18);
                    n13 += n12;
                }
                n13 += n7;
            }
        }

        void updateFromIntBuffer(BufferedImage bufferedImage, IntBuffer intBuffer, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
            int[] nArray;
            int n8 = n4 * n7 + n3;
            if (intBuffer.hasArray()) {
                nArray = intBuffer.array();
                n8 += intBuffer.arrayOffset();
            } else {
                nArray = new int[n5];
                intBuffer.position(intBuffer.position() + n8);
                n8 = 0;
            }
            for (int i = 0; i < n6; ++i) {
                if (!intBuffer.hasArray()) {
                    intBuffer.get(nArray);
                    if (n7 - n5 != 0) {
                        intBuffer.position(intBuffer.position() + (n7 - n5));
                    }
                    n8 = 0;
                }
                for (int j = 0; j < n5; ++j) {
                    int n9;
                    int n10 = nArray[n8 + j];
                    if (!bl) {
                        n10 |= 0xFF000000;
                    } else if (bl2 && (n9 = n10 >>> 24) != 255 && n9 != 0) {
                        int n11 = n10 >> 16 & 0xFF;
                        int n12 = n10 >> 8 & 0xFF;
                        int n13 = n10 & 0xFF;
                        n11 = n11 * 255 / n9;
                        n12 = n12 * 255 / n9;
                        n13 = n13 * 255 / n9;
                        n10 = n9 << 24 | n11 << 16 | n12 << 8 | n13;
                    }
                    bufferedImage.setRGB(n + j, n2 + i, n10);
                }
                n8 += n7;
            }
        }
    }
}

