/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDS
implements EmbeddedSceneDSInterface {
    private final EmbeddedSceneDnD dnd;
    private final ClipboardAssistance assistant;
    private final GlassSceneDnDEventHandler dndHandler;

    public EmbeddedSceneDS(EmbeddedSceneDnD embeddedSceneDnD, ClipboardAssistance clipboardAssistance, GlassSceneDnDEventHandler glassSceneDnDEventHandler) {
        this.dnd = embeddedSceneDnD;
        this.assistant = clipboardAssistance;
        this.dndHandler = glassSceneDnDEventHandler;
    }

    @Override
    public Set<TransferMode> getSupportedActions() {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(new Callable<Set<TransferMode>>(){

            @Override
            public Set<TransferMode> call() {
                return QuantumClipboard.clipboardActionsToTransferModes(EmbeddedSceneDS.this.assistant.getSupportedSourceActions());
            }
        });
    }

    @Override
    public Object getData(final String string) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(new Callable<Object>(){

            @Override
            public Object call() {
                return EmbeddedSceneDS.this.assistant.getData(string);
            }
        });
    }

    @Override
    public String[] getMimeTypes() {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(new Callable<String[]>(){

            @Override
            public String[] call() {
                return EmbeddedSceneDS.this.assistant.getMimeTypes();
            }
        });
    }

    @Override
    public boolean isMimeTypeAvailable(final String string) {
        assert (this.dnd.isHostThread());
        return this.dnd.executeOnFXThread(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Arrays.asList(EmbeddedSceneDS.this.assistant.getMimeTypes()).contains(string);
            }
        });
    }

    @Override
    public void dragDropEnd(final TransferMode transferMode) {
        assert (this.dnd.isHostThread());
        this.dnd.executeOnFXThread(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    EmbeddedSceneDS.this.dndHandler.handleDragEnd(transferMode, EmbeddedSceneDS.this.assistant);
                }
                finally {
                    EmbeddedSceneDS.this.dnd.onDragSourceReleased(EmbeddedSceneDS.this);
                }
                return null;
            }
        });
    }
}

