/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.stage;

import com.sun.javafx.accessible.AccessibleStage;
import com.sun.javafx.stage.WindowPeerListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.stage.Stage;

public class StagePeerListener
extends WindowPeerListener {
    private final Stage stage;
    private final StageAccessor stageAccessor;
    private AccessibleStage accessibleController;
    private static boolean ACCESSIBILITY_ENABLED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.javafx.accessibility.enabled");
        }
    });

    public StagePeerListener(Stage stage, StageAccessor stageAccessor) {
        super(stage);
        this.stage = stage;
        this.stageAccessor = stageAccessor;
    }

    @Override
    public void changedIconified(boolean bl) {
        this.stageAccessor.setIconified(this.stage, bl);
    }

    @Override
    public void changedMaximized(boolean bl) {
        this.stageAccessor.setMaximized(this.stage, bl);
    }

    @Override
    public void changedResizable(boolean bl) {
        this.stageAccessor.setResizable(this.stage, bl);
    }

    @Override
    public void changedFullscreen(boolean bl) {
        this.stageAccessor.setFullScreen(this.stage, bl);
    }

    @Override
    public void initAccessibleTKStageListener() {
        if (ACCESSIBILITY_ENABLED) {
            this.accessibleController = new AccessibleStage(this.stage);
            this.stage.impl_getPeer().setAccessibilityInitIsComplete(this.accessibleController.getStageAccessible());
        }
    }

    public static interface StageAccessor {
        public void setIconified(Stage var1, boolean var2);

        public void setMaximized(Stage var1, boolean var2);

        public void setResizable(Stage var1, boolean var2);

        public void setFullScreen(Stage var1, boolean var2);
    }
}

