/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.InputFieldSkin;
import com.sun.javafx.scene.control.skin.WebColorField;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.scene.Node;
import javafx.scene.paint.Color;

class WebColorFieldSkin
extends InputFieldSkin {
    private InvalidationListener integerFieldValueListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            WebColorFieldSkin.this.updateText();
        }
    };
    private boolean noChangeInValue = false;

    public WebColorFieldSkin(WebColorField webColorField) {
        super(webColorField);
        webColorField.valueProperty().addListener(this.integerFieldValueListener);
    }

    @Override
    public WebColorField getSkinnable() {
        return (WebColorField)this.control;
    }

    @Override
    public Node getNode() {
        return this.getTextField();
    }

    @Override
    public void dispose() {
        ((WebColorField)this.control).valueProperty().removeListener(this.integerFieldValueListener);
        super.dispose();
    }

    @Override
    protected boolean accept(String string) {
        if (string.length() == 0) {
            return true;
        }
        return string.matches("#[a-fA-F0-9]{0,6}") || string.matches("[a-fA-F0-9]{0,6}");
    }

    @Override
    protected void updateText() {
        Color color = ((WebColorField)this.control).getValue();
        if (color == null) {
            color = Color.BLACK;
        }
        this.getTextField().setText(WebColorFieldSkin.getWebColor(color));
    }

    @Override
    protected void updateValue() {
        String string;
        if (this.noChangeInValue) {
            return;
        }
        Color color = ((WebColorField)this.control).getValue();
        String string2 = string = this.getTextField().getText() == null ? "" : this.getTextField().getText().trim().toUpperCase(Locale.ROOT);
        if (string.matches("#[A-F0-9]{6}") || string.matches("[A-F0-9]{6}")) {
            try {
                Color color2;
                Color color3 = color2 = string.charAt(0) == '#' ? Color.web(string) : Color.web("#" + string);
                if (!color2.equals(color)) {
                    ((WebColorField)this.control).setValue(color2);
                } else {
                    this.noChangeInValue = true;
                    this.getTextField().setText(WebColorFieldSkin.getWebColor(color2));
                    this.noChangeInValue = false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Failed to parse [" + string + "]");
            }
        }
    }

    private static String getWebColor(Color color) {
        int n = (int)(color.getRed() * 255.0);
        int n2 = (int)(color.getGreen() * 255.0);
        int n3 = (int)(color.getBlue() * 255.0);
        return "#" + String.format("%02X", n) + String.format("%02X", n2) + String.format("%02X", n3);
    }
}

