/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;

public class VirtualFlow<T extends IndexedCell>
extends Region {
    private static final int MIN_SCROLLING_LINES_PER_PAGE = 8;
    private boolean touchDetected = false;
    private boolean mouseDown = false;
    private BooleanProperty vertical;
    private boolean pannable = true;
    private int cellCount;
    private double position;
    private double fixedCellSize = 0.0;
    private boolean fixedCellSizeEnabled = false;
    private Callback<VirtualFlow, T> createCell;
    private double maxPrefBreadth;
    private double viewportBreadth;
    private double viewportLength;
    double lastWidth = -1.0;
    double lastHeight = -1.0;
    int lastCellCount = 0;
    boolean lastVertical;
    double lastPosition;
    double lastCellBreadth = -1.0;
    double lastCellLength = -1.0;
    final ArrayLinkedList<T> cells = new ArrayLinkedList();
    final ArrayLinkedList<T> pile = new ArrayLinkedList();
    T accumCell;
    Group accumCellParent;
    final Group sheet;
    final ObservableList<Node> sheetChildren;
    private VirtualScrollBar hbar = new VirtualScrollBar(this);
    private VirtualScrollBar vbar = new VirtualScrollBar(this);
    ClippedContainer clipView;
    StackPane corner;
    private double lastX;
    private double lastY;
    private boolean isPanning = false;
    private boolean needsReconfigureCells = false;
    private boolean needsRecreateCells = false;
    private boolean needsRebuildCells = false;
    private boolean needsCellsLayout = false;
    private boolean sizeChanged = false;
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;
    Timeline sbTouchTimeline;
    KeyFrame sbTouchKF1;
    KeyFrame sbTouchKF2;
    private boolean needBreadthBar;
    private boolean needLengthBar;
    private boolean tempVisibility = false;

    public final void setVertical(boolean bl) {
        this.verticalProperty().set(bl);
    }

    public final boolean isVertical() {
        return this.vertical == null ? true : this.vertical.get();
    }

    public final BooleanProperty verticalProperty() {
        if (this.vertical == null) {
            this.vertical = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    VirtualFlow.this.pile.clear();
                    VirtualFlow.this.sheetChildren.clear();
                    VirtualFlow.this.cells.clear();
                    VirtualFlow.this.lastHeight = -1.0;
                    VirtualFlow.this.lastWidth = -1.0;
                    VirtualFlow.this.setMaxPrefBreadth(-1.0);
                    VirtualFlow.this.setViewportBreadth(0.0);
                    VirtualFlow.this.setViewportLength(0.0);
                    VirtualFlow.this.lastPosition = 0.0;
                    VirtualFlow.this.hbar.setValue(0.0);
                    VirtualFlow.this.vbar.setValue(0.0);
                    VirtualFlow.this.setPosition(0.0);
                    VirtualFlow.this.setNeedsLayout(true);
                    VirtualFlow.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return VirtualFlow.this;
                }

                @Override
                public String getName() {
                    return "vertical";
                }
            };
        }
        return this.vertical;
    }

    public boolean isPannable() {
        return this.pannable;
    }

    public void setPannable(boolean bl) {
        this.pannable = bl;
    }

    public int getCellCount() {
        return this.cellCount;
    }

    public void setCellCount(int n) {
        Parent parent;
        boolean bl;
        int n2 = this.cellCount;
        this.cellCount = n;
        boolean bl2 = bl = n2 != this.cellCount;
        if (bl) {
            parent = this.isVertical() ? this.vbar : this.hbar;
            ((ScrollBar)parent).setMax(n);
        }
        if (bl) {
            this.layoutChildren();
            this.sheetChildren.clear();
            parent = this.getParent();
            if (parent != null) {
                parent.requestLayout();
            }
        }
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        boolean bl = this.position != d;
        this.position = Utils.clamp(0.0, d, 1.0);
        if (bl) {
            this.requestLayout();
        }
    }

    public void setFixedCellSize(double d) {
        this.fixedCellSize = d;
        this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        this.needsCellsLayout = true;
        this.layoutChildren();
    }

    public Callback<VirtualFlow, T> getCreateCell() {
        return this.createCell;
    }

    public void setCreateCell(Callback<VirtualFlow, T> callback) {
        this.createCell = callback;
        if (this.createCell != null) {
            this.accumCell = null;
            this.setNeedsLayout(true);
            this.recreateCells();
            if (this.getParent() != null) {
                this.getParent().requestLayout();
            }
        }
    }

    protected final void setMaxPrefBreadth(double d) {
        this.maxPrefBreadth = d;
    }

    protected final double getMaxPrefBreadth() {
        return this.maxPrefBreadth;
    }

    protected final void setViewportBreadth(double d) {
        this.viewportBreadth = d;
    }

    protected final double getViewportBreadth() {
        return this.viewportBreadth;
    }

    void setViewportLength(double d) {
        this.viewportLength = d;
    }

    protected double getViewportLength() {
        return this.viewportLength;
    }

    protected List<T> getCells() {
        return this.cells;
    }

    protected final VirtualScrollBar getHbar() {
        return this.hbar;
    }

    protected final VirtualScrollBar getVbar() {
        return this.vbar;
    }

    public VirtualFlow() {
        this.getStyleClass().add("virtual-flow");
        this.setId("virtual-flow");
        this.sheet = new Group();
        this.sheet.getStyleClass().add("sheet");
        this.sheet.setAutoSizeChildren(false);
        this.sheetChildren = this.sheet.getChildren();
        this.clipView = new ClippedContainer(this);
        this.clipView.setNode(this.sheet);
        this.getChildren().add(this.clipView);
        this.accumCellParent = new Group();
        this.accumCellParent.setVisible(false);
        this.getChildren().add(this.accumCellParent);
        final EventDispatcher eventDispatcher = new EventDispatcher(){

            @Override
            public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
                return event;
            }
        };
        final EventDispatcher eventDispatcher2 = this.hbar.getEventDispatcher();
        this.hbar.setEventDispatcher(new EventDispatcher(){

            @Override
            public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
                if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher2);
                    return eventDispatchChain.dispatchEvent(event);
                }
                return eventDispatcher2.dispatchEvent(event, eventDispatchChain);
            }
        });
        final EventDispatcher eventDispatcher3 = this.vbar.getEventDispatcher();
        this.vbar.setEventDispatcher(new EventDispatcher(){

            @Override
            public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
                if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher);
                    eventDispatchChain = eventDispatchChain.prepend(eventDispatcher3);
                    return eventDispatchChain.dispatchEvent(event);
                }
                return eventDispatcher3.dispatchEvent(event, eventDispatchChain);
            }
        });
        this.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                double d;
                if (BehaviorSkinBase.IS_TOUCH_SUPPORTED && !VirtualFlow.this.touchDetected && !VirtualFlow.this.mouseDown) {
                    VirtualFlow.this.startSBReleasedAnimation();
                }
                double d2 = 0.0;
                if (VirtualFlow.this.isVertical()) {
                    switch (scrollEvent.getTextDeltaYUnits()) {
                        case PAGES: {
                            d2 = scrollEvent.getTextDeltaY() * VirtualFlow.this.lastHeight;
                            break;
                        }
                        case LINES: {
                            if (VirtualFlow.this.fixedCellSizeEnabled) {
                                d = VirtualFlow.this.fixedCellSize;
                            } else {
                                IndexedCell indexedCell = (IndexedCell)VirtualFlow.this.cells.getLast();
                                d = (VirtualFlow.this.getCellPosition(indexedCell) + VirtualFlow.this.getCellLength(indexedCell) - VirtualFlow.this.getCellPosition((IndexedCell)VirtualFlow.this.cells.getFirst())) / (double)VirtualFlow.this.cells.size();
                            }
                            if (VirtualFlow.this.lastHeight / d < 8.0) {
                                d = VirtualFlow.this.lastHeight / 8.0;
                            }
                            d2 = scrollEvent.getTextDeltaY() * d;
                            break;
                        }
                        case NONE: {
                            d2 = scrollEvent.getDeltaY();
                        }
                    }
                } else {
                    switch (scrollEvent.getTextDeltaXUnits()) {
                        case CHARACTERS: 
                        case NONE: {
                            d = scrollEvent.getDeltaX();
                            double d3 = scrollEvent.getDeltaY();
                            double d4 = d2 = Math.abs(d) > Math.abs(d3) ? d : d3;
                        }
                    }
                }
                if (d2 != 0.0) {
                    VirtualFlow.this.adjustPixels(-d2);
                    scrollEvent.consume();
                } else {
                    VirtualScrollBar virtualScrollBar;
                    VirtualScrollBar virtualScrollBar2 = virtualScrollBar = VirtualFlow.this.isVertical() ? VirtualFlow.this.hbar : VirtualFlow.this.vbar;
                    if (virtualScrollBar.isVisible()) {
                        double d5 = VirtualFlow.this.isVertical() ? scrollEvent.getDeltaX() : scrollEvent.getDeltaY();
                        double d6 = virtualScrollBar.getValue() - d5;
                        if (d6 < virtualScrollBar.getMin()) {
                            virtualScrollBar.setValue(virtualScrollBar.getMin());
                        } else if (d6 > virtualScrollBar.getMax()) {
                            virtualScrollBar.setValue(virtualScrollBar.getMax());
                        } else {
                            virtualScrollBar.setValue(d6);
                        }
                        scrollEvent.consume();
                    }
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                VirtualFlow.this.mouseDown = true;
                if (BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                    VirtualFlow.this.scrollBarOn();
                }
                if (VirtualFlow.this.isFocusTraversable()) {
                    boolean bl = true;
                    Node node = VirtualFlow.this.getScene().getFocusOwner();
                    if (node != null) {
                        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                            if (!parent.equals(VirtualFlow.this)) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (bl) {
                        VirtualFlow.this.requestFocus();
                    }
                }
                VirtualFlow.this.lastX = mouseEvent.getX();
                VirtualFlow.this.lastY = mouseEvent.getY();
                VirtualFlow.this.isPanning = !VirtualFlow.this.vbar.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) && !VirtualFlow.this.hbar.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                VirtualFlow.this.mouseDown = false;
                if (BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                    VirtualFlow.this.startSBReleasedAnimation();
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                VirtualScrollBar virtualScrollBar;
                if (BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                    VirtualFlow.this.scrollBarOn();
                }
                if (!VirtualFlow.this.isPanning || !VirtualFlow.this.isPannable()) {
                    return;
                }
                double d = VirtualFlow.this.lastX - mouseEvent.getX();
                double d2 = VirtualFlow.this.lastY - mouseEvent.getY();
                double d3 = VirtualFlow.this.isVertical() ? d2 : d;
                double d4 = VirtualFlow.this.adjustPixels(d3);
                if (d4 != 0.0) {
                    if (VirtualFlow.this.isVertical()) {
                        VirtualFlow.this.lastY = mouseEvent.getY();
                    } else {
                        VirtualFlow.this.lastX = mouseEvent.getX();
                    }
                }
                double d5 = VirtualFlow.this.isVertical() ? d : d2;
                VirtualScrollBar virtualScrollBar2 = virtualScrollBar = VirtualFlow.this.isVertical() ? VirtualFlow.this.hbar : VirtualFlow.this.vbar;
                if (virtualScrollBar.isVisible()) {
                    double d6 = virtualScrollBar.getValue() + d5;
                    if (d6 < virtualScrollBar.getMin()) {
                        virtualScrollBar.setValue(virtualScrollBar.getMin());
                    } else if (d6 > virtualScrollBar.getMax()) {
                        virtualScrollBar.setValue(virtualScrollBar.getMax());
                    } else {
                        virtualScrollBar.setValue(d6);
                        if (VirtualFlow.this.isVertical()) {
                            VirtualFlow.this.lastX = mouseEvent.getX();
                        } else {
                            VirtualFlow.this.lastY = mouseEvent.getY();
                        }
                    }
                }
            }
        });
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.vbar.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        this.getChildren().add(this.vbar);
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.hbar.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        this.getChildren().add(this.hbar);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.getChildren().add(this.corner);
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                VirtualFlow.this.updateHbar();
            }
        };
        this.verticalProperty().addListener(invalidationListener);
        this.hbar.valueProperty().addListener(invalidationListener);
        this.hbar.visibleProperty().addListener(invalidationListener);
        ChangeListener changeListener = new ChangeListener(){

            public void changed(ObservableValue observableValue, Object object, Object object2) {
                VirtualFlow.this.clipView.setClipY(VirtualFlow.this.isVertical() ? 0.0 : VirtualFlow.this.vbar.getValue());
            }
        };
        this.vbar.valueProperty().addListener(changeListener);
        super.heightProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (number.doubleValue() == 0.0 && number2.doubleValue() > 0.0) {
                    VirtualFlow.this.recreateCells();
                }
            }
        });
        this.setOnTouchPressed((EventHandler<? super TouchEvent>)new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                VirtualFlow.this.touchDetected = true;
                VirtualFlow.this.scrollBarOn();
            }
        });
        this.setOnTouchReleased((EventHandler<? super TouchEvent>)new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                VirtualFlow.this.touchDetected = false;
                VirtualFlow.this.startSBReleasedAnimation();
            }
        });
    }

    void updateHbar() {
        if (!this.isVisible() || this.getScene() == null) {
            return;
        }
        if (this.isVertical()) {
            if (this.hbar.isVisible()) {
                this.clipView.setClipX(this.hbar.getValue());
            } else {
                this.clipView.setClipX(0.0);
                this.hbar.setValue(0.0);
            }
        }
    }

    @Override
    public void requestLayout() {
        this.setNeedsLayout(true);
    }

    @Override
    protected void layoutChildren() {
        boolean bl;
        double d;
        boolean bl2;
        Cell cell;
        int n;
        int n2;
        if (this.needsRecreateCells) {
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            this.releaseCell(this.accumCell);
            this.sheet.getChildren().clear();
            n2 = this.cells.size();
            for (n = 0; n < n2; ++n) {
                ((IndexedCell)this.cells.get(n)).updateIndex(-1);
            }
            this.cells.clear();
            this.pile.clear();
        } else if (this.needsRebuildCells) {
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            this.releaseCell(this.accumCell);
            for (n = 0; n < this.cells.size(); ++n) {
                ((IndexedCell)this.cells.get(n)).updateIndex(-1);
            }
            this.addAllToPile();
        } else if (this.needsReconfigureCells) {
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
        }
        n = this.sizeChanged;
        n2 = this.needsRebuildCells || this.needsRecreateCells || this.sizeChanged ? 1 : 0;
        this.needsRecreateCells = false;
        this.needsReconfigureCells = false;
        this.needsRebuildCells = false;
        this.sizeChanged = false;
        if (this.needsCellsLayout) {
            int n3 = this.cells.size();
            for (int i = 0; i < n3; ++i) {
                Cell cell2 = (Cell)this.cells.get(i);
                if (cell2 == null) continue;
                cell2.requestLayout();
            }
            this.needsCellsLayout = false;
            return;
        }
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        boolean bl3 = this.isVertical();
        double d4 = this.getPosition();
        if (d2 <= 0.0 || d3 <= 0.0) {
            this.addAllToPile();
            this.lastWidth = d2;
            this.lastHeight = d3;
            this.hbar.setVisible(false);
            this.vbar.setVisible(false);
            this.corner.setVisible(false);
            return;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if (BehaviorSkinBase.IS_TOUCH_SUPPORTED && (this.tempVisibility && (!this.hbar.isVisible() || !this.vbar.isVisible()) || !this.tempVisibility && (this.hbar.isVisible() || this.vbar.isVisible()))) {
            bl5 = true;
        }
        if (!bl4) {
            for (int i = 0; i < this.cells.size() && !(bl4 = (cell = (Cell)this.cells.get(i)).isNeedsLayout()); ++i) {
            }
        }
        cell = null;
        T t = this.getFirstVisibleCell();
        if (!bl4 && !bl5) {
            bl2 = false;
            if (t != null) {
                double d5 = this.getCellBreadth((Cell)t);
                d = this.getCellLength(t);
                bl2 = d5 != this.lastCellBreadth || d != this.lastCellLength;
                this.lastCellBreadth = d5;
                this.lastCellLength = d;
            }
            if (d2 == this.lastWidth && d3 == this.lastHeight && this.cellCount == this.lastCellCount && bl3 == this.lastVertical && d4 == this.lastPosition && !bl2) {
                return;
            }
        }
        bl2 = false;
        boolean bl6 = bl = bl4 || bl3 != this.lastVertical || this.cells.isEmpty() || this.getMaxPrefBreadth() == -1.0 || d4 != this.lastPosition || this.cellCount != this.lastCellCount || n != 0;
        if (!bl) {
            if (bl3 && d3 < this.lastHeight || !bl3 && d2 < this.lastWidth) {
                bl = true;
            } else if (bl3 && d3 > this.lastHeight || !bl3 && d2 > this.lastWidth) {
                bl2 = true;
            }
        }
        this.updateViewport();
        this.updateScrollBarsAndCells(n2 != 0);
        int n4 = this.computeCurrentIndex();
        if (this.lastCellCount != this.cellCount) {
            if (d4 != 0.0 && d4 != 1.0) {
                if (n4 >= this.cellCount) {
                    this.setPosition(1.0);
                } else if (t != null) {
                    d = this.getCellPosition(t);
                    int n5 = this.getCellIndex(t);
                    this.adjustPositionToIndex(n5);
                    double d6 = -this.computeOffsetForCell(n5);
                    this.adjustByPixelAmount(d6 - d);
                }
            }
            n4 = this.computeCurrentIndex();
        }
        if (bl) {
            this.addAllToPile();
            d = -this.computeViewportOffset(this.getPosition());
            this.addLeadingCells(n4, d);
            this.addTrailingCells(true);
        } else if (bl2) {
            this.addTrailingCells(true);
        }
        this.updateViewport();
        this.updateScrollBarsAndCells(n2 != 0);
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        this.lastCellCount = this.getCellCount();
        this.lastVertical = this.isVertical();
        this.lastPosition = this.getPosition();
        this.cleanPile();
    }

    protected void addLeadingCells(int n, double d) {
        double d2 = d;
        boolean bl = true;
        IndexedCell indexedCell = null;
        for (int i = n; i >= 0 && (d2 > 0.0 || bl); --i) {
            indexedCell = this.getAvailableCell(i);
            this.setCellIndex(indexedCell, i);
            this.resizeCellSize(indexedCell);
            this.cells.addFirst(indexedCell);
            if (bl) {
                bl = false;
            } else {
                d2 -= this.getCellLength(indexedCell);
            }
            this.positionCell(indexedCell, d2);
            this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth(indexedCell)));
            indexedCell.setVisible(true);
        }
        indexedCell = (IndexedCell)this.cells.getFirst();
        int n2 = this.getCellIndex(indexedCell);
        double d3 = this.getCellPosition(indexedCell);
        if (n2 == 0 && d3 > 0.0) {
            this.setPosition(0.0);
            d2 = 0.0;
            for (int i = 0; i < this.cells.size(); ++i) {
                indexedCell = (IndexedCell)this.cells.get(i);
                this.positionCell(indexedCell, d2);
                d2 += this.getCellLength(indexedCell);
            }
        }
    }

    protected boolean addTrailingCells(boolean bl) {
        IndexedCell indexedCell;
        if (this.cells.isEmpty()) {
            return false;
        }
        IndexedCell indexedCell2 = (IndexedCell)this.cells.getLast();
        double d = this.getCellPosition(indexedCell2) + this.getCellLength(indexedCell2);
        int n = this.getCellIndex(indexedCell2) + 1;
        boolean bl2 = n <= this.cellCount;
        double d2 = this.getViewportLength();
        while (d < d2) {
            if (n >= this.cellCount) {
                if (d < d2) {
                    bl2 = false;
                }
                if (!bl) {
                    return bl2;
                }
            }
            indexedCell = this.getAvailableCell(n);
            this.setCellIndex(indexedCell, n);
            this.resizeCellSize(indexedCell);
            this.cells.addLast(indexedCell);
            this.positionCell(indexedCell, d);
            this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth(indexedCell)));
            d += this.getCellLength(indexedCell);
            indexedCell.setVisible(true);
            ++n;
        }
        indexedCell = (IndexedCell)this.cells.getFirst();
        n = this.getCellIndex(indexedCell);
        T t = this.getLastVisibleCell();
        double d3 = this.getCellPosition(indexedCell);
        double d4 = this.getCellPosition(t) + this.getCellLength(t);
        if ((n != 0 || n == 0 && d3 < 0.0) && bl && t != null && this.getCellIndex(t) == this.cellCount - 1 && d4 < d2) {
            double d5;
            double d6 = d2 - d4;
            for (double d7 = d4; d7 < d2 && n != 0 && -d3 < d6; d7 += d5) {
                T t2 = this.getAvailableCell(--n);
                this.setCellIndex(t2, n);
                this.resizeCellSize(t2);
                this.cells.addFirst(t2);
                d5 = this.getCellLength(t2);
                this.positionCell(t2, d3 -= d5);
                this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)t2)));
                ((Node)t2).setVisible(true);
            }
            indexedCell = (IndexedCell)this.cells.getFirst();
            d3 = this.getCellPosition(indexedCell);
            double d8 = d2 - d4;
            if (this.getCellIndex(indexedCell) == 0 && d8 > -d3) {
                d8 = -d3;
            }
            for (int i = 0; i < this.cells.size(); ++i) {
                IndexedCell indexedCell3 = (IndexedCell)this.cells.get(i);
                this.positionCell(indexedCell3, this.getCellPosition(indexedCell3) + d8);
            }
            d3 = this.getCellPosition(indexedCell);
            if (this.getCellIndex(indexedCell) == 0 && d3 == 0.0) {
                this.setPosition(0.0);
            } else if (this.getPosition() != 1.0) {
                this.setPosition(1.0);
            }
        }
        return bl2;
    }

    private void updateViewport() {
        boolean bl = this.isVertical();
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.setViewportLength(this.snapSize(bl ? d2 : d));
        this.setViewportBreadth(this.snapSize(bl ? d : d2));
        VirtualScrollBar virtualScrollBar = bl ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = bl ? this.vbar : this.hbar;
        double d3 = this.snapSize(bl ? this.hbar.prefHeight(-1.0) : this.vbar.prefWidth(-1.0));
        double d4 = this.snapSize(bl ? this.vbar.prefWidth(-1.0) : this.hbar.prefHeight(-1.0));
        virtualScrollBar.setVirtual(false);
        virtualScrollBar2.setVirtual(true);
        double d5 = this.getMaxPrefBreadth();
        if (d5 == -1.0) {
            return;
        }
        double d6 = this.getViewportBreadth();
        double d7 = this.getViewportLength();
        this.needLengthBar = this.getPosition() > 0.0 || this.cellCount >= this.cells.size();
        boolean bl2 = this.needBreadthBar = d5 > d6 || this.needLengthBar && d5 > d6 - d4;
        if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
            if (this.needBreadthBar) {
                this.setViewportLength(d7 - d3);
            }
            if (this.needLengthBar) {
                this.setViewportBreadth(d6 - d4);
            }
            virtualScrollBar.setVisible(this.needBreadthBar);
            virtualScrollBar2.setVisible(this.needLengthBar);
        } else {
            virtualScrollBar.setVisible(this.needBreadthBar && this.tempVisibility);
            virtualScrollBar2.setVisible(this.needLengthBar && this.tempVisibility);
        }
    }

    @Override
    protected void setWidth(double d) {
        if (d != this.lastWidth) {
            super.setWidth(d);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            this.requestLayout();
        }
    }

    @Override
    protected void setHeight(double d) {
        if (d != this.lastHeight) {
            super.setHeight(d);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            this.requestLayout();
        }
    }

    private void updateScrollBarsAndCells(boolean bl) {
        int n;
        boolean bl2 = this.isVertical();
        VirtualScrollBar virtualScrollBar = bl2 ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = bl2 ? this.vbar : this.hbar;
        double d = this.snapSize(bl2 ? this.hbar.prefHeight(-1.0) : this.vbar.prefWidth(-1.0));
        double d2 = this.snapSize(bl2 ? this.vbar.prefWidth(-1.0) : this.hbar.prefHeight(-1.0));
        if (!this.cells.isEmpty()) {
            IndexedCell indexedCell;
            int n2;
            double d3 = -this.computeViewportOffset(this.getPosition());
            n = this.computeCurrentIndex() - ((IndexedCell)this.cells.getFirst()).getIndex();
            int n3 = this.cells.size();
            double d4 = d3;
            boolean bl3 = true;
            for (n2 = n; n2 >= 0 && n2 < n3; --n2) {
                indexedCell = (IndexedCell)this.cells.get(n2);
                double d5 = bl3 ? 0.0 : this.getCellLength(indexedCell);
                bl3 = false;
                this.positionCell(indexedCell, d4 -= d5);
            }
            d4 = d3;
            for (n2 = n; n2 >= 0 && n2 < n3; ++n2) {
                indexedCell = (IndexedCell)this.cells.get(n2);
                this.positionCell(indexedCell, d4);
                d4 += this.getCellLength(indexedCell);
            }
        }
        int n4 = this.cells.size();
        for (int i = 0; i < 2; ++i) {
            if (!virtualScrollBar2.isVisible()) {
                if (this.cellCount > n4) {
                    if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                        virtualScrollBar2.setVisible(true);
                    } else {
                        virtualScrollBar2.setVisible(this.tempVisibility);
                    }
                } else if (this.cellCount == n4) {
                    IndexedCell indexedCell = (IndexedCell)this.cells.getLast();
                    if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                        virtualScrollBar2.setVisible(this.getCellPosition(indexedCell) + this.getCellLength(indexedCell) > this.getViewportLength());
                    } else {
                        virtualScrollBar2.setVisible(this.getCellPosition(indexedCell) + this.getCellLength(indexedCell) > this.getViewportLength() && this.tempVisibility);
                    }
                }
                if (virtualScrollBar2.isVisible() && !BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                    this.setViewportBreadth(this.getViewportBreadth() - d2);
                }
            }
            if (virtualScrollBar.isVisible()) continue;
            int n5 = n = this.getMaxPrefBreadth() > this.getViewportBreadth() ? 1 : 0;
            if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                virtualScrollBar.setVisible(n != 0);
                if (n == 0) continue;
                this.setViewportLength(this.getViewportLength() - d);
                continue;
            }
            virtualScrollBar.setVisible(n != 0 && this.tempVisibility);
        }
        this.corner.setVisible(virtualScrollBar.isVisible() && virtualScrollBar2.isVisible());
        double d6 = 0.0;
        double d7 = (bl2 ? this.getHeight() : this.getWidth()) - (virtualScrollBar.isVisible() ? virtualScrollBar.prefHeight(-1.0) : 0.0);
        double d8 = this.getViewportBreadth();
        double d9 = this.getViewportLength();
        if (virtualScrollBar.isVisible()) {
            if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                if (bl2) {
                    this.hbar.resizeRelocate(0.0, d9, d8, this.hbar.prefHeight(d8));
                } else {
                    this.vbar.resizeRelocate(d9, 0.0, this.vbar.prefWidth(d8), d8);
                }
            } else if (bl2) {
                this.hbar.resizeRelocate(0.0, d9 - this.hbar.getHeight(), d8, this.hbar.prefHeight(d8));
            } else {
                this.vbar.resizeRelocate(d9 - this.vbar.getWidth(), 0.0, this.vbar.prefWidth(d8), d8);
            }
            double d10 = Math.max(1.0, Math.abs(this.getMaxPrefBreadth() - d8));
            if (d10 != virtualScrollBar.getMax()) {
                boolean bl4;
                virtualScrollBar.setMax(d10);
                double d11 = virtualScrollBar.getValue();
                boolean bl5 = bl4 = d11 != 0.0 && d10 == d11;
                if (bl4 || d11 > d10) {
                    virtualScrollBar.setValue(d10);
                }
                virtualScrollBar.setVisibleAmount(d8 / this.getMaxPrefBreadth() * d10);
            }
        }
        if (bl && (virtualScrollBar2.isVisible() || BehaviorSkinBase.IS_TOUCH_SUPPORTED)) {
            int n6 = 0;
            int n7 = this.cells.size();
            for (int i = 0; i < n7; ++i) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
                if (indexedCell == null || indexedCell.isEmpty()) continue;
                if ((d6 += bl2 ? indexedCell.getHeight() : indexedCell.getWidth()) > d7) break;
                ++n6;
            }
            virtualScrollBar2.setMax(1.0);
            if (n6 == 0 && this.cellCount == 1) {
                virtualScrollBar2.setVisibleAmount(d7 / d6);
            } else {
                virtualScrollBar2.setVisibleAmount((float)n6 / (float)this.cellCount);
            }
        }
        if (virtualScrollBar2.isVisible()) {
            if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                if (bl2) {
                    this.vbar.resizeRelocate(d8, 0.0, this.vbar.prefWidth(d9), d9);
                } else {
                    this.hbar.resizeRelocate(0.0, d8, d9, this.hbar.prefHeight(-1.0));
                }
            } else if (bl2) {
                this.vbar.resizeRelocate(d8 - this.vbar.getWidth(), 0.0, this.vbar.prefWidth(d9), d9);
            } else {
                this.hbar.resizeRelocate(0.0, d8 - this.hbar.getHeight(), d9, this.hbar.prefHeight(-1.0));
            }
        }
        if (this.corner.isVisible()) {
            if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                this.corner.resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + this.hbar.getWidth(), this.vbar.getLayoutY() + this.vbar.getHeight());
            } else {
                this.corner.resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + (this.hbar.getWidth() - this.vbar.getWidth()), this.vbar.getLayoutY() + (this.vbar.getHeight() - this.hbar.getHeight()));
                this.hbar.resize(this.hbar.getWidth() - this.vbar.getWidth(), this.hbar.getHeight());
                this.vbar.resize(this.vbar.getWidth(), this.vbar.getHeight() - this.hbar.getHeight());
            }
        }
        this.clipView.resize(this.snapSize(bl2 ? d8 : d9), this.snapSize(bl2 ? d9 : d8));
        this.fitCells();
        if (this.getPosition() != virtualScrollBar2.getValue()) {
            virtualScrollBar2.setValue(this.getPosition());
        }
    }

    private void fitCells() {
        double d = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
        boolean bl = this.isVertical();
        for (int i = 0; i < this.cells.size(); ++i) {
            Cell cell = (Cell)this.cells.get(i);
            if (bl) {
                cell.resize(d, cell.getHeight());
                continue;
            }
            cell.resize(cell.getWidth(), d);
        }
    }

    private void cull() {
        double d = this.getViewportLength();
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            double d2 = this.getCellLength(indexedCell);
            double d3 = this.getCellPosition(indexedCell);
            double d4 = d3 + d2;
            if (!(d3 > d) && !(d4 < 0.0)) continue;
            this.addToPile((IndexedCell)this.cells.remove(i));
        }
    }

    protected int getCellIndex(T t) {
        return ((IndexedCell)t).getIndex();
    }

    public T getCell(int n) {
        Callback<VirtualFlow, T> callback;
        T t;
        if (!this.cells.isEmpty() && (t = this.getVisibleCell(n)) != null) {
            return t;
        }
        for (int i = 0; i < this.pile.size(); ++i) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i);
            if (this.getCellIndex(indexedCell) != n) continue;
            return (T)indexedCell;
        }
        if (this.pile.size() > 0) {
            return (T)((IndexedCell)this.pile.get(0));
        }
        if (this.accumCell == null && (callback = this.getCreateCell()) != null) {
            this.accumCell = (IndexedCell)callback.call(this);
            this.accumCellParent.getChildren().setAll((Node[])new Node[]{this.accumCell});
        }
        this.setCellIndex(this.accumCell, n);
        this.resizeCellSize(this.accumCell);
        return this.accumCell;
    }

    private void releaseCell(T t) {
        if (this.accumCell != null && t == this.accumCell) {
            ((IndexedCell)this.accumCell).updateIndex(-1);
        }
    }

    protected double getCellLength(int n) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        T t = this.getCell(n);
        double d = this.getCellLength(t);
        this.releaseCell(t);
        return d;
    }

    protected double getCellBreadth(int n) {
        T t = this.getCell(n);
        double d = this.getCellBreadth((Cell)t);
        this.releaseCell(t);
        return d;
    }

    protected double getCellLength(T t) {
        if (t == null) {
            return 0.0;
        }
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return this.isVertical() ? ((Node)t).getLayoutBounds().getHeight() : ((Node)t).getLayoutBounds().getWidth();
    }

    protected double getCellBreadth(Cell cell) {
        return this.isVertical() ? cell.prefWidth(-1.0) : cell.prefHeight(-1.0);
    }

    protected double getCellPosition(T t) {
        if (t == null) {
            return 0.0;
        }
        return this.isVertical() ? ((Node)t).getLayoutY() : ((Node)t).getLayoutX();
    }

    protected void positionCell(T t, double d) {
        if (this.isVertical()) {
            ((Node)t).setLayoutX(0.0);
            ((Node)t).setLayoutY(this.snapSize(d));
        } else {
            ((Node)t).setLayoutX(this.snapSize(d));
            ((Node)t).setLayoutY(0.0);
        }
    }

    protected void resizeCellSize(T t) {
        if (t == null) {
            return;
        }
        if (this.isVertical()) {
            double d = ((Region)t).getWidth();
            ((Region)t).resize(d, this.fixedCellSizeEnabled ? this.fixedCellSize : ((Region)t).prefHeight(d));
        } else {
            double d = ((Region)t).getHeight();
            ((Region)t).resize(this.fixedCellSizeEnabled ? this.fixedCellSize : ((Region)t).prefWidth(d), d);
        }
    }

    protected void setCellIndex(T t, int n) {
        assert (t != null);
        ((IndexedCell)t).updateIndex(n);
        if (((Parent)t).isNeedsLayout() && ((Node)t).getScene() != null) {
            ((Node)t).impl_processCSS(false);
        }
    }

    protected T getAvailableCell(int n) {
        int n2;
        Node node = null;
        int n3 = this.pile.size();
        for (n2 = 0; n2 < n3; ++n2) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(n2);
            assert (indexedCell != null);
            if (this.getCellIndex(indexedCell) == n) {
                node = indexedCell;
                this.pile.remove(n2);
                break;
            }
            node = null;
        }
        if (node == null) {
            if (this.pile.size() > 0) {
                n2 = (n & 1) == 0 ? 1 : 0;
                int n4 = this.pile.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    IndexedCell indexedCell = (IndexedCell)this.pile.get(n3);
                    int n5 = this.getCellIndex(indexedCell);
                    if ((n5 & 1) == 0 && n2 != 0) {
                        node = indexedCell;
                        this.pile.remove(n3);
                        break;
                    }
                    if ((n5 & 1) != 1 || n2 != 0) continue;
                    node = indexedCell;
                    this.pile.remove(n3);
                    break;
                }
                if (node == null) {
                    node = (IndexedCell)this.pile.removeFirst();
                }
            } else {
                node = (IndexedCell)this.getCreateCell().call(this);
            }
        }
        if (node.getParent() == null) {
            this.sheetChildren.add(node);
        }
        return (T)node;
    }

    protected void addAllToPile() {
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            this.addToPile((IndexedCell)this.cells.removeFirst());
        }
    }

    private void addToPile(T t) {
        assert (t != null);
        this.pile.addLast(t);
    }

    private void cleanPile() {
        int n = this.pile.size();
        for (int i = 0; i < n; ++i) {
            IndexedCell indexedCell = (IndexedCell)this.pile.get(i);
            indexedCell.setVisible(false);
        }
    }

    public T getVisibleCell(int n) {
        if (this.cells.isEmpty()) {
            return null;
        }
        IndexedCell indexedCell = (IndexedCell)this.cells.getLast();
        int n2 = this.getCellIndex(indexedCell);
        if (n == n2) {
            return (T)indexedCell;
        }
        IndexedCell indexedCell2 = (IndexedCell)this.cells.getFirst();
        int n3 = this.getCellIndex(indexedCell2);
        if (n == n3) {
            return (T)indexedCell2;
        }
        if (n > n3 && n < n2) {
            return (T)((IndexedCell)this.cells.get(n - n3));
        }
        return null;
    }

    public T getLastVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            if (indexedCell.isEmpty()) continue;
            return (T)indexedCell;
        }
        return null;
    }

    public T getFirstVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
        return (T)(indexedCell.isEmpty() ? null : indexedCell);
    }

    public T getLastVisibleCellWithinViewPort() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        double d = this.getViewportLength();
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            double d2;
            double d3;
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            if (indexedCell.isEmpty() || !((d3 = (d2 = this.getCellPosition(indexedCell)) + this.getCellLength(indexedCell)) <= d)) continue;
            return (T)indexedCell;
        }
        return null;
    }

    public T getFirstVisibleCellWithinViewPort() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i = 0; i < this.cells.size(); ++i) {
            double d;
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            if (indexedCell.isEmpty() || !((d = this.getCellPosition(indexedCell)) >= 0.0)) continue;
            return (T)indexedCell;
        }
        return null;
    }

    public void showAsFirst(T t) {
        if (t != null) {
            this.adjustPixels(this.getCellPosition(t));
        }
    }

    public void showAsLast(T t) {
        if (t != null) {
            this.adjustPixels(this.getCellPosition(t) + this.getCellLength(t) - this.getViewportLength());
        }
    }

    public void show(T t) {
        if (t != null) {
            double d = this.getCellPosition(t);
            double d2 = this.getCellLength(t);
            double d3 = d + d2;
            double d4 = this.getViewportLength();
            if (d < 0.0) {
                this.adjustPixels(d);
            } else if (d3 > d4) {
                this.adjustPixels(d3 - d4);
            }
        }
    }

    public void show(int n) {
        T t = this.getVisibleCell(n);
        if (t != null) {
            this.show(t);
        } else {
            T t2 = this.getVisibleCell(n - 1);
            if (t2 != null) {
                t = this.getAvailableCell(n);
                this.setCellIndex(t, n);
                this.resizeCellSize(t);
                this.cells.addLast(t);
                this.positionCell(t, this.getCellPosition(t2) + this.getCellLength(t2));
                this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)t)));
                ((Node)t).setVisible(true);
                this.show(t);
                return;
            }
            T t3 = this.getVisibleCell(n + 1);
            if (t3 != null) {
                t = this.getAvailableCell(n);
                this.setCellIndex(t, n);
                this.resizeCellSize(t);
                this.cells.addFirst(t);
                this.positionCell(t, this.getCellPosition(t3) - this.getCellLength(t));
                this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)t)));
                ((Node)t).setVisible(true);
                this.show(t);
                return;
            }
            this.adjustPositionToIndex(n);
            this.addAllToPile();
            this.requestLayout();
        }
    }

    public void scrollTo(int n) {
        boolean bl = false;
        if (n >= this.cellCount - 1) {
            this.setPosition(1.0);
            bl = true;
        } else if (n < 0) {
            this.setPosition(0.0);
            bl = true;
        }
        if (!bl) {
            this.adjustPositionToIndex(n);
            double d = -this.computeOffsetForCell(n);
            this.adjustByPixelAmount(d);
        }
        this.requestLayout();
    }

    public void scrollToOffset(int n) {
        this.adjustPixels((double)n * this.getCellLength(0));
    }

    public double adjustPixels(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        boolean bl = this.isVertical();
        if (bl && (!this.tempVisibility ? !this.vbar.isVisible() : !this.needLengthBar) || !bl && (this.tempVisibility ? !this.needBreadthBar : !this.hbar.isVisible())) {
            return 0.0;
        }
        double d2 = this.getPosition();
        if (d2 == 0.0 && d < 0.0) {
            return 0.0;
        }
        if (d2 == 1.0 && d > 0.0) {
            return 0.0;
        }
        this.adjustByPixelAmount(d);
        if (d2 == this.getPosition()) {
            return 0.0;
        }
        if (this.cells.size() > 0) {
            double d3;
            int n;
            for (int i = 0; i < this.cells.size(); ++i) {
                IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
                assert (indexedCell != null);
                this.positionCell(indexedCell, this.getCellPosition(indexedCell) - d);
            }
            IndexedCell indexedCell = (IndexedCell)this.cells.getFirst();
            double d4 = indexedCell == null ? 0.0 : this.getCellPosition(indexedCell);
            for (n = 0; n < this.cells.size(); ++n) {
                IndexedCell indexedCell2 = (IndexedCell)this.cells.get(n);
                assert (indexedCell2 != null);
                double d5 = this.getCellPosition(indexedCell2);
                if (d5 != d4) {
                    this.positionCell(indexedCell2, d4);
                }
                d4 += this.getCellLength(indexedCell2);
            }
            if (indexedCell != null) {
                n = this.getCellIndex(indexedCell);
                d3 = this.getCellLength(n - 1);
                this.addLeadingCells(n - 1, this.getCellPosition(indexedCell) - d3);
            } else {
                n = this.computeCurrentIndex();
                d3 = -this.computeViewportOffset(this.getPosition());
                this.addLeadingCells(n, d3);
            }
            if (!this.addTrailingCells(false)) {
                double d6;
                T t = this.getLastVisibleCell();
                d3 = this.getCellLength(t);
                double d7 = this.getCellPosition(t) + d3;
                if (d7 < (d6 = this.getViewportLength())) {
                    double d8 = d6 - d7;
                    for (int i = 0; i < this.cells.size(); ++i) {
                        IndexedCell indexedCell3 = (IndexedCell)this.cells.get(i);
                        this.positionCell(indexedCell3, this.getCellPosition(indexedCell3) + d8);
                    }
                    this.setPosition(1.0);
                }
            }
        }
        this.cull();
        this.updateScrollBarsAndCells(false);
        this.lastPosition = this.getPosition();
        return d;
    }

    public void reconfigureCells() {
        this.needsReconfigureCells = true;
        this.requestLayout();
    }

    public void recreateCells() {
        this.needsRecreateCells = true;
        this.requestLayout();
    }

    public void rebuildCells() {
        this.needsRebuildCells = true;
        this.requestLayout();
    }

    public void requestCellLayout() {
        this.needsCellsLayout = true;
        this.requestLayout();
    }

    private double getPrefBreadth(double d) {
        double d2 = this.getMaxCellWidth(10);
        if (d > -1.0) {
            double d3 = this.getPrefLength();
            d2 = Math.max(d2, d3 * 0.618033987);
        }
        return d2;
    }

    private double getPrefLength() {
        double d = 0.0;
        int n = Math.min(10, this.cellCount);
        for (int i = 0; i < n; ++i) {
            d += this.getCellLength(i);
        }
        return d;
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.isVertical() ? this.getPrefBreadth(d) : this.getPrefLength();
        return d2 + this.vbar.prefWidth(-1.0);
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = this.isVertical() ? this.getPrefLength() : this.getPrefBreadth(d);
        return d2 + this.hbar.prefHeight(-1.0);
    }

    double getMaxCellWidth(int n) {
        double d = 0.0;
        int n2 = Math.max(1, n == -1 ? this.cellCount : n);
        for (int i = 0; i < n2; ++i) {
            d = Math.max(d, this.getCellBreadth(i));
        }
        return d;
    }

    private double computeViewportOffset(double d) {
        double d2 = Utils.clamp(0.0, d, 1.0);
        double d3 = d2 * (double)this.getCellCount();
        int n = (int)d3;
        double d4 = d3 - (double)n;
        double d5 = this.getCellLength(n);
        double d6 = d5 * d4;
        double d7 = this.getViewportLength() * d2;
        return d6 - d7;
    }

    private void adjustPositionToIndex(int n) {
        int n2 = this.getCellCount();
        if (n2 <= 0) {
            this.setPosition(0.0);
        } else {
            this.setPosition((double)n / (double)n2);
        }
    }

    private void adjustByPixelAmount(double d) {
        double d2;
        if (d == 0.0) {
            return;
        }
        boolean bl = d > 0.0;
        int n = this.getCellCount();
        double d3 = this.getPosition() * (double)n;
        int n2 = (int)d3;
        if (bl && n2 == n) {
            return;
        }
        double d4 = this.getCellLength(n2);
        double d5 = d3 - (double)n2;
        double d6 = d4 * d5;
        double d7 = 1.0 / (double)n;
        double d8 = this.computeOffsetForCell(n2);
        double d9 = d4 + this.computeOffsetForCell(n2 + 1);
        double d10 = d9 - d8;
        double d11 = d7 * (double)n2;
        for (d2 = bl ? d + d6 - this.getViewportLength() * this.getPosition() - d8 : -d + d9 - (d6 - this.getViewportLength() * this.getPosition()); d2 > d10 && (bl && n2 < n - 1 || !bl && n2 > 0); d2 -= d10) {
            n2 = bl ? ++n2 : --n2;
            d4 = this.getCellLength(n2);
            d8 = this.computeOffsetForCell(n2);
            d9 = d4 + this.computeOffsetForCell(n2 + 1);
            d10 = d9 - d8;
            d11 = d7 * (double)n2;
        }
        if (d2 > d10) {
            this.setPosition(bl ? 1.0 : 0.0);
        } else if (bl) {
            double d12 = d7 / Math.abs(d9 - d8);
            this.setPosition(d11 + d12 * d2);
        } else {
            double d13 = d7 / Math.abs(d9 - d8);
            this.setPosition(d11 + d7 - d13 * d2);
        }
    }

    private int computeCurrentIndex() {
        return (int)(this.getPosition() * (double)this.getCellCount());
    }

    private double computeOffsetForCell(int n) {
        double d = this.getCellCount();
        double d2 = Utils.clamp(0.0, (double)n, d) / d;
        return -(this.getViewportLength() * d2);
    }

    protected void startSBReleasedAnimation() {
        if (this.sbTouchTimeline == null) {
            this.sbTouchTimeline = new Timeline();
            this.sbTouchKF1 = new KeyFrame(Duration.millis(0.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    VirtualFlow.this.tempVisibility = true;
                    VirtualFlow.this.requestLayout();
                }
            }, new KeyValue[0]);
            this.sbTouchKF2 = new KeyFrame(Duration.millis(1000.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (!VirtualFlow.this.touchDetected && !VirtualFlow.this.mouseDown) {
                        VirtualFlow.this.tempVisibility = false;
                        VirtualFlow.this.requestLayout();
                    }
                }
            }, new KeyValue[0]);
            this.sbTouchTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.sbTouchKF1, this.sbTouchKF2});
        }
        this.sbTouchTimeline.playFromStart();
    }

    protected void scrollBarOn() {
        this.tempVisibility = true;
        this.requestLayout();
    }

    public static class ArrayLinkedList<T>
    extends AbstractList {
        private final ArrayList<T> array = new ArrayList(50);
        private int firstIndex = -1;
        private int lastIndex = -1;

        public ArrayLinkedList() {
            for (int i = 0; i < 50; ++i) {
                this.array.add(null);
            }
        }

        @Override
        public T getFirst() {
            return this.firstIndex == -1 ? null : (T)this.array.get(this.firstIndex);
        }

        @Override
        public T getLast() {
            return this.lastIndex == -1 ? null : (T)this.array.get(this.lastIndex);
        }

        @Override
        public void addFirst(T t) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.firstIndex, t);
            } else if (this.firstIndex == 0) {
                this.array.add(0, t);
                ++this.lastIndex;
            } else {
                this.array.set(--this.firstIndex, t);
            }
        }

        @Override
        public void addLast(T t) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.lastIndex, t);
            } else if (this.lastIndex == this.array.size() - 1) {
                this.array.add(++this.lastIndex, t);
            } else {
                this.array.set(++this.lastIndex, t);
            }
        }

        @Override
        public int size() {
            return this.firstIndex == -1 ? 0 : this.lastIndex - this.firstIndex + 1;
        }

        @Override
        public boolean isEmpty() {
            return this.firstIndex == -1;
        }

        @Override
        public T get(int n) {
            if (n > this.lastIndex - this.firstIndex || n < 0) {
                return null;
            }
            return this.array.get(this.firstIndex + n);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.array.size(); ++i) {
                this.array.set(i, null);
            }
            this.lastIndex = -1;
            this.firstIndex = -1;
        }

        @Override
        public T removeFirst() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(0);
        }

        @Override
        public T removeLast() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(this.lastIndex - this.firstIndex);
        }

        @Override
        public T remove(int n) {
            if (n > this.lastIndex - this.firstIndex || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n == 0) {
                T t = this.array.get(this.firstIndex);
                this.array.set(this.firstIndex, null);
                if (this.firstIndex == this.lastIndex) {
                    this.lastIndex = -1;
                    this.firstIndex = -1;
                } else {
                    ++this.firstIndex;
                }
                return t;
            }
            if (n == this.lastIndex - this.firstIndex) {
                T t = this.array.get(this.lastIndex);
                this.array.set(this.lastIndex--, null);
                return t;
            }
            T t = this.array.get(this.firstIndex + n);
            this.array.set(this.firstIndex + n, null);
            for (int i = this.firstIndex + n + 1; i <= this.lastIndex; ++i) {
                this.array.set(i - 1, this.array.get(i));
            }
            this.array.set(this.lastIndex--, null);
            return t;
        }
    }

    static class ClippedContainer
    extends Region {
        private Node node;
        private final Rectangle clipRect;

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
            this.getChildren().clear();
            this.getChildren().add(this.node);
        }

        public void setClipX(double d) {
            this.setLayoutX(-d);
            this.clipRect.setLayoutX(d);
        }

        public void setClipY(double d) {
            this.setLayoutY(-d);
            this.clipRect.setLayoutY(d);
        }

        public ClippedContainer(VirtualFlow virtualFlow) {
            if (virtualFlow == null) {
                throw new IllegalArgumentException("VirtualFlow can not be null");
            }
            this.getStyleClass().add("clipped-container");
            this.clipRect = new Rectangle();
            this.clipRect.setSmooth(false);
            this.setClip(this.clipRect);
            super.widthProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    clipRect.setWidth(this.getWidth());
                }
            });
            super.heightProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    clipRect.setHeight(this.getHeight());
                }
            });
        }
    }
}

