/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class ScrollBarSkin
extends BehaviorSkinBase<ScrollBar, ScrollBarBehavior> {
    public static final int DEFAULT_LENGTH = 100;
    public static final int DEFAULT_WIDTH = 20;
    private StackPane thumb;
    private StackPane trackBackground;
    private StackPane track;
    private EndButton incButton;
    private EndButton decButton;
    private double trackLength;
    private double thumbLength;
    private double preDragThumbPos;
    private Point2D dragStart;
    private double trackPos;
    private static final double DEFAULT_EMBEDDED_SB_BREADTH = 8.0;

    public ScrollBarSkin(ScrollBar scrollBar) {
        super(scrollBar, new ScrollBarBehavior(scrollBar));
        this.initialize();
        ((ScrollBar)this.getSkinnable()).requestLayout();
        this.registerChangeListener(scrollBar.minProperty(), "MIN");
        this.registerChangeListener(scrollBar.maxProperty(), "MAX");
        this.registerChangeListener(scrollBar.valueProperty(), "VALUE");
        this.registerChangeListener(scrollBar.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(scrollBar.visibleAmountProperty(), "VISIBLE_AMOUNT");
    }

    private void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.trackBackground = new StackPane();
        this.trackBackground.getStyleClass().setAll((String[])new String[]{"track-background"});
        this.thumb = new StackPane();
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        if (!IS_TOUCH_SUPPORTED) {
            this.incButton = new EndButton("increment-button", "increment-arrow");
            this.incButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).incButtonPressed(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
            this.incButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).incButtonReleased(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
            this.decButton = new EndButton("decrement-button", "decrement-arrow");
            this.decButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).decButtonPressed(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
            this.decButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).decButtonReleased(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
        }
        this.track.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!ScrollBarSkin.this.thumb.isPressed() && mouseEvent.getButton() == MouseButton.PRIMARY) {
                    if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        if (ScrollBarSkin.this.trackLength != 0.0) {
                            ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getY() / ScrollBarSkin.this.trackLength);
                            mouseEvent.consume();
                        }
                    } else if (ScrollBarSkin.this.trackLength != 0.0) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getX() / ScrollBarSkin.this.trackLength);
                        mouseEvent.consume();
                    }
                }
            }
        });
        this.track.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackRelease(mouseEvent, 0.0);
                mouseEvent.consume();
            }
        });
        this.thumb.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isSynthesized()) {
                    mouseEvent.consume();
                    return;
                }
                if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    ScrollBarSkin.this.dragStart = ScrollBarSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                    double d = Utils.clamp(((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getValue(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax());
                    ScrollBarSkin.this.preDragThumbPos = (d - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) / (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin());
                    mouseEvent.consume();
                }
            }
        });
        this.thumb.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isSynthesized()) {
                    mouseEvent.consume();
                    return;
                }
                if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        Point2D point2D = ScrollBarSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                        if (ScrollBarSkin.this.dragStart == null) {
                            ScrollBarSkin.this.dragStart = ScrollBarSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                        }
                        double d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? point2D.getY() - ScrollBarSkin.this.dragStart.getY() : point2D.getX() - ScrollBarSkin.this.dragStart.getX();
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).thumbDragged(mouseEvent, ScrollBarSkin.this.preDragThumbPos + d / (ScrollBarSkin.this.trackLength - ScrollBarSkin.this.thumbLength));
                    }
                    mouseEvent.consume();
                }
            }
        });
        this.thumb.setOnScrollStarted((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (scrollEvent.isDirect() && ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    ScrollBarSkin.this.dragStart = ScrollBarSkin.this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                    double d = Utils.clamp(((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getValue(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax());
                    ScrollBarSkin.this.preDragThumbPos = (d - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) / (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin());
                    scrollEvent.consume();
                }
            }
        });
        this.thumb.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (scrollEvent.isDirect() && ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        Point2D point2D = ScrollBarSkin.this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                        if (ScrollBarSkin.this.dragStart == null) {
                            ScrollBarSkin.this.dragStart = ScrollBarSkin.this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                        }
                        double d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? point2D.getY() - ScrollBarSkin.this.dragStart.getY() : point2D.getX() - ScrollBarSkin.this.dragStart.getX();
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).thumbDragged(null, ScrollBarSkin.this.preDragThumbPos + d / (ScrollBarSkin.this.trackLength - ScrollBarSkin.this.thumbLength));
                    }
                    scrollEvent.consume();
                    return;
                }
            }
        });
        ((ScrollBar)this.getSkinnable()).setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                    double d;
                    double d2 = scrollEvent.getDeltaX();
                    double d3 = scrollEvent.getDeltaY();
                    d2 = Math.abs(d2) < Math.abs(d3) ? d3 : d2;
                    ScrollBar scrollBar = (ScrollBar)ScrollBarSkin.this.getSkinnable();
                    double d4 = d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? d3 : d2;
                    if (scrollEvent.isDirect()) {
                        if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                            ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).thumbDragged(null, (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? scrollEvent.getY() : scrollEvent.getX()) / ScrollBarSkin.this.trackLength);
                            scrollEvent.consume();
                        }
                    } else if (d > 0.0 && scrollBar.getValue() > scrollBar.getMin()) {
                        scrollBar.decrement();
                        scrollEvent.consume();
                    } else if (d < 0.0 && scrollBar.getValue() < scrollBar.getMax()) {
                        scrollBar.increment();
                        scrollEvent.consume();
                    }
                }
            }
        });
        this.getChildren().clear();
        if (!IS_TOUCH_SUPPORTED) {
            this.getChildren().addAll((Node[])new Node[]{this.trackBackground, this.incButton, this.decButton, this.track, this.thumb});
        } else {
            this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ORIENTATION".equals(string)) {
            ((ScrollBar)this.getSkinnable()).requestLayout();
        } else if ("MIN".equals(string) || "MAX".equals(string) || "VISIBLE_AMOUNT".equals(string)) {
            this.positionThumb();
            ((ScrollBar)this.getSkinnable()).requestLayout();
        } else if ("VALUE".equals(string)) {
            this.positionThumb();
        }
    }

    double getBreadth() {
        if (!IS_TOUCH_SUPPORTED) {
            if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                return Math.max(this.decButton.prefWidth(-1.0), this.incButton.prefWidth(-1.0)) + this.snappedLeftInset() + this.snappedRightInset();
            }
            return Math.max(this.decButton.prefHeight(-1.0), this.incButton.prefHeight(-1.0)) + this.snappedTopInset() + this.snappedBottomInset();
        }
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return Math.max(8.0, 8.0) + this.snappedLeftInset() + this.snappedRightInset();
        }
        return Math.max(8.0, 8.0) + this.snappedTopInset() + this.snappedBottomInset();
    }

    double minThumbLength() {
        return 1.5 * this.getBreadth();
    }

    double minTrackLength() {
        return 2.0 * this.getBreadth();
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.getBreadth();
        }
        if (!IS_TOUCH_SUPPORTED) {
            return this.decButton.minWidth(-1.0) + this.incButton.minWidth(-1.0) + this.minTrackLength() + d5 + d3;
        }
        return this.minTrackLength() + d5 + d3;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            if (!IS_TOUCH_SUPPORTED) {
                return this.decButton.minHeight(-1.0) + this.incButton.minHeight(-1.0) + this.minTrackLength() + d2 + d4;
            }
            return this.minTrackLength() + d2 + d4;
        }
        return this.getBreadth();
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        return scrollBar.getOrientation() == Orientation.VERTICAL ? this.getBreadth() : 100.0 + d5 + d3;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        return scrollBar.getOrientation() == Orientation.VERTICAL ? 100.0 + d2 + d4 : this.getBreadth();
    }

    @Override
    protected double computeMaxWidth(double d, double d2, double d3, double d4, double d5) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        return scrollBar.getOrientation() == Orientation.VERTICAL ? scrollBar.prefWidth(-1.0) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        return scrollBar.getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : scrollBar.prefHeight(-1.0);
    }

    void positionThumb() {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        double d = Utils.clamp(scrollBar.getMin(), scrollBar.getValue(), scrollBar.getMax());
        double d2 = this.trackPos = scrollBar.getMax() - scrollBar.getMin() > 0.0 ? (this.trackLength - this.thumbLength) * (d - scrollBar.getMin()) / (scrollBar.getMax() - scrollBar.getMin()) : 0.0;
        if (!IS_TOUCH_SUPPORTED) {
            this.trackPos = scrollBar.getOrientation() == Orientation.VERTICAL ? (this.trackPos += this.decButton.prefHeight(-1.0)) : (this.trackPos += this.decButton.prefWidth(-1.0));
        }
        this.thumb.setTranslateX(this.snapPosition(scrollBar.getOrientation() == Orientation.VERTICAL ? this.snappedLeftInset() : this.trackPos + this.snappedLeftInset()));
        this.thumb.setTranslateY(this.snapPosition(scrollBar.getOrientation() == Orientation.VERTICAL ? this.trackPos + this.snappedTopInset() : this.snappedTopInset()));
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        double d5 = scrollBar.getMax() > scrollBar.getMin() ? scrollBar.getVisibleAmount() / (scrollBar.getMax() - scrollBar.getMin()) : 1.0;
        if (scrollBar.getOrientation() == Orientation.VERTICAL) {
            if (!IS_TOUCH_SUPPORTED) {
                double d6 = this.snapSize(this.decButton.prefHeight(-1.0));
                double d7 = this.snapSize(this.incButton.prefHeight(-1.0));
                this.decButton.resize(d3, d6);
                this.incButton.resize(d3, d7);
                this.trackLength = this.snapSize(d4 - (d6 + d7));
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d5, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), d3, this.trackLength + d6 + d7);
                this.decButton.relocate(this.snapPosition(d), this.snapPosition(d2));
                this.incButton.relocate(this.snapPosition(d), this.snapPosition(d2 + d4 - d7));
                this.track.resizeRelocate(this.snapPosition(d), this.snapPosition(d2 + d6), d3, this.trackLength);
                this.thumb.resize(this.snapSize(d >= 0.0 ? d3 : d3 + d), this.thumbLength);
                this.positionThumb();
            } else {
                this.trackLength = this.snapSize(d4);
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d5, this.trackLength));
                this.track.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), d3, this.trackLength);
                this.thumb.resize(this.snapSize(d >= 0.0 ? d3 : d3 + d), this.thumbLength);
                this.positionThumb();
            }
        } else {
            if (!IS_TOUCH_SUPPORTED) {
                double d8 = this.snapSize(this.decButton.prefWidth(-1.0));
                double d9 = this.snapSize(this.incButton.prefWidth(-1.0));
                this.decButton.resize(d8, d4);
                this.incButton.resize(d9, d4);
                this.trackLength = this.snapSize(d3 - (d8 + d9));
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d5, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), this.trackLength + d8 + d9, d4);
                this.decButton.relocate(this.snapPosition(d), this.snapPosition(d2));
                this.incButton.relocate(this.snapPosition(d + d3 - d9), this.snapPosition(d2));
                this.track.resizeRelocate(this.snapPosition(d + d8), this.snapPosition(d2), this.trackLength, d4);
                this.thumb.resize(this.thumbLength, this.snapSize(d2 >= 0.0 ? d4 : d4 + d2));
                this.positionThumb();
            } else {
                this.trackLength = this.snapSize(d3);
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d5, this.trackLength));
                this.track.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), this.trackLength, d4);
                this.thumb.resize(this.thumbLength, this.snapSize(d2 >= 0.0 ? d4 : d4 + d2));
                this.positionThumb();
            }
            scrollBar.resize(this.snapSize(scrollBar.getWidth()), this.snapSize(scrollBar.getHeight()));
        }
        if (scrollBar.getOrientation() == Orientation.VERTICAL && d4 >= this.computeMinHeight(-1.0, (int)d2, this.snappedRightInset(), this.snappedBottomInset(), (int)d) - (d2 + this.snappedBottomInset()) || scrollBar.getOrientation() == Orientation.HORIZONTAL && d3 >= this.computeMinWidth(-1.0, (int)d2, this.snappedRightInset(), this.snappedBottomInset(), (int)d) - (d + this.snappedRightInset())) {
            this.trackBackground.setVisible(true);
            this.track.setVisible(true);
            this.thumb.setVisible(true);
            if (!IS_TOUCH_SUPPORTED) {
                this.incButton.setVisible(true);
                this.decButton.setVisible(true);
            }
        } else {
            this.trackBackground.setVisible(false);
            this.track.setVisible(false);
            this.thumb.setVisible(false);
            if (!IS_TOUCH_SUPPORTED) {
                if (d4 >= this.decButton.computeMinWidth(-1.0)) {
                    this.decButton.setVisible(true);
                } else {
                    this.decButton.setVisible(false);
                }
                if (d4 >= this.incButton.computeMinWidth(-1.0)) {
                    this.incButton.setVisible(true);
                } else {
                    this.incButton.setVisible(false);
                }
            }
        }
    }

    private static class EndButton
    extends Region {
        private Region arrow;

        private EndButton(String string, String string2) {
            this.getStyleClass().setAll((String[])new String[]{string});
            this.arrow = new Region();
            this.arrow.getStyleClass().setAll((String[])new String[]{string2});
            this.getChildren().setAll((Node[])new Node[]{this.arrow});
            this.requestLayout();
        }

        @Override
        protected void layoutChildren() {
            double d = this.snappedTopInset();
            double d2 = this.snappedLeftInset();
            double d3 = this.snappedBottomInset();
            double d4 = this.snappedRightInset();
            double d5 = this.snapSize(this.arrow.prefWidth(-1.0));
            double d6 = this.snapSize(this.arrow.prefHeight(-1.0));
            double d7 = this.snapPosition((this.getHeight() - (d + d3 + d6)) / 2.0);
            double d8 = this.snapPosition((this.getWidth() - (d2 + d4 + d5)) / 2.0);
            this.arrow.resizeRelocate(d8 + d2, d7 + d, d5, d6);
        }

        @Override
        protected double computeMinHeight(double d) {
            return this.prefHeight(-1.0);
        }

        @Override
        protected double computeMinWidth(double d) {
            return this.prefWidth(-1.0);
        }

        @Override
        protected double computePrefWidth(double d) {
            double d2 = this.snappedLeftInset();
            double d3 = this.snappedRightInset();
            double d4 = this.snapSize(this.arrow.prefWidth(-1.0));
            return d2 + d4 + d3;
        }

        @Override
        protected double computePrefHeight(double d) {
            double d2 = this.snappedTopInset();
            double d3 = this.snappedBottomInset();
            double d4 = this.snapSize(this.arrow.prefHeight(-1.0));
            return d2 + d4 + d3;
        }
    }
}

