/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ListViewBehavior;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class ListViewSkin<T>
extends VirtualContainerBase<ListView<T>, ListViewBehavior<T>, ListCell<T>> {
    private StackPane placeholderRegion;
    private Node placeholderNode;
    private static final String EMPTY_LIST_TEXT = ControlResources.getString("ListView.noContent");
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.javafx.scene.control.skin.ListViewSkin.pannable");
        }
    });
    private ObservableList<T> listViewItems;
    private final ListChangeListener<T> listViewItemsListener = new ListChangeListener<T>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends T> change) {
            while (change.next()) {
                if (change.wasReplaced()) {
                    ListViewSkin.this.itemCount = 0;
                    break;
                }
                if (change.getRemovedSize() != ListViewSkin.this.itemCount) continue;
                ListViewSkin.this.itemCount = 0;
                break;
            }
            ListViewSkin.this.rowCountDirty = true;
            ((ListView)ListViewSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final WeakListChangeListener<T> weakListViewItemsListener = new WeakListChangeListener<T>(this.listViewItemsListener);
    private int itemCount = -1;
    private boolean needCellsRebuilt = true;
    private boolean needCellsReconfigured = false;

    public ListViewSkin(final ListView<T> listView) {
        super(listView, new ListViewBehavior<T>(listView));
        this.updateListViewItems();
        this.flow.setId("virtual-flow");
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setVertical(((ListView)this.getSkinnable()).getOrientation() == Orientation.VERTICAL);
        this.flow.setFocusTraversable(((ListView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCreateCell(new Callback<VirtualFlow, ListCell<T>>(){

            @Override
            public ListCell<T> call(VirtualFlow virtualFlow) {
                return ListViewSkin.this.createCell();
            }
        });
        this.flow.setFixedCellSize(listView.getFixedCellSize());
        this.getChildren().add(this.flow);
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (listView.getEditingIndex() > -1) {
                    listView.edit(-1);
                }
                listView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.updateRowCount();
        ((ListViewBehavior)this.getBehavior()).setOnFocusPreviousRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onFocusPreviousCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnFocusNextRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onFocusNextCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onMoveToFirstCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onMoveToLastCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnScrollPageDown(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return ListViewSkin.this.onScrollPageDown(n);
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnScrollPageUp(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return ListViewSkin.this.onScrollPageUp(n);
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onSelectPreviousCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onSelectNextCell();
            }
        });
        this.registerChangeListener(listView.itemsProperty(), "ITEMS");
        this.registerChangeListener(listView.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(listView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(listView.parentProperty(), "PARENT");
        this.registerChangeListener(listView.focusTraversableProperty(), "FOCUS_TRAVERSABLE");
        this.registerChangeListener(listView.placeholderProperty(), "PLACEHOLDER");
        this.registerChangeListener(listView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ITEMS".equals(string)) {
            this.updateListViewItems();
        } else if ("ORIENTATION".equals(string)) {
            this.flow.setVertical(((ListView)this.getSkinnable()).getOrientation() == Orientation.VERTICAL);
        } else if ("CELL_FACTORY".equals(string)) {
            this.flow.recreateCells();
        } else if ("PARENT".equals(string)) {
            if (((ListView)this.getSkinnable()).getParent() != null && ((ListView)this.getSkinnable()).isVisible()) {
                ((ListView)this.getSkinnable()).requestLayout();
            }
        } else if ("FOCUS_TRAVERSABLE".equals(string)) {
            this.flow.setFocusTraversable(((ListView)this.getSkinnable()).isFocusTraversable());
        } else if ("PLACEHOLDER".equals(string)) {
            this.updatePlaceholderRegionVisibility();
        } else if ("FIXED_CELL_SIZE".equals(string)) {
            this.flow.setFixedCellSize(((ListView)this.getSkinnable()).getFixedCellSize());
        }
    }

    public void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = ((ListView)this.getSkinnable()).getItems();
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.rowCountDirty = true;
        ((ListView)this.getSkinnable()).requestLayout();
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    protected void updateRowCount() {
        int n;
        if (this.flow == null) {
            return;
        }
        int n2 = this.itemCount;
        this.itemCount = n = this.listViewItems == null ? 0 : this.listViewItems.size();
        this.flow.setCellCount(n);
        this.updatePlaceholderRegionVisibility();
        if (n != n2) {
            this.needCellsRebuilt = true;
        } else {
            this.needCellsReconfigured = true;
        }
    }

    protected final void updatePlaceholderRegionVisibility() {
        boolean bl;
        boolean bl2 = bl = this.getItemCount() == 0;
        if (bl) {
            this.placeholderNode = ((ListView)this.getSkinnable()).getPlaceholder();
            if (this.placeholderNode == null && EMPTY_LIST_TEXT != null && !EMPTY_LIST_TEXT.isEmpty()) {
                this.placeholderNode = new Label();
                ((Label)this.placeholderNode).setText(EMPTY_LIST_TEXT);
            }
            if (this.placeholderNode != null) {
                if (this.placeholderRegion == null) {
                    this.placeholderRegion = new StackPane();
                    this.placeholderRegion.getStyleClass().setAll((String[])new String[]{"placeholder"});
                    this.getChildren().add(this.placeholderRegion);
                }
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{this.placeholderNode});
            }
        }
        this.flow.setVisible(!bl);
        if (this.placeholderRegion != null) {
            this.placeholderRegion.setVisible(bl);
        }
    }

    @Override
    public ListCell<T> createCell() {
        ListCell<T> listCell = ((ListView)this.getSkinnable()).getCellFactory() != null ? ((ListView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : ListViewSkin.createDefaultCellImpl();
        listCell.updateListView((ListView)this.getSkinnable());
        return listCell;
    }

    private static <T> ListCell<T> createDefaultCellImpl() {
        return new ListCell<T>(){

            @Override
            public void updateItem(T t, boolean bl) {
                super.updateItem(t, bl);
                if (bl) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (t instanceof Node) {
                    this.setText(null);
                    Node node = this.getGraphic();
                    Node node2 = (Node)t;
                    if (node == null || !node.equals(node2)) {
                        this.setGraphic(node2);
                    }
                } else {
                    this.setText(t == null ? "null" : t.toString());
                    this.setGraphic(null);
                }
            }
        };
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        super.layoutChildren(d, d2, d3, d4);
        if (this.needCellsRebuilt) {
            this.flow.rebuildCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRebuilt = false;
        this.needCellsReconfigured = false;
        if (this.getItemCount() == 0) {
            if (this.placeholderRegion != null) {
                this.placeholderRegion.setVisible(d3 > 0.0 && d4 > 0.0);
                this.placeholderRegion.resizeRelocate(d, d2, d3, d4);
            }
        } else {
            this.flow.resizeRelocate(d, d2, d3, d4);
        }
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        this.checkState();
        if (this.getItemCount() == 0) {
            if (this.placeholderRegion == null) {
                this.updatePlaceholderRegionVisibility();
            }
            if (this.placeholderRegion != null) {
                return this.placeholderRegion.prefWidth(d) + d5 + d3;
            }
        }
        return this.computePrefHeight(-1.0, d2, d3, d4, d5) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return 400.0;
    }

    private void onFocusPreviousCell() {
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        this.flow.show(n);
        Object t = this.flow.getFirstVisibleCell();
        if (t == null || n < ((IndexedCell)t).getIndex()) {
            this.flow.setPosition((double)n / (double)this.getItemCount());
        }
    }

    private void onSelectNextCell() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        this.flow.show(n);
        ListCell listCell = (ListCell)this.flow.getLastVisibleCell();
        if (listCell == null || listCell.getIndex() < n) {
            this.flow.setPosition((double)n / (double)this.getItemCount());
        }
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        int n = this.getItemCount() - 1;
        this.flow.show(n);
        this.flow.setPosition(1.0);
    }

    private int onScrollPageDown(int n) {
        ListCell listCell = (ListCell)this.flow.getLastVisibleCellWithinViewPort();
        if (listCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = listCell.getIndex();
        if (multipleSelectionModel.isSelected(n2) || focusModel.isFocused(n2) || n2 == n) {
            this.flow.showAsFirst(listCell);
            ListCell listCell2 = (ListCell)this.flow.getLastVisibleCellWithinViewPort();
            listCell = listCell2 == null ? listCell : listCell2;
        }
        int n3 = listCell.getIndex();
        this.flow.show(listCell);
        return n3;
    }

    private int onScrollPageUp(int n) {
        ListCell listCell = (ListCell)this.flow.getFirstVisibleCellWithinViewPort();
        if (listCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = listCell.getIndex();
        if (multipleSelectionModel.isSelected(n2) || focusModel.isFocused(n2) || n2 == n) {
            this.flow.showAsLast(listCell);
            ListCell listCell2 = (ListCell)this.flow.getFirstVisibleCellWithinViewPort();
            listCell = listCell2 == null ? listCell : listCell2;
        }
        int n3 = listCell.getIndex();
        this.flow.show(listCell);
        return n3;
    }
}

