/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class TreeTableCellBehavior<S, T>
extends TableCellBehaviorBase<TreeItem<S>, T, TreeTableColumn<S, ?>, TreeTableCell<S, T>> {
    public TreeTableCellBehavior(TreeTableCell<S, T> treeTableCell) {
        super(treeTableCell);
    }

    @Override
    TreeTableView<S> getTableControl() {
        return ((TreeTableCell)this.getControl()).getTreeTableView();
    }

    @Override
    TreeTableColumn<S, T> getTableColumn() {
        return ((TreeTableCell)this.getControl()).getTableColumn();
    }

    @Override
    int getItemCount() {
        return ((TreeTableView)this.getTableControl()).getExpandedItemCount();
    }

    @Override
    TreeTableView.TreeTableViewSelectionModel<S> getSelectionModel() {
        return ((TreeTableView)this.getTableControl()).getSelectionModel();
    }

    TreeTableView.TreeTableViewFocusModel<S> getFocusModel() {
        return ((TreeTableView)this.getTableControl()).getFocusModel();
    }

    @Override
    TablePositionBase getFocusedCell() {
        return ((TreeTableView)this.getTableControl()).getFocusModel().getFocusedCell();
    }

    @Override
    boolean isTableRowSelected() {
        return ((TreeTableCell)this.getControl()).getTreeTableRow().isSelected();
    }

    @Override
    TableColumnBase getVisibleLeafColumn(int n) {
        return ((TreeTableView)this.getTableControl()).getVisibleLeafColumn(n);
    }

    @Override
    protected int getVisibleLeafIndex(TableColumnBase tableColumnBase) {
        return ((TreeTableView)this.getTableControl()).getVisibleLeafIndex(null);
    }

    @Override
    void focus(int n, TableColumnBase tableColumnBase) {
        ((TreeTableView.TreeTableViewFocusModel)this.getFocusModel()).focus(n, (TreeTableColumn)tableColumnBase);
    }

    @Override
    void edit(int n, TableColumnBase tableColumnBase) {
        ((TreeTableView)this.getTableControl()).edit(n, (TreeTableColumn)tableColumnBase);
    }

    @Override
    protected boolean checkDisclosureNodeClick(MouseEvent mouseEvent) {
        TreeItem treeItem = ((TreeTableCell)this.getControl()).getTreeTableRow().getTreeItem();
        Node node = ((TreeTableCell)this.getControl()).getTreeTableRow().getDisclosureNode();
        if (node != null && node.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (treeItem != null) {
                treeItem.setExpanded(!treeItem.isExpanded());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void simpleSelect(MouseEvent mouseEvent) {
        TreeTableView treeTableView = ((TreeTableCell)this.getControl()).getTreeTableView();
        TreeItem treeItem = ((TreeTableCell)this.getControl()).getTreeTableRow().getTreeItem();
        int n = ((TreeTableCell)this.getControl()).getIndex();
        TableColumnBase tableColumnBase = this.getTableColumn();
        TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel = treeTableView.getSelectionModel();
        boolean bl = treeTableViewSelectionModel.isSelected(n, tableColumnBase);
        if (bl && (mouseEvent.isControlDown() || mouseEvent.isMetaDown())) {
            treeTableViewSelectionModel.clearSelection(n, tableColumnBase);
            bl = false;
        } else {
            treeTableViewSelectionModel.clearAndSelect(n, tableColumnBase);
        }
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getClickCount() == 1 && bl) {
                treeTableView.edit(n, tableColumnBase);
            } else if (mouseEvent.getClickCount() == 1) {
                treeTableView.edit(-1, null);
            } else if (mouseEvent.getClickCount() == 2 && treeItem.isLeaf()) {
                treeTableView.edit(n, tableColumnBase);
            } else if (mouseEvent.getClickCount() % 2 == 0) {
                treeItem.setExpanded(!treeItem.isExpanded());
            }
        }
    }
}

