/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import sun.util.logging.PlatformLogger;

public class TreeCellBehavior<T>
extends CellBehaviorBase<TreeCell<T>> {
    private static final String ANCHOR_PROPERTY_KEY = "list.anchor";
    private boolean latePress = false;
    private boolean wasSelected = false;

    static int getAnchor(TreeView<?> treeView) {
        FocusModel<TreeItem<?>> focusModel = treeView.getFocusModel();
        if (focusModel == null) {
            return -1;
        }
        return TreeCellBehavior.hasAnchor(treeView) ? ((Integer)treeView.getProperties().get(ANCHOR_PROPERTY_KEY)).intValue() : focusModel.getFocusedIndex();
    }

    static void setAnchor(TreeView<?> treeView, int n) {
        if (treeView != null && n < 0) {
            TreeCellBehavior.removeAnchor(treeView);
        } else {
            treeView.getProperties().put(ANCHOR_PROPERTY_KEY, n);
        }
    }

    static boolean hasAnchor(TreeView<?> treeView) {
        return treeView.getProperties().get(ANCHOR_PROPERTY_KEY) != null;
    }

    static void removeAnchor(TreeView<?> treeView) {
        treeView.getProperties().remove(ANCHOR_PROPERTY_KEY);
    }

    public TreeCellBehavior(TreeCell<T> treeCell) {
        super(treeCell, (List<KeyBinding>)Collections.EMPTY_LIST);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = ((TreeCell)this.getControl()).isSelected();
        if (((TreeCell)this.getControl()).isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (IS_TOUCH_SUPPORTED && bl) {
            this.wasSelected = ((TreeCell)this.getControl()).isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.latePress = false;
        TreeView treeView = ((TreeCell)this.getControl()).getTreeView();
        if (treeView == null || treeView.getSelectionModel() == null) {
            return;
        }
        if (IS_TOUCH_SUPPORTED && !this.wasSelected && ((TreeCell)this.getControl()).isSelected()) {
            treeView.getSelectionModel().clearSelection(((TreeCell)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        MouseButton mouseButton;
        TreeCell treeCell = (TreeCell)this.getControl();
        TreeView treeView = treeCell.getTreeView();
        if (treeView == null) {
            return;
        }
        if (treeCell.isEmpty() || !treeCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            PlatformLogger platformLogger = Logging.getControlsLogger();
            if (!treeCell.isEmpty() || platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                // empty if block
            }
            return;
        }
        int n = treeCell.getIndex();
        boolean bl = treeCell.isSelected();
        MultipleSelectionModel multipleSelectionModel = treeView.getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = treeView.getFocusModel();
        if (focusModel == null) {
            return;
        }
        Node node = treeCell.getDisclosureNode();
        if (node != null && node.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (treeCell.getTreeItem() != null) {
                treeCell.getTreeItem().setExpanded(!treeCell.getTreeItem().isExpanded());
            }
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!TreeCellBehavior.hasAnchor(treeView)) {
                TreeCellBehavior.setAnchor(treeView, focusModel.getFocusedIndex());
            }
        } else {
            TreeCellBehavior.removeAnchor(treeView);
        }
        if ((mouseButton = mouseEvent.getButton()) == MouseButton.PRIMARY || mouseButton == MouseButton.SECONDARY && !bl) {
            if (multipleSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(mouseEvent);
            } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
                if (bl) {
                    multipleSelectionModel.clearSelection(n);
                    focusModel.focus(n);
                } else {
                    multipleSelectionModel.select(n);
                }
            } else if (mouseEvent.isShiftDown() && mouseEvent.getClickCount() == 1) {
                int n2 = TreeCellBehavior.getAnchor(treeView);
                boolean bl2 = n2 < n;
                int n3 = Math.min(n2, n);
                int n4 = Math.max(n2, n);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(multipleSelectionModel.getSelectedIndices());
                int n5 = arrayList.size();
                for (int i = 0; i < n5; ++i) {
                    int n6 = (Integer)arrayList.get(i);
                    if (n6 >= n3 && n6 <= n4) continue;
                    multipleSelectionModel.clearSelection(n6);
                }
                if (bl2) {
                    multipleSelectionModel.selectRange(n3, n4 + 1);
                } else {
                    multipleSelectionModel.selectRange(n4, n3 - 1);
                }
                focusModel.focus(n);
            } else {
                this.simpleSelect(mouseEvent);
            }
        }
    }

    private void simpleSelect(MouseEvent mouseEvent) {
        TreeView treeView = ((TreeCell)this.getControl()).getTreeView();
        TreeItem treeItem = ((TreeCell)this.getControl()).getTreeItem();
        int n = ((TreeCell)this.getControl()).getIndex();
        MultipleSelectionModel multipleSelectionModel = treeView.getSelectionModel();
        boolean bl = multipleSelectionModel.isSelected(n);
        if (bl && (mouseEvent.isControlDown() || mouseEvent.isMetaDown())) {
            multipleSelectionModel.clearSelection(n);
            bl = false;
        } else {
            multipleSelectionModel.clearAndSelect(n);
        }
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getClickCount() == 1 && bl) {
                treeView.edit(treeItem);
            } else if (mouseEvent.getClickCount() == 1) {
                treeView.edit(null);
            } else if (mouseEvent.getClickCount() == 2 && treeItem.isLeaf()) {
                treeView.edit(treeItem);
            } else if (mouseEvent.getClickCount() % 2 == 0) {
                treeItem.setExpanded(!treeItem.isExpanded());
            }
        }
    }
}

