/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TableCellBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class TableRowBehavior<T>
extends CellBehaviorBase<TableRow<T>> {
    private boolean latePress = false;
    private boolean wasSelected = false;

    public TableRowBehavior(TableRow<T> tableRow) {
        super(tableRow, (List<KeyBinding>)Collections.EMPTY_LIST);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isClickOutsideCellBounds(mouseEvent.getX())) {
            return;
        }
        boolean bl = ((TableRow)this.getControl()).isSelected();
        if (((TableRow)this.getControl()).isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (IS_TOUCH_SUPPORTED && bl) {
            this.wasSelected = ((TableRow)this.getControl()).isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isClickOutsideCellBounds(mouseEvent.getX())) {
            return;
        }
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isClickOutsideCellBounds(mouseEvent.getX())) {
            return;
        }
        this.latePress = false;
        if (IS_TOUCH_SUPPORTED && !this.wasSelected && ((TableRow)this.getControl()).isSelected()) {
            ((TableRow)this.getControl()).getTableView().getSelectionModel().clearSelection(((TableRow)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.getButton() != MouseButton.PRIMARY) {
            return;
        }
        TableRow tableRow = (TableRow)this.getControl();
        TableView tableView = tableRow.getTableView();
        if (tableView == null) {
            return;
        }
        TableView.TableViewSelectionModel tableViewSelectionModel = tableView.getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        int n = ((TableRow)this.getControl()).getIndex();
        boolean bl = tableViewSelectionModel.isSelected(n);
        int n2 = mouseEvent.getClickCount();
        if (n2 == 1) {
            if (!this.isClickOutsideCellBounds(mouseEvent.getX())) {
                return;
            }
            if (bl && mouseEvent.isShortcutDown()) {
                tableViewSelectionModel.clearSelection(n);
            } else if (mouseEvent.isShortcutDown()) {
                tableViewSelectionModel.select(tableRow.getIndex());
            } else if (mouseEvent.isShiftDown()) {
                TablePositionBase tablePositionBase = TableCellBehavior.getAnchor(tableView, tableView.getFocusModel().getFocusedCell());
                int n3 = tablePositionBase.getRow();
                boolean bl2 = n3 < n;
                int n4 = Math.min(n3, n);
                int n5 = Math.max(n3, n);
                ArrayList arrayList = new ArrayList(tableViewSelectionModel.getSelectedIndices());
                int n6 = arrayList.size();
                for (int i = 0; i < n6; ++i) {
                    int n7 = (Integer)arrayList.get(i);
                    if (n7 >= n4 && n7 <= n5) continue;
                    tableViewSelectionModel.clearSelection(n7);
                }
                if (n4 == n5) {
                    tableViewSelectionModel.select(n4);
                } else if (bl2) {
                    tableViewSelectionModel.selectRange(n4, n5 + 1);
                } else {
                    tableViewSelectionModel.selectRange(n5, n4 - 1);
                }
            } else {
                tableViewSelectionModel.clearAndSelect(tableRow.getIndex());
            }
        }
    }

    private boolean isClickOutsideCellBounds(double d) {
        TableRow tableRow = (TableRow)this.getControl();
        TableView tableView = tableRow.getTableView();
        if (tableView == null) {
            return false;
        }
        ObservableList observableList = tableView.getVisibleLeafColumns();
        double d2 = 0.0;
        for (int i = 0; i < observableList.size(); ++i) {
            d2 += ((TableColumn)observableList.get(i)).getWidth();
        }
        return d > d2;
    }
}

