/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.TabPaneSkin;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class TabPaneBehavior
extends BehaviorBase<TabPane> {
    private static final String HOME = "Home";
    private static final String END = "End";
    private static final String CTRL_PAGE_UP = "Ctrl_Page_Up";
    private static final String CTRL_PAGE_DOWN = "Ctrl_Page_Down";
    private static final String CTRL_TAB = "Ctrl_Tab";
    private static final String CTRL_SHIFT_TAB = "Ctrl_Shift_Tab";
    protected static final List<KeyBinding> TAB_PANE_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected void callAction(String string) {
        if ("TraverseLeft".equals(string) || "TraverseUp".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectPreviousTab();
            }
        } else if ("TraverseRight".equals(string) || "TraverseDown".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectNextTab();
            }
        } else if ("TraverseNext".equals(string)) {
            TabPaneSkin tabPaneSkin = (TabPaneSkin)((TabPane)this.getControl()).getSkin();
            StackPane stackPane = tabPaneSkin.getSelectedTabContentRegion();
            if (stackPane != null) {
                TraversalEngine traversalEngine = stackPane.getImpl_traversalEngine();
                if (traversalEngine.registeredNodes.isEmpty()) {
                    traversalEngine.getTopLeftFocusableNode();
                    Parent parent = TabPaneBehavior.getFirstPopulatedInnerTraversalEngine(stackPane.getChildren());
                    if (parent != null) {
                        boolean bl = false;
                        for (Node node : parent.getImpl_traversalEngine().registeredNodes) {
                            if (node.isFocused() || !node.impl_isTreeVisible() || node.isDisabled()) continue;
                            node.requestFocus();
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            super.callAction(string);
                        }
                    } else {
                        super.callAction(string);
                    }
                } else {
                    ObservableList<Node> observableList = stackPane.getChildrenUnmodifiable();
                    Node node = stackPane.getScene().getFocusOwner();
                    if (node != null && TabPaneBehavior.isChildFocused(node, observableList)) {
                        node.impl_traverse(Direction.NEXT);
                    } else {
                        TabPaneBehavior.focusFirstChild(observableList);
                    }
                }
            } else {
                super.callAction(string);
            }
        } else if ("TraversePrevious".equals(string)) {
            TabPaneSkin tabPaneSkin = (TabPaneSkin)((TabPane)this.getControl()).getSkin();
            StackPane stackPane = tabPaneSkin.getSelectedTabContentRegion();
            if (stackPane != null) {
                TraversalEngine traversalEngine = stackPane.getImpl_traversalEngine();
                if (traversalEngine.registeredNodes.isEmpty()) {
                    traversalEngine.getTopLeftFocusableNode();
                    Parent parent = TabPaneBehavior.getFirstPopulatedInnerTraversalEngine(stackPane.getChildren());
                    if (parent != null) {
                        boolean bl = false;
                        for (Node node : parent.getImpl_traversalEngine().registeredNodes) {
                            if (node.isFocused() || !node.impl_isTreeVisible() || node.isDisabled()) continue;
                            node.requestFocus();
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            super.callAction(string);
                        }
                    } else {
                        super.callAction(string);
                    }
                } else {
                    ObservableList<Node> observableList = stackPane.getChildrenUnmodifiable();
                    Node node = stackPane.getScene().getFocusOwner();
                    if (node != null && TabPaneBehavior.isChildFocused(node, observableList)) {
                        node.impl_traverse(Direction.PREVIOUS);
                    } else {
                        TabPaneBehavior.focusLastChild(observableList);
                    }
                }
            } else {
                super.callAction(string);
            }
        } else if (CTRL_TAB.equals(string) || CTRL_PAGE_DOWN.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == tabPane.getTabs().size() - 1) {
                tabPane.getSelectionModel().selectFirst();
            } else {
                this.selectNextTab();
            }
            tabPane.requestFocus();
        } else if (CTRL_SHIFT_TAB.equals(string) || CTRL_PAGE_UP.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == 0) {
                tabPane.getSelectionModel().selectLast();
            } else {
                this.selectPreviousTab();
            }
            tabPane.requestFocus();
        } else if (HOME.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectFirst();
            }
        } else if (END.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectLast();
            }
        } else {
            super.callAction(string);
        }
    }

    public static boolean isChildFocused(Node node, List<Node> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == node) {
                bl = true;
                break;
            }
            if (!(list.get(i) instanceof Parent) || !TabPaneBehavior.isChildFocused(node, ((Parent)list.get(i)).getChildrenUnmodifiable())) continue;
            return true;
        }
        return bl;
    }

    public static boolean focusFirstChild(List<Node> list) {
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            if (node.isFocusTraversable() && node.impl_isTreeVisible() && !node.isDisabled()) {
                node.requestFocus();
                return true;
            }
            if (!(node instanceof Parent) || !TabPaneBehavior.focusFirstChild(((Parent)node).getChildrenUnmodifiable())) continue;
            return true;
        }
        return false;
    }

    public static boolean focusLastChild(List<Node> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            Node node = list.get(i);
            if (node.isFocusTraversable() && node.impl_isTreeVisible() && !node.isDisabled()) {
                node.requestFocus();
                return true;
            }
            if (!(node instanceof Parent) || !TabPaneBehavior.focusFirstChild(((Parent)node).getChildrenUnmodifiable())) continue;
            return true;
        }
        return false;
    }

    public static Parent getFirstPopulatedInnerTraversalEngine(ObservableList<Node> observableList) {
        Parent parent = null;
        for (Node node : observableList) {
            if (!(node instanceof Parent)) continue;
            if (((Parent)node).getImpl_traversalEngine() != null && !((Parent)node).getImpl_traversalEngine().registeredNodes.isEmpty()) {
                parent = (Parent)node;
                break;
            }
            parent = TabPaneBehavior.getFirstPopulatedInnerTraversalEngine(((Parent)node).getChildrenUnmodifiable());
            if (parent == null) continue;
            break;
        }
        return parent;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        TabPane tabPane = (TabPane)this.getControl();
        tabPane.requestFocus();
    }

    public TabPaneBehavior(TabPane tabPane) {
        super(tabPane, TAB_PANE_BINDINGS);
    }

    public void selectTab(Tab tab) {
        ((TabPane)this.getControl()).getSelectionModel().select(tab);
    }

    public boolean canCloseTab(Tab tab) {
        Event event = new Event(tab, tab, Tab.TAB_CLOSE_REQUEST_EVENT);
        Event.fireEvent(tab, event);
        return !event.isConsumed();
    }

    public void closeTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getControl();
        int n = tabPane.getTabs().indexOf(tab);
        if (tab.isSelected()) {
            if (n == 0) {
                if (tabPane.getTabs().size() > 0) {
                    tabPane.getSelectionModel().selectFirst();
                }
            } else {
                tabPane.getSelectionModel().selectPrevious();
            }
        }
        if (n != -1) {
            tabPane.getTabs().remove(n);
        }
        if (tab.getOnClosed() != null) {
            Event.fireEvent(tab, new Event(Tab.CLOSED_EVENT));
        }
    }

    public void selectNextTab() {
        int n;
        SingleSelectionModel<Tab> singleSelectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int i = n = singleSelectionModel.getSelectedIndex(); i < ((TabPane)this.getControl()).getTabs().size(); ++i) {
            singleSelectionModel.selectNext();
            if (((Tab)singleSelectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        singleSelectionModel.select(n);
    }

    public void selectPreviousTab() {
        int n;
        SingleSelectionModel<Tab> singleSelectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int i = n = singleSelectionModel.getSelectedIndex(); i > 0; --i) {
            singleSelectionModel.selectPrevious();
            if (((Tab)singleSelectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        singleSelectionModel.select(n);
    }

    static {
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.HOME, HOME));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.END, END));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, CTRL_PAGE_UP).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, CTRL_PAGE_DOWN).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_TAB).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_SHIFT_TAB).shift().ctrl());
    }
}

