/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import sun.util.logging.PlatformLogger;

public class ListCellBehavior<T>
extends CellBehaviorBase<ListCell<T>> {
    private static final String ANCHOR_PROPERTY_KEY = "list.anchor";
    private boolean latePress = false;
    private boolean wasSelected = false;

    static int getAnchor(ListView<?> listView) {
        FocusModel<?> focusModel = listView.getFocusModel();
        if (focusModel == null) {
            return -1;
        }
        return ListCellBehavior.hasAnchor(listView) ? ((Integer)listView.getProperties().get(ANCHOR_PROPERTY_KEY)).intValue() : focusModel.getFocusedIndex();
    }

    static void setAnchor(ListView<?> listView, int n) {
        if (listView != null && n < 0) {
            ListCellBehavior.removeAnchor(listView);
        } else {
            listView.getProperties().put(ANCHOR_PROPERTY_KEY, n);
        }
    }

    static boolean hasAnchor(ListView<?> listView) {
        return listView.getProperties().get(ANCHOR_PROPERTY_KEY) != null;
    }

    static void removeAnchor(ListView<?> listView) {
        listView.getProperties().remove(ANCHOR_PROPERTY_KEY);
    }

    public ListCellBehavior(ListCell<T> listCell) {
        super(listCell, (List<KeyBinding>)Collections.EMPTY_LIST);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = ((ListCell)this.getControl()).isSelected();
        if (((ListCell)this.getControl()).isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (IS_TOUCH_SUPPORTED && bl) {
            this.wasSelected = ((ListCell)this.getControl()).isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.latePress = false;
        if (IS_TOUCH_SUPPORTED && !this.wasSelected && ((ListCell)this.getControl()).isSelected()) {
            ((ListCell)this.getControl()).getListView().getSelectionModel().clearSelection(((ListCell)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        MouseButton mouseButton;
        int n;
        ListCell listCell = (ListCell)this.getControl();
        ListView listView = ((ListCell)this.getControl()).getListView();
        if (listView == null) {
            return;
        }
        if (listCell.isEmpty() || !listCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            PlatformLogger platformLogger = Logging.getControlsLogger();
            if (!listCell.isEmpty() || platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                // empty if block
            }
            return;
        }
        int n2 = n = listView.getItems() == null ? 0 : listView.getItems().size();
        if (listCell.getIndex() >= n) {
            return;
        }
        int n3 = listCell.getIndex();
        boolean bl = listCell.isSelected();
        MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = listView.getFocusModel();
        if (focusModel == null) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!ListCellBehavior.hasAnchor(listView)) {
                ListCellBehavior.setAnchor(listView, focusModel.getFocusedIndex());
            }
        } else {
            ListCellBehavior.removeAnchor(listView);
        }
        if ((mouseButton = mouseEvent.getButton()) == MouseButton.PRIMARY || mouseButton == MouseButton.SECONDARY && !bl) {
            if (multipleSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(mouseEvent);
            } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
                if (bl) {
                    multipleSelectionModel.clearSelection(n3);
                    focusModel.focus(n3);
                } else {
                    multipleSelectionModel.select(n3);
                }
            } else if (mouseEvent.isShiftDown()) {
                int n4 = ListCellBehavior.getAnchor(listView);
                boolean bl2 = n4 < n3;
                int n5 = Math.min(n4, n3);
                int n6 = Math.max(n4, n3);
                ArrayList<Integer> arrayList = new ArrayList<Integer>(multipleSelectionModel.getSelectedIndices());
                int n7 = arrayList.size();
                for (int i = 0; i < n7; ++i) {
                    int n8 = (Integer)arrayList.get(i);
                    if (n8 >= n5 && n8 <= n6) continue;
                    multipleSelectionModel.clearSelection(n8);
                }
                if (bl2) {
                    multipleSelectionModel.selectRange(n5, n6 + 1);
                } else {
                    multipleSelectionModel.selectRange(n6, n5 - 1);
                }
                focusModel.focus(n3);
            } else {
                this.simpleSelect(mouseEvent);
            }
        }
    }

    private void simpleSelect(MouseEvent mouseEvent) {
        ListView listView = ((ListCell)this.getControl()).getListView();
        int n = ((ListCell)this.getControl()).getIndex();
        MultipleSelectionModel multipleSelectionModel = listView.getSelectionModel();
        boolean bl = multipleSelectionModel.isSelected(n);
        listView.getSelectionModel().clearAndSelect(n);
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getClickCount() == 1 && bl) {
                listView.edit(n);
            } else if (mouseEvent.getClickCount() == 1) {
                listView.edit(-1);
            } else if (mouseEvent.getClickCount() == 2 && ((ListCell)this.getControl()).isEditable()) {
                listView.edit(n);
            }
        }
    }
}

