/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.accessible;

import com.sun.javafx.accessible.providers.RangeValueProvider;
import com.sun.javafx.scene.control.accessible.AccessibleControl;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Slider;

public class AccessibleSlider
extends AccessibleControl
implements RangeValueProvider {
    Slider slider;

    public AccessibleSlider(Slider slider) {
        super(slider);
        this.slider = slider;
        slider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                AccessibleSlider.this.firePropertyChange(20004, number.intValue(), number2.intValue());
            }
        });
    }

    @Override
    public double getValue() {
        return this.slider.getValue();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public double getLargeValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getMinimum() {
        return this.slider.getMin();
    }

    @Override
    public double getMaximum() {
        return this.slider.getMax();
    }

    @Override
    public double getSmallChange() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getPropertyValue(int n) {
        Object object = null;
        switch (n) {
            case 30005: 
            case 30105: {
                object = new Double(this.slider.getValue()).toString();
                break;
            }
            case 30003: {
                object = 50015;
                break;
            }
            case 30009: {
                object = this.slider.isFocusTraversable();
                break;
            }
            case 30008: {
                object = this.slider.isFocused();
                break;
            }
            case 30016: {
                object = true;
                break;
            }
            case 30010: {
                object = !this.slider.isDisabled();
                break;
            }
            case 30012: {
                object = this.getClass().toString();
            }
        }
        return object;
    }

    @Override
    public Object getPatternProvider(int n) {
        return super.getAccessibleElement();
    }
}

