/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.GuardedTypeConversion;
import jdk.internal.dynalink.linker.GuardingTypeConverterFactory;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.linker.LinkerServices;
import jdk.internal.dynalink.linker.TypeBasedGuardingDynamicLinker;
import jdk.internal.dynalink.support.CallSiteDescriptorFactory;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.internal.lookup.MethodHandleFactory;
import jdk.nashorn.internal.lookup.MethodHandleFunctionality;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.linker.Bootstrap;

final class JSObjectLinker
implements TypeBasedGuardingDynamicLinker,
GuardingTypeConverterFactory {
    private static final MethodHandleFunctionality MH = MethodHandleFactory.getFunctionality();
    private static final MethodHandle IS_JSOBJECT_GUARD = JSObjectLinker.findOwnMH("isJSObject", Boolean.TYPE, Object.class);
    private static final MethodHandle JSOBJECTLINKER_GET = JSObjectLinker.findOwnMH("get", Object.class, Object.class, Object.class);
    private static final MethodHandle JSOBJECTLINKER_PUT = JSObjectLinker.findOwnMH("put", Void.TYPE, Object.class, Object.class, Object.class);
    private static final MethodHandle JSOBJECT_GETMEMBER = JSObjectLinker.findJSObjectMH("getMember", Object.class, String.class);
    private static final MethodHandle JSOBJECT_SETMEMBER = JSObjectLinker.findJSObjectMH("setMember", Void.TYPE, String.class, Object.class);
    private static final MethodHandle JSOBJECT_CALL = JSObjectLinker.findJSObjectMH("call", Object.class, Object.class, Object[].class);
    private static final MethodHandle JSOBJECT_NEW = JSObjectLinker.findJSObjectMH("newObject", Object.class, Object[].class);
    private static final Map<Class<?>, MethodHandle> CONVERTERS = new HashMap();

    JSObjectLinker() {
    }

    @Override
    public boolean canLinkType(Class<?> type) {
        return JSObjectLinker.canLinkTypeStatic(type);
    }

    static boolean canLinkTypeStatic(Class<?> type) {
        return JSObject.class.isAssignableFrom(type);
    }

    @Override
    public GuardedInvocation getGuardedInvocation(LinkRequest request, LinkerServices linkerServices) throws Exception {
        LinkRequest requestWithoutContext = request.withoutRuntimeContext();
        Object self = requestWithoutContext.getReceiver();
        CallSiteDescriptor desc = requestWithoutContext.getCallSiteDescriptor();
        if (desc.getNameTokenCount() < 2 || !"dyn".equals(desc.getNameToken(0))) {
            return null;
        }
        if (!(self instanceof JSObject)) {
            throw new AssertionError();
        }
        GuardedInvocation inv = JSObjectLinker.lookup(desc);
        return Bootstrap.asType(inv, linkerServices, desc);
    }

    @Override
    public GuardedTypeConversion convertToType(Class<?> sourceType, Class<?> targetType) throws Exception {
        boolean sourceIsAlwaysJSObject = JSObject.class.isAssignableFrom(sourceType);
        if (!sourceIsAlwaysJSObject && !sourceType.isAssignableFrom(JSObject.class)) {
            return null;
        }
        MethodHandle converter = CONVERTERS.get(targetType);
        if (converter == null) {
            return null;
        }
        return new GuardedTypeConversion(new GuardedInvocation(converter, sourceIsAlwaysJSObject ? null : IS_JSOBJECT_GUARD).asType(MethodType.methodType(targetType, sourceType)), true);
    }

    private static GuardedInvocation lookup(CallSiteDescriptor desc) {
        String operator = CallSiteDescriptorFactory.tokenizeOperators(desc).get(0);
        int c = desc.getNameTokenCount();
        switch (operator) {
            case "getProp": 
            case "getElem": 
            case "getMethod": {
                return c > 2 ? JSObjectLinker.findGetMethod(desc) : JSObjectLinker.findGetIndexMethod();
            }
            case "setProp": 
            case "setElem": {
                return c > 2 ? JSObjectLinker.findSetMethod(desc) : JSObjectLinker.findSetIndexMethod();
            }
            case "call": {
                return JSObjectLinker.findCallMethod(desc);
            }
            case "new": {
                return JSObjectLinker.findNewMethod(desc);
            }
        }
        return null;
    }

    private static GuardedInvocation findGetMethod(CallSiteDescriptor desc) {
        MethodHandle getter = MH.insertArguments(JSOBJECT_GETMEMBER, 1, desc.getNameToken(2));
        return new GuardedInvocation(getter, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findGetIndexMethod() {
        return new GuardedInvocation(JSOBJECTLINKER_GET, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findSetMethod(CallSiteDescriptor desc) {
        MethodHandle getter = MH.insertArguments(JSOBJECT_SETMEMBER, 1, desc.getNameToken(2));
        return new GuardedInvocation(getter, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findSetIndexMethod() {
        return new GuardedInvocation(JSOBJECTLINKER_PUT, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findCallMethod(CallSiteDescriptor desc) {
        MethodHandle func = MH.asCollector(JSOBJECT_CALL, Object[].class, desc.getMethodType().parameterCount() - 2);
        return new GuardedInvocation(func, null, IS_JSOBJECT_GUARD);
    }

    private static GuardedInvocation findNewMethod(CallSiteDescriptor desc) {
        MethodHandle func = MH.asCollector(JSOBJECT_NEW, Object[].class, desc.getMethodType().parameterCount() - 1);
        return new GuardedInvocation(func, null, IS_JSOBJECT_GUARD);
    }

    private static boolean isJSObject(Object self) {
        return self instanceof JSObject;
    }

    private static Object get(Object jsobj, Object key) {
        if (key instanceof Integer) {
            return ((JSObject)jsobj).getSlot((Integer)key);
        }
        if (key instanceof Number) {
            int index = JSObjectLinker.getIndex((Number)key);
            if (index > -1) {
                return ((JSObject)jsobj).getSlot(index);
            }
        } else if (key instanceof String) {
            return ((JSObject)jsobj).getMember((String)key);
        }
        return null;
    }

    private static void put(Object jsobj, Object key, Object value) {
        if (key instanceof Integer) {
            ((JSObject)jsobj).setSlot((Integer)key, value);
        } else if (key instanceof Number) {
            ((JSObject)jsobj).setSlot(JSObjectLinker.getIndex((Number)key), value);
        } else if (key instanceof String) {
            ((JSObject)jsobj).setMember((String)key, value);
        }
    }

    private static int toInt32(JSObject obj) {
        return JSType.toInt32(JSObjectLinker.toNumber(obj));
    }

    private static long toInt64(JSObject obj) {
        return JSType.toInt64(JSObjectLinker.toNumber(obj));
    }

    private static double toNumber(JSObject obj) {
        return obj == null ? 0.0 : obj.toNumber();
    }

    private static boolean toBoolean(JSObject obj) {
        return obj != null;
    }

    private static int getIndex(Number n) {
        double value = n.doubleValue();
        return JSType.isRepresentableAsInt(value) ? (int)value : -1;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return JSObjectLinker.findMH(name, JSObjectLinker.class, rtype, types);
    }

    private static MethodHandle findJSObjectMH(String name, Class<?> rtype, Class<?> ... types) {
        return JSObjectLinker.findMH(name, JSObject.class, rtype, types);
    }

    private static MethodHandle findMH(String name, Class<?> target, Class<?> rtype, Class<?> ... types) {
        MethodType mt = MH.type(rtype, types);
        try {
            return MH.findStatic(MethodHandles.lookup(), target, name, mt);
        }
        catch (MethodHandleFactory.LookupException e) {
            return MH.findVirtual(MethodHandles.lookup(), target, name, mt);
        }
    }

    static {
        CONVERTERS.put(Boolean.TYPE, JSObjectLinker.findOwnMH("toBoolean", Boolean.TYPE, JSObject.class));
        CONVERTERS.put(Integer.TYPE, JSObjectLinker.findOwnMH("toInt32", Integer.TYPE, JSObject.class));
        CONVERTERS.put(Long.TYPE, JSObjectLinker.findOwnMH("toInt64", Long.TYPE, JSObject.class));
        CONVERTERS.put(Double.TYPE, JSObjectLinker.findOwnMH("toNumber", Double.TYPE, JSObject.class));
    }
}

