/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.lang.reflect.Array;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.arrays.DeletedRangeArrayFilter;
import jdk.nashorn.internal.runtime.arrays.IntArrayData;
import jdk.nashorn.internal.runtime.arrays.LongArrayData;
import jdk.nashorn.internal.runtime.arrays.NumberArrayData;
import jdk.nashorn.internal.runtime.arrays.ObjectArrayData;
import jdk.nashorn.internal.runtime.arrays.SparseArrayData;

final class NoTypeArrayData
extends ArrayData {
    NoTypeArrayData() {
        super(0L);
    }

    NoTypeArrayData(long length) {
        super(length);
    }

    @Override
    public Object[] asObjectArray() {
        return new Object[0];
    }

    @Override
    public ArrayData copy() {
        return new NoTypeArrayData();
    }

    @Override
    public Object asArrayOfType(Class<?> componentType) {
        return Array.newInstance(componentType, 0);
    }

    @Override
    public ArrayData convert(Class<?> type) {
        ArrayData arrayData;
        long length = this.length();
        if (type == Long.class) {
            arrayData = new LongArrayData(new long[ArrayData.nextSize((int)length)], (int)length);
        } else if (type == Double.class) {
            arrayData = new NumberArrayData(new double[ArrayData.nextSize((int)length)], (int)length);
        } else if (type == Integer.class) {
            arrayData = new IntArrayData(new int[ArrayData.nextSize((int)length)], (int)length);
        } else {
            assert (!type.isPrimitive());
            arrayData = new ObjectArrayData(new Object[ArrayData.nextSize((int)length)], (int)length);
        }
        return length == 0L ? arrayData : new DeletedRangeArrayFilter(arrayData, 0L, length - 1L);
    }

    @Override
    public void shiftLeft(int by) {
    }

    @Override
    public ArrayData shiftRight(int by) {
        return this;
    }

    @Override
    public ArrayData ensure(long safeIndex) {
        if (safeIndex >= 524288L) {
            return new SparseArrayData(this, safeIndex + 1L);
        }
        if (this.length() == 0L) {
            return new NoTypeArrayData(Math.max(safeIndex + 1L, this.length()));
        }
        this.setLength(Math.max(safeIndex + 1L, this.length()));
        return this;
    }

    @Override
    public ArrayData shrink(long newLength) {
        return this;
    }

    @Override
    public ArrayData set(int index, Object value, boolean strict) {
        ArrayData newData;
        if (value instanceof Double) {
            newData = this.convert(Double.class);
        } else if (value instanceof Long) {
            newData = this.convert(Long.class);
        } else if (value instanceof Integer) {
            newData = this.convert(Integer.class);
        } else {
            assert (!(value instanceof Number));
            newData = this.convert(value == null ? Object.class : value.getClass());
        }
        return newData.set(index, value, strict);
    }

    @Override
    public ArrayData set(int index, int value, boolean strict) {
        ArrayData newData = this.convert(Integer.class);
        return newData.set(index, value, strict);
    }

    @Override
    public ArrayData set(int index, long value, boolean strict) {
        ArrayData newData = this.convert(Long.class);
        return newData.set(index, value, strict);
    }

    @Override
    public ArrayData set(int index, double value, boolean strict) {
        ArrayData newData = this.convert(Double.class);
        return newData.set(index, value, strict);
    }

    @Override
    public int getInt(int index) {
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public long getLong(int index) {
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public double getDouble(int index) {
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public Object getObject(int index) {
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public boolean has(int index) {
        return false;
    }

    @Override
    public ArrayData delete(int index) {
        return new DeletedRangeArrayFilter(this, index, index);
    }

    @Override
    public ArrayData delete(long fromIndex, long toIndex) {
        return new DeletedRangeArrayFilter(this, fromIndex, toIndex);
    }

    @Override
    public Object pop() {
        return ScriptRuntime.UNDEFINED;
    }

    @Override
    public ArrayData slice(long from, long to) {
        return this;
    }
}

