/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.util.Collections;
import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

public final class NativeUint16Array
extends ArrayBufferView {
    public static final int BYTES_PER_ELEMENT = 2;
    private static PropertyMap $nasgenmap$;
    private static final ArrayBufferView.Factory FACTORY;

    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeUint16Array.constructorImpl(args, FACTORY);
    }

    NativeUint16Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    public String getClassName() {
        return "Uint16Array";
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype(Global global) {
        return global.getUint16ArrayPrototype();
    }

    static {
        FACTORY = new ArrayBufferView.Factory(2){

            @Override
            public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new NativeUint16Array(buffer, byteOffset, length);
            }

            @Override
            public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
                return new Uint16ArrayData(buffer, byteOffset, length);
            }
        };
        NativeUint16Array.$clinit$();
    }

    public static void $clinit$() {
        $nasgenmap$ = PropertyMap.newMap(Collections.EMPTY_LIST).setIsShared();
    }

    private static final class Uint16ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Uint16ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 2 + this.byteOffset;
        }

        @Override
        protected int getIntImpl(int index) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            return byteArray[byteIndex] & 0xFF | byteArray[byteIndex + 1] << 8 & 0xFF00;
        }

        @Override
        protected void setImpl(int index, int value) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            byteArray[byteIndex] = (byte)(value & 0xFF);
            byteArray[byteIndex + 1] = (byte)(value >>> 8 & 0xFF);
        }
    }
}

