/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class TernaryNode
extends Expression {
    private final Expression test;
    private final Expression trueExpr;
    private final Expression falseExpr;

    public TernaryNode(long token, Expression test, Expression trueExpr, Expression falseExpr) {
        super(token, falseExpr.getFinish());
        this.test = test;
        this.trueExpr = trueExpr;
        this.falseExpr = falseExpr;
    }

    private TernaryNode(TernaryNode ternaryNode, Expression test, Expression trueExpr, Expression falseExpr) {
        super(ternaryNode);
        this.test = test;
        this.trueExpr = trueExpr;
        this.falseExpr = falseExpr;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterTernaryNode(this)) {
            Expression newTest = (Expression)this.getTest().accept(visitor);
            Expression newTrueExpr = (Expression)this.getTrueExpression().accept(visitor);
            Expression newFalseExpr = (Expression)this.falseExpr.accept(visitor);
            return visitor.leaveTernaryNode(this.setTest(newTest).setTrueExpression(newTrueExpr).setFalseExpression1(newFalseExpr));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        boolean testParen = this.tokenType().needsParens(this.getTest().tokenType(), true);
        boolean trueParen = this.tokenType().needsParens(this.getTrueExpression().tokenType(), false);
        boolean falseParen = this.tokenType().needsParens(this.getFalseExpression().tokenType(), false);
        if (testParen) {
            sb.append('(');
        }
        this.getTest().toString(sb);
        if (testParen) {
            sb.append(')');
        }
        sb.append(" ? ");
        if (trueParen) {
            sb.append('(');
        }
        this.getTrueExpression().toString(sb);
        if (trueParen) {
            sb.append(')');
        }
        sb.append(" : ");
        if (falseParen) {
            sb.append('(');
        }
        this.getFalseExpression().toString(sb);
        if (falseParen) {
            sb.append(')');
        }
    }

    @Override
    public boolean isLocal() {
        return this.getTest().isLocal() && this.getTrueExpression().isLocal() && this.getFalseExpression().isLocal();
    }

    public Expression getTest() {
        return this.test;
    }

    public Expression getTrueExpression() {
        return this.trueExpr;
    }

    public Expression getFalseExpression() {
        return this.falseExpr;
    }

    public TernaryNode setTest(Expression test) {
        if (this.test == test) {
            return this;
        }
        return new TernaryNode(this, test, this.trueExpr, this.falseExpr);
    }

    public TernaryNode setTrueExpression(Expression trueExpr) {
        if (this.trueExpr == trueExpr) {
            return this;
        }
        return new TernaryNode(this, this.test, trueExpr, this.falseExpr);
    }

    public TernaryNode setFalseExpression1(Expression falseExpr) {
        if (this.falseExpr == falseExpr) {
            return this;
        }
        return new TernaryNode(this, this.test, this.trueExpr, falseExpr);
    }
}

