/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.ExpressionStatement;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.DebugLogger;

final class FinalizeTypes
extends NodeOperatorVisitor<LexicalContext> {
    private static final DebugLogger LOG = new DebugLogger("finalize");
    private final TemporarySymbols temporarySymbols;

    FinalizeTypes(TemporarySymbols temporarySymbols) {
        super(new LexicalContext());
        this.temporarySymbols = temporarySymbols;
    }

    @Override
    public Node leaveForNode(ForNode forNode) {
        if (forNode.isForIn()) {
            return forNode;
        }
        Expression init = forNode.getInit();
        Expression test = forNode.getTest();
        Expression modify = forNode.getModify();
        assert (test != null || forNode.hasGoto()) : "forNode " + forNode + " needs goto and is missing it in " + this.lc.getCurrentFunction();
        return forNode.setInit(this.lc, init == null ? null : FinalizeTypes.discard(init)).setModify(this.lc, modify == null ? null : FinalizeTypes.discard(modify));
    }

    @Override
    public Node leaveCOMMALEFT(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null);
        return binaryNode.setRHS(FinalizeTypes.discard(binaryNode.rhs()));
    }

    @Override
    public Node leaveCOMMARIGHT(BinaryNode binaryNode) {
        assert (binaryNode.getSymbol() != null);
        return binaryNode.setLHS(FinalizeTypes.discard(binaryNode.lhs()));
    }

    @Override
    public boolean enterBlock(Block block) {
        this.updateSymbols(block);
        return true;
    }

    @Override
    public Node leaveExpressionStatement(ExpressionStatement expressionStatement) {
        this.temporarySymbols.reuse();
        return expressionStatement.setExpression(FinalizeTypes.discard(expressionStatement.getExpression()));
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        if (functionNode.isLazy()) {
            return false;
        }
        if (!functionNode.needsCallee()) {
            functionNode.compilerConstant(CompilerConstants.CALLEE).setNeedsSlot(false);
        }
        if (!functionNode.hasScopeBlock() && !functionNode.needsParentScope()) {
            functionNode.compilerConstant(CompilerConstants.SCOPE).setNeedsSlot(false);
        }
        return true;
    }

    @Override
    public Node leaveFunctionNode(FunctionNode functionNode) {
        return functionNode.setState(this.lc, FunctionNode.CompilationState.FINALIZED);
    }

    private static void updateSymbolsLog(FunctionNode functionNode, Symbol symbol, boolean loseSlot) {
        if (LOG.isEnabled()) {
            if (!symbol.isScope()) {
                LOG.finest("updateSymbols: ", symbol, " => scope, because all vars in ", functionNode.getName(), " are in scope");
            }
            if (loseSlot && symbol.hasSlot()) {
                LOG.finest("updateSymbols: ", symbol, " => no slot, because all vars in ", functionNode.getName(), " are in scope");
            }
        }
    }

    private void updateSymbols(Block block) {
        if (!block.needsScope()) {
            return;
        }
        FunctionNode functionNode = this.lc.getFunction(block);
        boolean allVarsInScope = functionNode.allVarsInScope();
        boolean isVarArg = functionNode.isVarArg();
        for (Symbol symbol : block.getSymbols()) {
            if (symbol.isInternal() || symbol.isThis() || symbol.isTemp()) continue;
            if (symbol.isVar()) {
                if (allVarsInScope || symbol.isScope()) {
                    FinalizeTypes.updateSymbolsLog(functionNode, symbol, true);
                    Symbol.setSymbolIsScope(this.lc, symbol);
                    symbol.setNeedsSlot(false);
                    continue;
                }
                assert (symbol.hasSlot()) : symbol + " should have a slot only, no scope";
                continue;
            }
            if (!symbol.isParam() || !allVarsInScope && !isVarArg && !symbol.isScope()) continue;
            FinalizeTypes.updateSymbolsLog(functionNode, symbol, isVarArg);
            Symbol.setSymbolIsScope(this.lc, symbol);
            symbol.setNeedsSlot(!isVarArg);
        }
    }

    private static Expression discard(Expression node) {
        if (node.getSymbol() != null) {
            UnaryNode discard = new UnaryNode(Token.recast(node.getToken(), TokenType.DISCARD), node);
            assert (!node.isTerminal());
            return discard;
        }
        return node;
    }
}

