/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import jdk.nashorn.internal.codegen.Attr;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.CompilationException;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.FinalizeTypes;
import jdk.nashorn.internal.codegen.FoldConstants;
import jdk.nashorn.internal.codegen.Lower;
import jdk.nashorn.internal.codegen.RangeAnalyzer;
import jdk.nashorn.internal.codegen.Splitter;
import jdk.nashorn.internal.codegen.types.Range;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.debug.ASTWriter;
import jdk.nashorn.internal.ir.debug.PrintVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.Timing;

abstract class CompilationPhase
extends Enum<CompilationPhase> {
    public static final /* enum */ CompilationPhase LAZY_INITIALIZATION_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED)){

        @Override
        FunctionNode transform(final Compiler compiler, FunctionNode fn) {
            FunctionNode outermostFunctionNode = fn;
            final HashSet<FunctionNode> neverLazy = new HashSet<FunctionNode>();
            final HashSet lazy = new HashSet();
            FunctionNode newFunctionNode = outermostFunctionNode;
            newFunctionNode = (FunctionNode)newFunctionNode.accept(new NodeVisitor<LexicalContext>(new LexicalContext()){

                @Override
                public boolean enterCallNode(CallNode node) {
                    Expression callee = node.getFunction();
                    if (callee instanceof FunctionNode) {
                        neverLazy.add((FunctionNode)callee);
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean enterFunctionNode(FunctionNode node) {
                    assert (compiler.isLazy());
                    lazy.add(node);
                    return true;
                }
            });
            neverLazy.add(newFunctionNode);
            for (FunctionNode node : neverLazy) {
                Compiler.LOG.fine("Marking ", node.getName(), " as non lazy, as it's a self reference");
                lazy.remove(node);
            }
            newFunctionNode = (FunctionNode)newFunctionNode.accept(new NodeVisitor<LexicalContext>(new LexicalContext()){

                @Override
                public Node leaveFunctionNode(FunctionNode functionNode) {
                    if (lazy.contains(functionNode)) {
                        Compiler.LOG.fine("Marking ", functionNode.getName(), " as lazy");
                        FunctionNode parent = this.lc.getParentFunction(functionNode);
                        assert (parent != null);
                        this.lc.setFlag(parent, 2048);
                        this.lc.setBlockNeedsScope(parent.getBody());
                        this.lc.setFlag(functionNode, 1024);
                        return functionNode;
                    }
                    return functionNode.clearFlag(this.lc, 1024).setReturnType(this.lc, Type.UNKNOWN);
                }
            });
            return newFunctionNode;
        }

        public String toString() {
            return "[Lazy JIT Initialization]";
        }
    };
    public static final /* enum */ CompilationPhase CONSTANT_FOLDING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED)){

        @Override
        FunctionNode transform(Compiler compiler, FunctionNode fn) {
            return (FunctionNode)fn.accept((NodeVisitor)new FoldConstants());
        }

        public String toString() {
            return "[Constant Folding]";
        }
    };
    public static final /* enum */ CompilationPhase LOWERING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED)){

        @Override
        FunctionNode transform(Compiler compiler, FunctionNode fn) {
            return (FunctionNode)fn.accept((NodeVisitor)new Lower(compiler.getCodeInstaller()));
        }

        public String toString() {
            return "[Control Flow Lowering]";
        }
    };
    public static final /* enum */ CompilationPhase ATTRIBUTION_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED)){

        @Override
        FunctionNode transform(Compiler compiler, FunctionNode fn) {
            TemporarySymbols ts = compiler.getTemporarySymbols();
            FunctionNode newFunctionNode = (FunctionNode)this.enterAttr(fn, ts).accept((NodeVisitor)new Attr(ts));
            if (compiler.getEnv()._print_mem_usage) {
                Compiler.LOG.info("Attr temporary symbol count: " + ts.getTotalSymbolCount());
            }
            return newFunctionNode;
        }

        private FunctionNode enterAttr(FunctionNode functionNode, final TemporarySymbols ts) {
            return (FunctionNode)functionNode.accept(new NodeVisitor<LexicalContext>(new LexicalContext()){

                @Override
                public Node leaveFunctionNode(FunctionNode node) {
                    if (node.isLazy()) {
                        FunctionNode newNode = node.setReturnType(this.lc, Type.OBJECT);
                        return ts.ensureSymbol(this.lc, Type.OBJECT, newNode);
                    }
                    return node.setReturnType(this.lc, Type.UNKNOWN).setSymbol(this.lc, null);
                }
            });
        }

        public String toString() {
            return "[Type Attribution]";
        }
    };
    public static final /* enum */ CompilationPhase RANGE_ANALYSIS_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.ATTR)){

        @Override
        FunctionNode transform(final Compiler compiler, FunctionNode fn) {
            if (!compiler.getEnv()._range_analysis) {
                return fn;
            }
            FunctionNode newFunctionNode = (FunctionNode)fn.accept((NodeVisitor)new RangeAnalyzer());
            final ArrayList returns = new ArrayList();
            newFunctionNode = (FunctionNode)newFunctionNode.accept(new NodeVisitor<LexicalContext>(new LexicalContext()){
                private final Deque<ArrayList<ReturnNode>> returnStack;
                {
                    super(lc);
                    this.returnStack = new ArrayDeque<ArrayList<ReturnNode>>();
                }

                @Override
                public boolean enterFunctionNode(FunctionNode functionNode) {
                    this.returnStack.push(new ArrayList());
                    return true;
                }

                @Override
                public Node leaveFunctionNode(FunctionNode functionNode) {
                    Type returnType = Type.UNKNOWN;
                    for (ReturnNode ret : this.returnStack.pop()) {
                        if (ret.getExpression() == null) {
                            returnType = Type.OBJECT;
                            break;
                        }
                        returnType = Type.widest(returnType, ret.getExpression().getType());
                    }
                    return functionNode.setReturnType(this.lc, returnType);
                }

                @Override
                public Node leaveReturnNode(ReturnNode returnNode) {
                    ReturnNode result = (ReturnNode)this.leaveDefault(returnNode);
                    returns.add(result);
                    return result;
                }

                @Override
                public Node leaveDefault(Node node) {
                    Expression expr;
                    Symbol symbol;
                    if (node instanceof Expression && (symbol = (expr = (Expression)node).getSymbol()) != null) {
                        Range range = symbol.getRange();
                        Type symbolType = symbol.getSymbolType();
                        if (!symbolType.isNumeric()) {
                            return expr;
                        }
                        Type rangeType = range.getType();
                        if (!Type.areEquivalent(symbolType, rangeType) && Type.widest(symbolType, rangeType) == symbolType) {
                            RangeAnalyzer.LOG.info("[", this.lc.getCurrentFunction().getName(), "] ", symbol, " can be ", range.getType(), " ", symbol.getRange());
                            return expr.setSymbol(this.lc, symbol.setTypeOverrideShared(range.getType(), compiler.getTemporarySymbols()));
                        }
                    }
                    return node;
                }
            });
            Type returnType = Type.UNKNOWN;
            for (ReturnNode node : returns) {
                if (node.getExpression() != null) {
                    returnType = Type.widest(returnType, node.getExpression().getType());
                    continue;
                }
                returnType = Type.OBJECT;
                break;
            }
            return newFunctionNode.setReturnType(null, returnType);
        }

        public String toString() {
            return "[Range Analysis]";
        }
    };
    public static final /* enum */ CompilationPhase SPLITTING_PHASE = new CompilationPhase((EnumSet)EnumSet.of(FunctionNode.CompilationState.INITIALIZED, FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.ATTR)){

        @Override
        FunctionNode transform(Compiler compiler, FunctionNode fn) {
            CompileUnit outermostCompileUnit = compiler.addCompileUnit(compiler.firstCompileUnitName());
            FunctionNode newFunctionNode = new Splitter(compiler, fn, outermostCompileUnit).split(fn);
            assert (newFunctionNode.getCompileUnit() == outermostCompileUnit) : "fn.compileUnit (" + newFunctionNode.getCompileUnit() + ") != " + outermostCompileUnit;
            if (newFunctionNode.isStrict()) {
                assert (compiler.getStrictMode());
                compiler.setStrictMode(true);
            }
            return newFunctionNode;
        }

        public String toString() {
            return "[Code Splitting]";
        }
    };
    public static final /* enum */ CompilationPhase TYPE_FINALIZATION_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.ATTR, FunctionNode.CompilationState.SPLIT})){

        @Override
        FunctionNode transform(Compiler compiler, FunctionNode fn) {
            ScriptEnvironment env = compiler.getEnv();
            FunctionNode newFunctionNode = (FunctionNode)fn.accept((NodeVisitor)new FinalizeTypes(compiler.getTemporarySymbols()));
            if (env._print_lower_ast) {
                env.getErr().println(new ASTWriter(newFunctionNode));
            }
            if (env._print_lower_parse) {
                env.getErr().println(new PrintVisitor(newFunctionNode));
            }
            return newFunctionNode;
        }

        public String toString() {
            return "[Type Finalization]";
        }
    };
    public static final /* enum */ CompilationPhase BYTECODE_GENERATION_PHASE = new CompilationPhase(EnumSet.of(FunctionNode.CompilationState.INITIALIZED, new FunctionNode.CompilationState[]{FunctionNode.CompilationState.PARSED, FunctionNode.CompilationState.CONSTANT_FOLDED, FunctionNode.CompilationState.LOWERED, FunctionNode.CompilationState.ATTR, FunctionNode.CompilationState.SPLIT, FunctionNode.CompilationState.FINALIZED})){

        @Override
        FunctionNode transform(Compiler compiler, FunctionNode fn) {
            ScriptEnvironment env = compiler.getEnv();
            FunctionNode newFunctionNode = fn;
            try {
                CodeGenerator codegen = new CodeGenerator(compiler);
                newFunctionNode = (FunctionNode)newFunctionNode.accept((NodeVisitor)codegen);
                codegen.generateScopeCalls();
            }
            catch (VerifyError e) {
                if (env._verify_code || env._print_code) {
                    env.getErr().println(e.getClass().getSimpleName() + ": " + e.getMessage());
                    if (env._dump_on_error) {
                        e.printStackTrace(env.getErr());
                    }
                }
                throw e;
            }
            for (CompileUnit compileUnit : compiler.getCompileUnits()) {
                ClassEmitter classEmitter = compileUnit.getClassEmitter();
                classEmitter.end();
                byte[] bytecode = classEmitter.toByteArray();
                assert (bytecode != null);
                String className = compileUnit.getUnitClassName();
                compiler.addClass(className, bytecode);
                if (env._print_code) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("class: " + className).append('\n').append(ClassEmitter.disassemble(bytecode)).append("=====");
                    env.getErr().println(sb);
                }
                if (env._verify_code) {
                    compiler.getCodeInstaller().verify(bytecode);
                }
                if (env._dest_dir == null || !env._compile_only) continue;
                String fileName = className.replace('.', File.separatorChar) + ".class";
                int index = fileName.lastIndexOf(File.separatorChar);
                File dir = index != -1 ? new File(env._dest_dir, fileName.substring(0, index)) : new File(env._dest_dir);
                try {
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException(dir.toString());
                    }
                    File file = new File(env._dest_dir, fileName);
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        fos.write(bytecode);
                    }
                    Compiler.LOG.info("Wrote class to '" + file.getAbsolutePath() + '\'');
                }
                catch (IOException e) {
                    Compiler.LOG.warning("Skipping class dump for ", className, ": ", ECMAErrors.getMessage("io.error.cant.write", dir.toString()));
                }
            }
            return newFunctionNode;
        }

        public String toString() {
            return "[Bytecode Generation]";
        }
    };
    private final EnumSet<FunctionNode.CompilationState> pre;
    private long startTime;
    private long endTime;
    private boolean isFinished;
    private static final /* synthetic */ CompilationPhase[] $VALUES;

    public static CompilationPhase[] values() {
        return (CompilationPhase[])$VALUES.clone();
    }

    public static CompilationPhase valueOf(String name) {
        return Enum.valueOf(CompilationPhase.class, name);
    }

    private CompilationPhase(EnumSet<FunctionNode.CompilationState> pre) {
        this.pre = pre;
    }

    boolean isApplicable(FunctionNode functionNode) {
        return functionNode.hasState(this.pre);
    }

    protected FunctionNode begin(FunctionNode functionNode) {
        if (this.pre != null) {
            for (FunctionNode.CompilationState state : this.pre) {
                assert (functionNode.hasState(state));
            }
            for (FunctionNode.CompilationState state : FunctionNode.CompilationState.values()) {
                assert (!functionNode.hasState(state) || this.pre.contains((Object)state));
            }
        }
        this.startTime = System.currentTimeMillis();
        return functionNode;
    }

    protected FunctionNode end(FunctionNode functionNode) {
        this.endTime = System.currentTimeMillis();
        Timing.accumulateTime(this.toString(), this.endTime - this.startTime);
        this.isFinished = true;
        return functionNode;
    }

    boolean isFinished() {
        return this.isFinished;
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    abstract FunctionNode transform(Compiler var1, FunctionNode var2) throws CompilationException;

    final FunctionNode apply(Compiler compiler, FunctionNode functionNode) throws CompilationException {
        if (!this.isApplicable(functionNode)) {
            throw new CompilationException("compile phase not applicable: " + (Object)((Object)this) + " to " + functionNode.getName() + " state=" + functionNode.getState());
        }
        return this.end(this.transform(compiler, this.begin(functionNode)));
    }

    static {
        $VALUES = new CompilationPhase[]{LAZY_INITIALIZATION_PHASE, CONSTANT_FOLDING_PHASE, LOWERING_PHASE, ATTRIBUTION_PHASE, RANGE_ANALYSIS_PHASE, SPLITTING_PHASE, TYPE_FINALIZATION_PHASE, BYTECODE_GENERATION_PHASE};
    }
}

