/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import sun.applet.AppletSecurity;

public class ActivatorSecurityManager
extends AppletSecurity {
    private final Set lockedThreadGroup = new HashSet();

    public void checkAwtEventQueueAccess() {
        try {
            super.checkAwtEventQueueAccess();
            return;
        }
        catch (SecurityException securityException) {
            this.checkSecurityAccess("accessEventQueue");
            return;
        }
    }

    public void checkSecurityAccess(String string) {
        if (string != null && string.equals("java")) {
            return;
        }
        super.checkSecurityAccess(string);
    }

    public void checkPrintJobAccess() {
        try {
            super.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            new CheckPrint_1_2();
            return;
        }
    }

    void showPrintDialog() {
        String string = ResourceManager.getString((String)"plugin.print.title");
        String string2 = ResourceManager.getString((String)"plugin.print.message");
        String string3 = ResourceManager.getString((String)"plugin.print.always");
        String string4 = (String)ToolkitStore.get().getAppContext().get((Object)"sun.plugin.security.printDialog");
        int n = 0;
        if (!Trace.isAutomationEnabled() && string4 == null) {
            UIFactory uIFactory = ToolkitStore.getUI();
            ToolkitStore.getUI();
            n = uIFactory.showMessageDialog(null, null, 7, string, null, string2, null, string3, null, null);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            ToolkitStore.getUI();
            n = 0;
        }
        ToolkitStore.getUI();
        if (n == 2) {
            ToolkitStore.get().getAppContext().put((Object)"sun.plugin.security.printDialog", (Object)"skip");
        } else {
            ToolkitStore.getUI();
            if (n != 0) {
                throw new SecurityException("checkPrintJobAccess");
            }
        }
    }

    public Class[] getExecutionStackContext() {
        return super.getClassContext();
    }

    public synchronized void checkAccess(ThreadGroup threadGroup) {
        super.checkAccess(threadGroup);
        if (threadGroup.parentOf(Thread.currentThread().getThreadGroup()) && this.lockedThreadGroup.contains(threadGroup)) {
            throw new IllegalThreadStateException("forbid thread creation in disposed TG");
        }
    }

    public synchronized void lockThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            this.lockedThreadGroup.add(threadGroup);
        }
    }

    public synchronized void unlockThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            this.lockedThreadGroup.remove(threadGroup);
        }
    }

    public void checkConnect(String string, int n) {
        this.checkConnectHelper(string, n, null, false, this.getClassContext());
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnectHelper(string, n, object, true, this.getClassContext());
    }

    private void checkConnectHelper(String string, int n, Object object, boolean bl, Class[] classArray) {
        int n2;
        URL uRL = null;
        int n3 = n2 = n < 0 ? n : -4;
        if (n2 == -2 || n2 == -3) {
            try {
                uRL = new URL(string);
                string = uRL.getHost();
                n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (CrossDomainXML.quickCheck((String)string, (int)n)) {
            return;
        }
        try {
            if (bl) {
                super.checkConnect(string, n, object);
            } else {
                super.checkConnect(string, n);
            }
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (n2 == -2 ? 1 : 0) != 0)) {
                return;
            }
            throw securityException;
        }
    }

    public void checkPermission(Permission permission) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            this.checkURLPermissionHelper(permission, null, false, this.getClassContext());
            return;
        }
        super.checkPermission(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            this.checkURLPermissionHelper(permission, object, true, this.getClassContext());
            return;
        }
        super.checkPermission(permission, object);
    }

    private void checkURLPermissionHelper(Permission permission, Object object, boolean bl, Class[] classArray) {
        URL uRL = null;
        String string = null;
        int n = -1;
        try {
            uRL = new URL(permission.getName());
            string = uRL.getHost();
            n = uRL.getPort();
            if (n == -1) {
                n = uRL.getDefaultPort();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null || string == null || n < 0) {
            if (bl) {
                super.checkPermission(permission, object);
            } else {
                super.checkPermission(permission);
            }
            return;
        }
        if (CrossDomainXML.quickCheck((String)string, (int)n)) {
            return;
        }
        try {
            if (bl) {
                super.checkPermission(permission, object);
            } else {
                super.checkPermission(permission);
            }
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (boolean)false)) {
                return;
            }
            throw securityException;
        }
    }

    private class CheckPrint_1_2
    implements PrivilegedAction {
        CheckPrint_1_2() {
            AccessController.doPrivileged(this);
        }

        public Object run() {
            ActivatorSecurityManager.this.showPrintDialog();
            return null;
        }
    }
}

