/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CPCallbackClassLoaderIf;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.DeployURLClassPathCallback;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.NativeMixedCodeDialog;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CPCallbackHandler {
    private List childURLs = Collections.synchronizedList(new ArrayList());
    private HashMap assertJars = new HashMap();
    private DeployURLClassPathCallback pcb;
    private DeployURLClassPathCallback ccb;
    private Map resource2trust = new HashMap();
    private Map package2trust = new HashMap();
    private Map defaultCS = new HashMap();
    private Set trustedCS = new HashSet();
    private Set authenticatedCS = new HashSet();
    private Set unauthenticatedCS = new HashSet();
    private Collection js2JavaAllowedCodebasePatterns = new HashSet();
    private Map js2JavaResolvedResourceURLs = new HashMap();
    private boolean callerAllowableCodebaseAttributeExists = false;
    static CodeSource untrustedCS = new CodeSource(null, (Certificate[])null);
    private static DeployCacheJarAccess jarAccess = ResourceProvider.get().getJarAccess();
    private CPCallbackClassLoaderIf parent;
    private CPCallbackClassLoaderIf child;

    public CPCallbackHandler(CPCallbackClassLoaderIf cPCallbackClassLoaderIf, CPCallbackClassLoaderIf cPCallbackClassLoaderIf2) {
        this.parent = cPCallbackClassLoaderIf;
        this.child = cPCallbackClassLoaderIf2;
        this.pcb = new ParentCallback();
        this.ccb = new ChildCallback();
    }

    public DeployURLClassPathCallback getParentCallback() {
        return this.pcb;
    }

    public DeployURLClassPathCallback getChildCallback() {
        return this.ccb;
    }

    public void checkUntrustedAccess(URL uRL, DeploymentRuleSet deploymentRuleSet) {
        if (this.pcb != null && this.pcb instanceof ParentCallback) {
            ((ParentCallback)this.pcb).checkJS2JavaAccess(uRL, deploymentRuleSet);
        }
    }

    private synchronized boolean isJSCallerInWhiteList(URL uRL) {
        URL uRL2 = uRL;
        Boolean bl = (Boolean)this.js2JavaResolvedResourceURLs.get(uRL2);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.isResourceInWhitelist(uRL, this.js2JavaAllowedCodebasePatterns, true);
        this.js2JavaResolvedResourceURLs.put(uRL2, bl2);
        return bl2;
    }

    private synchronized boolean isResourceInWhitelist(URL uRL, Collection collection, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && (bl2 = DeployManifestChecker.verifyCodebase(uRL, (String)iterator.next(), bl))) {
        }
        return bl2;
    }

    public synchronized void addJS2JavaAllowedCodebasePattern(String string) {
        this.js2JavaAllowedCodebasePatterns.add(string);
        this.js2JavaResolvedResourceURLs.clear();
    }

    public void setCallerAllowableCodebaseAttributeExists() {
        this.callerAllowableCodebaseAttributeExists = true;
    }

    public synchronized void addJS2JavaAllowedCodebase(URL uRL) {
        this.addJS2JavaAllowedCodebasePattern(this.getCodebasePatternFromURL(uRL));
    }

    protected String getCodebasePatternFromURL(URL uRL) {
        String string = uRL.getProtocol() + "://" + uRL.getHost();
        int n = uRL.getPort();
        if (n > -1) {
            string = string + ":" + n;
        }
        return string;
    }

    protected static synchronized boolean hasTrustedLibraryAssertion(JarFile jarFile) {
        try {
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                String string = attributes.getValue(new Attributes.Name("Trusted-Library"));
                boolean bl = false;
                if (string != null) {
                    bl = Boolean.valueOf(string.trim());
                }
                string = attributes.getValue(new Attributes.Name("X-Trusted-Library"));
                boolean bl2 = false;
                if (string != null) {
                    bl2 = Boolean.valueOf(string.trim());
                }
                if (bl2) {
                    Trace.println("old X-Trusted-Library assertion in JAR", TraceLevel.SECURITY);
                }
                return bl || bl2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected static boolean hasTrustedOnlyAssertion(JarFile jarFile) {
        try {
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                String string = attributes.getValue(new Attributes.Name("Trusted-Only"));
                boolean bl = false;
                if (string != null) {
                    bl = Boolean.valueOf(string.trim());
                }
                string = attributes.getValue(new Attributes.Name("X-Signed-Only"));
                boolean bl2 = false;
                if (string != null) {
                    bl2 = Boolean.valueOf(string.trim());
                }
                if (bl2) {
                    Trace.println("old X-Signed-Only assertion in JAR", TraceLevel.SECURITY);
                }
                return bl || bl2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private synchronized String assertTrust(JarFile jarFile, CodeSource[] codeSourceArray) {
        HashMap<String, CodeSource> hashMap = new HashMap<String, CodeSource>();
        HashMap<String, CodeSource> hashMap2 = new HashMap<String, CodeSource>();
        String string = null;
        for (int i = 0; i < codeSourceArray.length; ++i) {
            Enumeration enumeration = jarAccess.entryNames(jarFile, new CodeSource[]{codeSourceArray[i]});
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.endsWith(".class")) {
                    string2 = string2.replace('/', '.');
                    string2 = this.getPackage(string2.substring(0, string2.length() - 6));
                    hashMap.put(string2, codeSourceArray[i]);
                    continue;
                }
                if (string2.endsWith("/")) continue;
                hashMap2.put(string2, codeSourceArray[i]);
            }
        }
        Set set = hashMap.entrySet();
        Set set2 = hashMap2.entrySet();
        Map.Entry[] entryArray = set.toArray(new Map.Entry[set.size()]);
        Map.Entry[] entryArray2 = set2.toArray(new Map.Entry[set2.size()]);
        int n = this.setTrust(this.resource2trust, entryArray2);
        if (n != -1) {
            string = "untrusted resource \"" + (String)entryArray2[n].getKey() + "\" in class path";
        }
        if ((n = this.setTrust(this.package2trust, entryArray)) != -1) {
            this.unwindTrust(this.resource2trust, entryArray2);
            string = "untrusted class package \"" + (String)entryArray[n].getKey() + "\" in class path";
        }
        return string;
    }

    private String getPackage(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(0, n);
    }

    private int setTrust(Map map, Map.Entry[] entryArray) {
        int n;
        for (n = 0; n < entryArray.length; ++n) {
            CodeSource codeSource = this.setTrust(map, (String)entryArray[n].getKey(), (CodeSource)entryArray[n].getValue());
            if (codeSource == null) continue;
            CodeSource codeSource2 = (CodeSource)entryArray[n].getValue();
            if (!codeSource.equals(codeSource2) && this.isTrusted(codeSource) != this.isTrusted(codeSource2)) break;
            entryArray[n] = null;
        }
        if (n == entryArray.length) {
            return -1;
        }
        this.unwindTrust(map, entryArray, n);
        return n;
    }

    private CodeSource setTrust(Map map, String string, CodeSource codeSource) {
        CodeSource codeSource2 = (CodeSource)map.get(string);
        if (codeSource2 == null) {
            map.put(string, codeSource);
            return null;
        }
        return codeSource2;
    }

    private void unwindTrust(Map map, Map.Entry[] entryArray, int n) {
        if (n == 0) {
            return;
        }
        --n;
        while (n >= 0) {
            if (entryArray[n] != null) {
                map.remove(entryArray[n].getKey());
            }
            --n;
        }
    }

    private void unwindTrust(Map map, Map.Entry[] entryArray) {
        this.unwindTrust(map, entryArray, entryArray.length);
    }

    private synchronized boolean checkPackage(String string, CodeSource codeSource, Boolean bl) {
        CodeSource codeSource2 = this.setTrust(this.package2trust, string, codeSource);
        return codeSource2 == null || codeSource2.equals(codeSource) || this.isTrusted(codeSource2) == bl;
    }

    private synchronized boolean checkResource(String string, CodeSource codeSource, Boolean bl) {
        CodeSource codeSource2 = this.setTrust(this.resource2trust, string, codeSource);
        return codeSource2 == null || codeSource2.equals(codeSource) || this.isTrusted(codeSource2) == bl;
    }

    private synchronized void mergeTrustedSources(CodeSource[] codeSourceArray) {
        for (int i = 0; i < codeSourceArray.length; ++i) {
            this.trustedCS.add(codeSourceArray[i]);
        }
    }

    private synchronized Boolean isTrusted(CodeSource codeSource) {
        if (codeSource == untrustedCS) {
            return Boolean.FALSE;
        }
        return this.trustedCS.contains(codeSource);
    }

    private synchronized Boolean isAuthenticated(CodeSource codeSource) {
        if (codeSource == untrustedCS) {
            return Boolean.FALSE;
        }
        boolean bl = this.authenticatedCS.contains(codeSource);
        if (bl) {
            return Boolean.TRUE;
        }
        if (!this.unauthenticatedCS.contains(codeSource)) {
            Iterator iterator = this.trustedCS.iterator();
            while (iterator.hasNext()) {
                CodeSource codeSource2 = (CodeSource)iterator.next();
                CodeSource codeSource3 = Config.isJavaVersionAtLeast15() ? new CodeSource(codeSource.getLocation(), codeSource2.getCodeSigners()) : new CodeSource(codeSource.getLocation(), codeSource2.getCertificates());
                if (codeSource3.equals(codeSource)) {
                    this.authenticatedCS.add(codeSource);
                    return Boolean.TRUE;
                }
                this.unauthenticatedCS.add(codeSource);
            }
        }
        return Boolean.FALSE;
    }

    private synchronized CodeSource getDefaultCodeSource(URL uRL) {
        if (!this.trustedCS.isEmpty()) {
            CodeSource codeSource = (CodeSource)this.defaultCS.get(uRL);
            if (codeSource == null) {
                codeSource = new CodeSource(uRL, (Certificate[])null);
                this.defaultCS.put(uRL, codeSource);
            }
            return codeSource;
        }
        return untrustedCS;
    }

    private AppInfo getAppInfo() {
        AppInfo appInfo = this.parent.getAppInfo(null);
        return appInfo;
    }

    private static int showDialog(boolean bl, AppInfo appInfo) {
        Object object;
        String string = "";
        String string2 = appInfo.getTitle();
        if (bl) {
            string = null;
            string2 = null;
            object = ResourceProvider.get().getLocalApplicationProperties(appInfo.getLapURL(), null, true);
            if (object != null) {
                string = object.getMainPublisher();
                string2 = object.getMainTitle();
            } else if (Cache.isCacheEnabled()) {
                Trace.println("Unexpected error: LAP is null but cache is enabled", TraceLevel.LIVECONNECT);
            }
            if (string == null) {
                string = ResourceManager.getString("security.dialog.notverified.subject").toUpperCase();
            }
            if (string2 == null) {
                string2 = ResourceManager.getString("dialog.template.name.unknown").toUpperCase();
            }
        }
        if (NativeMixedCodeDialog.isSupported()) {
            object = "security.dialog.nativemixcode." + (bl ? "js." : "");
            String string3 = ResourceManager.getString((String)object + "title");
            String string4 = ResourceManager.getString((String)object + "masthead");
            String string5 = ResourceManager.getString((String)object + "message");
            String string6 = ResourceManager.getString((String)object + "info");
            String string7 = ResourceManager.getString((String)object + "firstBtnStr");
            String string8 = ResourceManager.getString((String)object + "secondBtnStr");
            String string9 = ResourceManager.getString((String)object + "helpBtnStr");
            String string10 = ResourceManager.getString((String)object + "closeBtnStr");
            String string11 = ResourceManager.getString((String)object + "helpTitle");
            String string12 = ResourceManager.getString((String)object + "helpMessage");
            String string13 = ResourceManager.getString((String)object + "appLabelStr");
            String string14 = bl ? ResourceManager.getString((String)object + "appLabelWebsite") : "";
            String string15 = bl ? ResourceManager.getString((String)object + "appLabelPublisher") : "";
            String string16 = bl ? appInfo.getDisplayFrom() : "";
            return NativeMixedCodeDialog.show(string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string2, string14, string16, string15, string);
        }
        object = "security.dialog.mixcode." + (bl ? "js." : "");
        String string17 = ResourceManager.getString((String)object + "title");
        String string18 = ResourceManager.getString((String)object + "header");
        String string19 = ResourceManager.getString((String)object + "question");
        String string20 = ResourceManager.getString((String)object + "alert");
        String string21 = ResourceManager.getString((String)object + "buttonYes");
        String string22 = ResourceManager.getString((String)object + "buttonNo");
        if (bl) {
            appInfo.setVendor(string);
            appInfo.setTitle(string2);
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        return uIFactory.showMessageDialog(null, appInfo, 4, string17, string18, string19, string20, string21, string22, null);
    }

    private class ChildCallback
    extends DeployURLClassPathCallback {
        private ChildCallback() {
        }

        public DeployURLClassPathCallback.Element openClassPathElement(JarFile jarFile, URL uRL) throws IOException {
            ChildElement childElement = new ChildElement(jarFile, uRL);
            if (CPCallbackHandler.this.childURLs.contains(uRL)) {
                if (jarFile != null) {
                    jarAccess.setEagerValidation(jarFile, true);
                }
                return childElement;
            }
            childElement.skip(true);
            return childElement;
        }

        public DeployURLClassPathCallback.Element openClassPathElement(URL uRL) throws IOException {
            return this.openClassPathElement(null, uRL);
        }
    }

    private class ChildElement
    extends DeployURLClassPathCallback.Element {
        boolean skip;
        Boolean trusted;
        Boolean authenticated;
        CodeSource cs;

        ChildElement(JarFile jarFile, URL uRL) {
            super(jarFile, uRL);
            CodeSource[] codeSourceArray;
            this.cs = jarFile != null ? ((codeSourceArray = jarAccess.getCodeSources(jarFile, uRL)) != null && codeSourceArray.length > 0 ? codeSourceArray[0] : null) : CPCallbackHandler.this.getDefaultCodeSource(uRL);
            this.trusted = CPCallbackHandler.this.isTrusted(this.cs);
            this.authenticated = this.trusted == false && this.cs.getCertificates() != null ? CPCallbackHandler.this.isAuthenticated(this.cs) : Boolean.FALSE;
        }

        public void checkResource(String string) {
            Boolean bl;
            Boolean bl2;
            CodeSource codeSource;
            String string2 = null;
            if (string == null || string.endsWith("/")) {
                return;
            }
            if (this.jar != null) {
                codeSource = jarAccess.getCodeSource(this.jar, this.url, string);
                bl2 = codeSource == this.cs ? this.trusted : CPCallbackHandler.this.isTrusted(codeSource);
                bl = this.authenticated != false ? this.authenticated : CPCallbackHandler.this.isAuthenticated(codeSource);
            } else {
                codeSource = this.cs;
                bl2 = this.trusted;
                bl = this.authenticated;
            }
            ((ParentCallback)CPCallbackHandler.this.pcb).check(this.url, bl2, bl);
            if (string.endsWith(".class")) {
                string2 = string.replace('/', '.');
                string2 = CPCallbackHandler.this.getPackage(string2.substring(0, string2.length() - 6));
            }
            if (string2 != null) {
                if (!CPCallbackHandler.this.checkPackage(string2, codeSource, bl2)) {
                    String string3 = string.replace('/', '.').substring(0, string.length() - 6);
                    String string4 = "class \"" + string3 + "\" does not match trust level of other classes in the same package";
                    throw new SecurityException(string4);
                }
            } else if (!CPCallbackHandler.this.checkResource(string, codeSource, bl2)) {
                String string5 = "resource \"" + string + "\" does not match trust level of other resources of the same name";
                throw new SecurityException(string5);
            }
        }

        void skip(boolean bl) {
            this.skip = bl;
        }

        public boolean skip() {
            return this.skip;
        }
    }

    private class ParentCallback
    extends DeployURLClassPathCallback {
        private boolean trustedChild;
        private boolean authenticatedChild;
        private boolean untrustedChild;
        private boolean trustedOnly;
        private boolean allowMixedTrust;
        private boolean checkMixedTrust;
        private boolean allowMixedTrustForJS;

        private ParentCallback() {
            if (Config.getMixcodeValue() == 0) {
                this.checkMixedTrust = true;
            }
            if (!(this.checkMixedTrust || Config.getMixcodeValue() != 1 && Config.getMixcodeValue() != 3)) {
                this.allowMixedTrust = true;
            }
        }

        private void checkJS2JavaAccess(URL uRL, final DeploymentRuleSet deploymentRuleSet) {
            if (!this.allowMixedTrustForJS && !CPCallbackHandler.this.isJSCallerInWhiteList(uRL)) {
                if (!CPCallbackHandler.this.callerAllowableCodebaseAttributeExists) {
                    Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return deploymentRuleSet.isRunUntrustedNever() || SecurityBaseline.isExpired() && deploymentRuleSet.isSSVModeNever();
                        }
                    });
                    if (bl.booleanValue()) {
                        String string = "LiveConnect (JavaScript) blocked due to security settings.";
                        Trace.println("Security Exception: " + string, TraceLevel.LIVECONNECT);
                        throw new SecurityException(string);
                    }
                    String string = this.checkJSAllowed(uRL);
                    if (string != null) {
                        Trace.println("Security Exception: " + string, TraceLevel.LIVECONNECT);
                        throw new SecurityException(string);
                    }
                } else {
                    String string = "JavaScript from " + uRL + " attempted to access a resource it has no rights to.";
                    Trace.println("Security Exception: " + string, TraceLevel.LIVECONNECT);
                    throw new SecurityException(string);
                }
            }
        }

        public synchronized DeployURLClassPathCallback.Element openClassPathElement(JarFile jarFile, URL uRL) throws IOException {
            jarAccess.setEagerValidation(jarFile, true);
            return this.strategy(jarFile, uRL, jarAccess.getCodeSources(jarFile, uRL));
        }

        public synchronized DeployURLClassPathCallback.Element openClassPathElement(URL uRL) throws IOException {
            return this.strategy(null, uRL, new CodeSource[]{new CodeSource(uRL, (Certificate[])null)});
        }

        private DeployURLClassPathCallback.Element strategy(JarFile jarFile, URL uRL, CodeSource[] codeSourceArray) {
            String string;
            CodeSource[] codeSourceArray2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = this.trustedOnly;
            boolean bl4 = this.trustedChild;
            boolean bl5 = false;
            boolean bl6 = false;
            ParentElement parentElement = new ParentElement(jarFile, uRL);
            if (jarFile != null) {
                bl5 = CPCallbackHandler.hasTrustedLibraryAssertion(jarFile);
                bl6 = CPCallbackHandler.hasTrustedOnlyAssertion(jarFile);
            }
            if (bl6) {
                Trace.println(uRL + " is asserting Trusted-Only", TraceLevel.SECURITY);
                if (this.authenticatedChild || this.untrustedChild) {
                    parentElement.setPendingException("attempted to open Trusted-Only jar " + uRL + " on sandboxed loader");
                    return parentElement;
                }
            }
            if ((codeSourceArray2 = CPCallbackHandler.this.parent.getTrustedCodeSources(codeSourceArray)) != null && codeSourceArray2.length > 0) {
                bl = true;
                if (codeSourceArray2.length == codeSourceArray.length) {
                    bl2 = true;
                } else {
                    boolean bl7 = false;
                    for (int i = codeSourceArray.length - 1; i >= 0; --i) {
                        if (codeSourceArray[i].getCertificates() != null) continue;
                        CodeSource[] codeSourceArray3 = new CodeSource[]{codeSourceArray[i]};
                        if (!jarAccess.entryNames(jarFile, codeSourceArray3).hasMoreElements()) continue;
                        bl7 = true;
                        break;
                    }
                    bl2 = !bl7;
                }
                CPCallbackHandler.this.mergeTrustedSources(codeSourceArray2);
            }
            if (bl2) {
                if (bl5) {
                    if (this.authenticatedChild || this.untrustedChild) {
                        parentElement.setPendingException(CPCallbackHandler.this.assertTrust(jarFile, codeSourceArray2));
                        return parentElement;
                    }
                    CPCallbackHandler.this.assertJars.put(jarFile, codeSourceArray2);
                    return parentElement;
                }
                if (bl6 && !this.trustedOnly) {
                    Trace.println(uRL + " is newly asserting Trusted-Only", TraceLevel.SECURITY);
                    bl3 = true;
                }
            } else {
                if (bl6) {
                    parentElement.setPendingException("attempted to open sandboxed jar " + uRL + " as Trusted-Only");
                    return parentElement;
                }
                if (bl5) {
                    parentElement.setPendingException("attempted to open sandboxed jar " + uRL + " as a Trusted-Library");
                    return parentElement;
                }
            }
            if (bl && jarFile != null) {
                bl4 = true;
            }
            if (bl4 && this.untrustedChild && (string = this.checkAllowed(uRL, bl4 && this.trustedChild)) != null) {
                parentElement.setPendingException(string);
                return parentElement;
            }
            if (this.authenticatedChild || this.untrustedChild) {
                String string2;
                if (!CPCallbackHandler.this.assertJars.isEmpty()) {
                    Iterator iterator = CPCallbackHandler.this.assertJars.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        CPCallbackHandler.this.assertTrust((JarFile)entry.getKey(), (CodeSource[])entry.getValue());
                    }
                    CPCallbackHandler.this.assertJars.clear();
                }
                if (jarFile != null && bl && (string2 = CPCallbackHandler.this.assertTrust(jarFile, codeSourceArray2)) != null) {
                    parentElement.setPendingException(string2);
                    return parentElement;
                }
            } else if (jarFile != null && bl) {
                CPCallbackHandler.this.assertJars.put(jarFile, codeSourceArray2);
            }
            CPCallbackHandler.this.childURLs.add(uRL);
            this.trustedOnly = bl3;
            this.trustedChild = bl4;
            parentElement.defer(true);
            return parentElement;
        }

        private synchronized void check(URL uRL, boolean bl, boolean bl2) {
            Object object;
            boolean bl3 = this.trustedChild;
            boolean bl4 = this.untrustedChild;
            boolean bl5 = this.authenticatedChild;
            if (!bl && this.trustedOnly) {
                throw new SecurityException("Trusted-Only loader attempted to load sandboxed resource from " + uRL);
            }
            if (bl) {
                bl3 = true;
            } else if (bl2) {
                bl5 = true;
            } else {
                bl4 = true;
            }
            if (bl3 && bl4 && (object = this.checkAllowed(uRL, bl3 && this.trustedChild)) != null) {
                throw new SecurityException((String)object);
            }
            if ((bl5 || bl4) && !CPCallbackHandler.this.assertJars.isEmpty()) {
                object = CPCallbackHandler.this.assertJars.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    CPCallbackHandler.this.assertTrust((JarFile)entry.getKey(), (CodeSource[])entry.getValue());
                }
                CPCallbackHandler.this.assertJars.clear();
            }
            this.trustedChild = bl3;
            this.authenticatedChild = bl5;
            this.untrustedChild = bl4;
        }

        private String checkAllowed(URL uRL, boolean bl) {
            if (uRL != null && CPCallbackHandler.this.parent.getDeploymentRuleSet(uRL).isRuleRun()) {
                this.allowMixedTrust = true;
            } else if (this.checkMixedTrust) {
                int n = CPCallbackHandler.showDialog(false, CPCallbackHandler.this.getAppInfo());
                ToolkitStore.getUI();
                if (n == 1) {
                    this.allowMixedTrust = true;
                }
                this.checkMixedTrust = false;
            }
            if (!this.allowMixedTrust) {
                if (bl) {
                    return "trusted loader attempted to load sandboxed resource" + (uRL != null ? " from " + uRL : "");
                }
                return "sandboxed loader attempted to load trusted resource" + (uRL != null ? " from " + uRL : "");
            }
            return null;
        }

        private String checkJSAllowed(URL uRL) {
            if (uRL != null && CPCallbackHandler.this.parent.getDeploymentRuleSet(uRL).isRuleRun()) {
                this.allowMixedTrustForJS = true;
            } else {
                AppInfo appInfo = CPCallbackHandler.this.getAppInfo();
                if (uRL != null) {
                    appInfo.setFrom(uRL);
                }
                int n = CPCallbackHandler.showDialog(true, appInfo);
                ToolkitStore.getUI();
                if (n == 0) {
                    this.allowMixedTrustForJS = true;
                }
            }
            if (!this.allowMixedTrustForJS) {
                if (uRL == null) {
                    return "JavaScript attempted to access a resource when trusted content exists";
                }
                return "JavaScript from " + uRL + " attempted to access" + " a resource it has no rights to.";
            }
            return null;
        }
    }

    private class ParentElement
    extends DeployURLClassPathCallback.Element {
        String pendingException;
        boolean defer;

        ParentElement(JarFile jarFile, URL uRL) {
            super(jarFile, uRL);
        }

        public void checkResource(String string) {
            if (this.pendingException != null) {
                throw new SecurityException(this.pendingException);
            }
            if (this.jar == null) {
                throw new SecurityException("invalid class path element " + this.url + " on Trusted-Library loader");
            }
        }

        void setPendingException(String string) {
            this.pendingException = string;
        }

        void defer(boolean bl) {
            this.defer = bl;
        }

        public boolean defer() {
            return this.defer;
        }

        public String toString() {
            return "defer: " + this.defer + ", pending: " + this.pendingException;
        }
    }
}

