/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentCharactersDir
implements Serializable {
    private static final long serialVersionUID = -5274310741380875405L;
    public static final String FILENAME = "recent-characterdirs.ser";
    private File lastUseCharacterDir;
    private ArrayList<File> recentCharacterDirs = new ArrayList();
    private boolean doNotAskAgain;

    public ArrayList<File> getRecentCharacterDirs() {
        return this.recentCharacterDirs;
    }

    public void setLastUseCharacterDir(File lastUseCharacterDir) {
        this.lastUseCharacterDir = lastUseCharacterDir;
    }

    public File getLastUseCharacterDir() {
        return this.lastUseCharacterDir;
    }

    public void clrar() {
        this.doNotAskAgain = false;
        this.lastUseCharacterDir = null;
        this.recentCharacterDirs.clear();
    }

    public boolean isDoNotAskAgain() {
        return this.doNotAskAgain;
    }

    public void setDoNotAskAgain(boolean doNotAskAgain) {
        this.doNotAskAgain = doNotAskAgain;
    }

    public static RecentCharactersDir load() throws IOException {
        UserDataFactory factory = UserDataFactory.getInstance();
        UserData recentCharDirs = factory.getUserData(FILENAME);
        if (recentCharDirs.exists()) {
            return (RecentCharactersDir)recentCharDirs.load();
        }
        return null;
    }

    public void saveRecents() throws IOException {
        if (this.lastUseCharacterDir != null) {
            Iterator<File> ite = this.recentCharacterDirs.iterator();
            while (ite.hasNext()) {
                File file = ite.next();
                if (!this.lastUseCharacterDir.equals(file)) continue;
                ite.remove();
            }
            this.recentCharacterDirs.add(0, this.lastUseCharacterDir);
        }
        UserDataFactory factory = UserDataFactory.getInstance();
        UserData recentCharDirs = factory.getUserData(FILENAME);
        recentCharDirs.save(this);
    }
}

