/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMappedProperties
extends AbstractMap<String, String> {
    private File file;
    private RandomAccessFile accessFile;
    private FileChannel channel;
    private Properties props = new Properties();
    private boolean modified;

    public FileMappedProperties(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.accessFile = new RandomAccessFile(file, "rw");
    }

    public File getFile() {
        return this.file;
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.checkOpen();
        if (this.channel != null) {
            return;
        }
        this.props.clear();
        this.channel = this.accessFile.getChannel();
        this.channel.lock();
        int siz = (int)this.channel.size();
        if (siz == 0) {
            return;
        }
        byte[] data = new byte[siz];
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.channel.read(buf);
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try {
            this.props.loadFromXML(bis);
        }
        finally {
            ((InputStream)bis).close();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.modified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        this.checkOpen();
        if (this.channel == null) {
            this.channel = this.accessFile.getChannel();
            this.channel.lock();
        }
        this.channel.position(0L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            String comment = this.file.getName().toString() + " " + new Timestamp(System.currentTimeMillis());
            this.props.storeToXML(bos, comment);
        }
        finally {
            bos.close();
        }
        byte[] data = bos.toByteArray();
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.channel.write(buf);
        this.channel.truncate(data.length);
        this.modified = false;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.accessFile != null) {
            this.accessFile.close();
            this.accessFile = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public String put(String key, String value) {
        this.checkOpen();
        String oldValue = (String)this.props.setProperty(key, value);
        if (!(value == oldValue || value != null && oldValue != null && value.equals(oldValue))) {
            this.modified = true;
        }
        return oldValue;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        final Set<Map.Entry<Object, Object>> entrySet = this.props.entrySet();
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                final Iterator ite = entrySet.iterator();
                return new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        return ite.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        final Map.Entry entry = (Map.Entry)ite.next();
                        return new Map.Entry<String, String>(){

                            @Override
                            public String getKey() {
                                return (String)entry.getKey();
                            }

                            @Override
                            public String getValue() {
                                return (String)entry.getValue();
                            }

                            @Override
                            public String setValue(String value) {
                                FileMappedProperties.this.checkOpen();
                                return entry.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        FileMappedProperties.this.checkOpen();
                        FileMappedProperties.this.modified = true;
                        ite.remove();
                    }
                };
            }

            @Override
            public int size() {
                return entrySet.size();
            }
        };
    }

    protected void checkOpen() {
        if (this.accessFile == null) {
            throw new IllegalStateException("file is already closed." + this.file);
        }
    }
}

