/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.util.PurgeOldLogs;
import charactermanaj.model.util.PurgeUnusedCache;
import charactermanaj.model.util.UpgradeCache;
import charactermanaj.model.util.UpgradeFavoritesXml;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StartupSupport {
    private static StartupSupport inst;

    public static synchronized StartupSupport getInstance() {
        if (inst == null) {
            inst = new StartupSupport(){
                private final Logger logger = Logger.getLogger(StartupSupport.class.getName());

                public void doStartup() {
                    StartupSupport[] startups;
                    for (StartupSupport startup : startups = new StartupSupport[]{new PurgeOldLogs(), new UpgradeCache(), new UpgradeFavoritesXml(), new PurgeUnusedCache()}) {
                        this.logger.log(Level.FINE, "startup operation start. class=" + startup.getClass().getSimpleName());
                        try {
                            startup.doStartup();
                            this.logger.log(Level.FINE, "startup operation is done.");
                        }
                        catch (Exception ex) {
                            this.logger.log(Level.WARNING, "startup operation failed.", ex);
                        }
                    }
                }
            };
        }
        return inst;
    }

    public abstract void doStartup();
}

