/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public class PartsImageDirectoryWatchAgentThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(PartsImageDirectoryWatchAgent.class.getName());
    private final CharacterData characterData;
    private final File baseDir;
    private final Object lockListeners = new Object();
    private LinkedList<PartsImageDirectoryWatchListener> listeners = new LinkedList();
    private IdentityHashMap<PartsImageDirectoryWatchListener, Integer> suspendStateMap = new IdentityHashMap();
    private final Object lock = new Object();
    private volatile boolean stopFlag;
    private int dirWatchInterval;
    private Thread thread;
    private volatile Long signature;
    private volatile int itemCount;
    private volatile long maxLastModified;

    public PartsImageDirectoryWatchAgentThread(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        URI docBase = characterData.getDocBase();
        File baseDir = null;
        if (docBase != null && "file".equals(docBase.getScheme())) {
            baseDir = new File(docBase).getParentFile();
        }
        this.characterData = characterData;
        this.baseDir = baseDir;
        this.dirWatchInterval = AppConfig.getInstance().getDirWatchInterval();
    }

    public CharacterData getCharcterData() {
        return this.characterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        logger.log(Level.FINE, "watchAgent request start. " + this);
        Object object = this.lock;
        synchronized (object) {
            if (this.thread != null && this.thread.isAlive()) {
                return;
            }
            AppConfig appConfig = AppConfig.getInstance();
            if (appConfig.isDisableWatchDirIfNotWritable()) {
                try {
                    File docBaseFile;
                    if (!(this.baseDir != null && this.baseDir.exists() && this.baseDir.isDirectory() && this.baseDir.canWrite())) {
                        logger.log(Level.INFO, "does not monitor the directory because it is not writable." + this.baseDir);
                        return;
                    }
                    URI docBase = this.characterData.getDocBase();
                    if (!(docBase == null || (docBaseFile = new File(docBase)).exists() && docBaseFile.canWrite())) {
                        logger.log(Level.INFO, "does not monitor the directory because the character.xml is not writable." + this.characterData);
                        return;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "watch-dir start failed. " + this.characterData, ex);
                    return;
                }
            }
            this.stopFlag = false;
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stop() {
        logger.log(Level.FINE, "watchAgent request stop. " + this);
        boolean stopped = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.thread != null && this.thread.isAlive()) {
                this.stopFlag = true;
                this.thread.interrupt();
                try {
                    this.thread.join(10000L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.FINE, "stop request interrupted.", ex);
                }
                stopped = true;
            }
            this.thread = null;
        }
        return stopped;
    }

    public void run() {
        logger.log(Level.FINE, "watch-dir thead started. " + this);
        this.signature = null;
        while (!this.stopFlag) {
            try {
                Thread.sleep(this.dirWatchInterval);
                this.watch(new Runnable(){

                    public void run() {
                        PartsImageDirectoryWatchAgentThread.this.fireWatchEvent();
                    }
                });
            }
            catch (InterruptedException ex) {
                logger.log(Level.FINE, "watch-dir thead interrupted.");
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "PartsImageDirectoryWatchAgent failed.", ex);
            }
        }
        logger.log(Level.FINE, "watch-dir thead stopped. " + this);
    }

    protected void watch(Runnable notifier) throws InterruptedException {
        if (this.baseDir == null || !this.baseDir.exists() || !this.baseDir.isDirectory()) {
            return;
        }
        int itemCount = 0;
        long maxLastModified = 0L;
        long now = System.currentTimeMillis() + (long)this.dirWatchInterval;
        CRC32 crc = new CRC32();
        for (PartsCategory partsCategory : this.characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                File watchDir = new File(this.baseDir, layer.getDir());
                ArrayList<String> files = new ArrayList<String>();
                if (watchDir.exists() && watchDir.isDirectory()) {
                    for (File file : watchDir.listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().toLowerCase().endsWith(".png");
                        }
                    })) {
                        if (Thread.interrupted() || this.stopFlag) {
                            throw new InterruptedException();
                        }
                        ++itemCount;
                        long lastModified = file.lastModified();
                        if (lastModified <= now) {
                            maxLastModified = Math.max(maxLastModified, lastModified);
                        }
                        files.add(file.getName() + ":" + lastModified);
                    }
                    Collections.sort(files);
                }
                for (String file : files) {
                    crc.update(file.getBytes());
                }
            }
        }
        long signature = crc.getValue();
        if (this.signature != null && (this.signature != signature || this.itemCount != itemCount || this.maxLastModified != maxLastModified) && notifier != null) {
            notifier.run();
        }
        this.signature = signature;
        this.maxLastModified = maxLastModified;
        this.itemCount = itemCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            Object object = this.lockListeners;
            synchronized (object) {
                this.listeners.add(l);
            }
            this.changeSuspendState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartsImageDirectoryWatchListener(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            Object object = this.lockListeners;
            synchronized (object) {
                this.listeners.remove(l);
                this.suspendStateMap.remove(l);
            }
            this.changeSuspendState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            Object object = this.lockListeners;
            synchronized (object) {
                Integer cnt = this.suspendStateMap.get(l);
                cnt = cnt == null ? Integer.valueOf(1) : Integer.valueOf(cnt + 1);
                this.suspendStateMap.put(l, cnt);
            }
            this.changeSuspendState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(PartsImageDirectoryWatchListener l) {
        if (l != null) {
            Object object = this.lockListeners;
            synchronized (object) {
                Integer cnt = this.suspendStateMap.get(l);
                if (cnt != null) {
                    if ((cnt = Integer.valueOf(cnt - 1)) > 0) {
                        this.suspendStateMap.put(l, cnt);
                    } else {
                        this.suspendStateMap.remove(l);
                    }
                }
            }
            this.changeSuspendState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeSuspendState() {
        boolean active;
        Object object = this.lockListeners;
        synchronized (object) {
            active = !this.listeners.isEmpty() && this.suspendStateMap.isEmpty();
        }
        if (active) {
            this.start();
        } else {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWatchEvent() {
        PartsImageDirectoryWatchListener[] listeners;
        LinkedList<PartsImageDirectoryWatchListener> linkedList = this.listeners;
        synchronized (linkedList) {
            listeners = this.listeners.toArray(new PartsImageDirectoryWatchListener[this.listeners.size()]);
        }
        PartsImageDirectoryWatchEvent e = new PartsImageDirectoryWatchEvent(this.characterData);
        for (PartsImageDirectoryWatchListener listener : listeners) {
            listener.detectPartsImageChange(e);
        }
    }
}

