/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsFiles;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsManageDataConverter;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.AbstractCharacterDataFileWriter;
import charactermanaj.model.io.CharacterDataPersistent;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharacterDataArchivedFileWriter
extends AbstractCharacterDataFileWriter {
    protected AbstractCharacterDataArchivedFileWriter(File outFile) throws IOException {
        super(outFile);
    }

    protected abstract OutputStream getOutputStream() throws IOException;

    protected abstract void putNextEntry(String var1, long var2) throws IOException;

    protected abstract void closeEntry() throws IOException;

    @Override
    protected void internalWriteExportProp(Properties prop) throws IOException {
        this.putNextEntry("export-info.xml", 0L);
        prop.storeToXML(this.getOutputStream(), "exportProp");
    }

    @Override
    protected void internalWriteCharacterData(CharacterData characterData) throws IOException {
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        this.putNextEntry("character.xml", 0L);
        persist.writeXMLCharacterData(characterData, this.getOutputStream());
        this.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalWriteTextUTF16LE(String name, String contents) throws IOException {
        if (contents == null) {
            contents = "";
        }
        contents = contents.replace("\r\n", "\n");
        contents = contents.replace("\r", "\n");
        contents = contents.replace("\n", "\r\n");
        this.putNextEntry(name, 0L);
        OutputStream os = this.getOutputStream();
        os.write(-1);
        os.write(-2);
        os.flush();
        OutputStreamWriter wr = new OutputStreamWriter(os, Charset.forName("UTF-16LE"));
        try {
            wr.append(contents);
            wr.flush();
        }
        finally {
            this.closeEntry();
        }
    }

    @Override
    protected void internalWriteSamplePicture(BufferedImage samplePicture) throws IOException {
        this.putNextEntry("preview.png", 0L);
        ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
        imageSaveHelper.savePicture(samplePicture, Color.white, this.getOutputStream(), "image/png", null);
        this.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalWritePartsImages(Map<PartsIdentifier, PartsSpec> partsImages) throws IOException {
        AppConfig appConfig = AppConfig.getInstance();
        byte[] buf = new byte[appConfig.getJarTransferBufferSize()];
        for (Map.Entry<PartsIdentifier, PartsSpec> entry : partsImages.entrySet()) {
            PartsIdentifier partsIdentifier = entry.getKey();
            PartsSpec partsSpec = entry.getValue();
            PartsFiles partsFiles = partsSpec.getPartsFiles();
            for (Map.Entry<Layer, ImageResource> imageEntry : partsFiles.entrySet()) {
                Layer layer = imageEntry.getKey();
                ImageResource imageResource = imageEntry.getValue();
                String name = layer.getDir() + "/" + partsIdentifier.getPartsName() + ".png";
                name = name.replace("//", "/");
                this.putNextEntry(name, imageResource.lastModified());
                OutputStream os = this.getOutputStream();
                InputStream is = imageResource.openStream();
                try {
                    int rd;
                    while ((rd = is.read(buf)) >= 0) {
                        os.write(buf, 0, rd);
                    }
                }
                finally {
                    is.close();
                }
                this.closeEntry();
            }
        }
    }

    @Override
    protected void internalWritePartsManageData(Map<PartsIdentifier, PartsSpec> partsImages) throws IOException {
        PartsManageDataConverter partsManageDataConverter = new PartsManageDataConverter();
        for (Map.Entry<PartsIdentifier, PartsSpec> entry : partsImages.entrySet()) {
            PartsIdentifier partsIdentifier = entry.getKey();
            PartsSpec partsSpec = entry.getValue();
            partsManageDataConverter.convert(partsIdentifier, partsSpec);
        }
        PartsManageData partsManageData = partsManageDataConverter.getPartsManageData();
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        this.putNextEntry("parts-info.xml", 0L);
        persist.savePartsManageData(partsManageData, this.getOutputStream());
        this.closeEntry();
    }
}

