/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileImageResource
implements ImageResource {
    private File file;

    public FileImageResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public InputStream openStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public int compareTo(ImageResource o) {
        return this.getFullName().compareTo(o.getFullName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof FileImageResource) {
            FileImageResource o = (FileImageResource)obj;
            return this.file.equals(o.file);
        }
        return false;
    }

    public String getFullName() {
        return this.file.getPath();
    }

    public URL getURL() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public String toString() {
        return this.file.toString();
    }
}

