/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.ui.ImportPartsModel;
import charactermanaj.ui.ImportPartsTableModel;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPartsSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "importPartsSelectPanel";
    private ImportWizardDialog parent;
    private ImportPartsTableModel partsTableModel;
    private JPanel profileSizePanel;
    private JTextField txtProfileHeight;
    private int profileWidth;
    private int profileHeight;
    private JTextField txtProfileWidth;
    private JTable partsTable;
    private Action actSelectAll;
    private Action actDeselectAll;
    private Action actSort;
    private Action actSortByTimestamp;

    public ImportPartsSelectPanel() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/importwizdialog");
        this.setLayout(new BorderLayout());
        this.profileSizePanel = new JPanel();
        GridBagLayout profileSizePanelLayout = new GridBagLayout();
        this.profileSizePanel.setLayout(profileSizePanelLayout);
        this.profileSizePanel.setBorder(BorderFactory.createTitledBorder("\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u306e\u30b5\u30a4\u30ba"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.profileSizePanel.add((Component)new JLabel("\u5e45:", 4), gbc);
        this.txtProfileWidth = new JTextField();
        this.txtProfileWidth.setEditable(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.profileSizePanel.add((Component)this.txtProfileWidth, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.profileSizePanel.add((Component)new JLabel("\u9ad8\u3055:", 4), gbc);
        this.txtProfileHeight = new JTextField();
        this.txtProfileHeight.setEditable(false);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.profileSizePanel.add((Component)this.txtProfileHeight, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.profileSizePanel.add(Box.createHorizontalGlue(), gbc);
        this.add((Component)this.profileSizePanel, "North");
        this.partsTableModel = new ImportPartsTableModel();
        this.partsTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                ImportPartsSelectPanel.this.fireChangeEvent();
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        final Color disabledForeground = appConfig.getDisabledCellForgroundColor();
        this.partsTable = new JTable(this.partsTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                ImportPartsTableModel model;
                ImportPartsModel rowModel;
                Long lastModifiedAtCur;
                Component comp = super.prepareRenderer(renderer, row, column);
                if (comp instanceof JCheckBox) {
                    comp.setEnabled(this.isCellEditable(row, column) && this.isEnabled());
                }
                if ((lastModifiedAtCur = (rowModel = (ImportPartsModel)(model = (ImportPartsTableModel)this.getModel()).getRow(row)).getLastModifiedAtCurrentProfile()) != null) {
                    comp.setFont(this.getFont().deriveFont(1));
                } else {
                    comp.setFont(this.getFont());
                }
                boolean warnings = false;
                if (column == 5) {
                    if (lastModifiedAtCur != null && rowModel.getLastModified() < lastModifiedAtCur) {
                        warnings = true;
                    }
                } else if (column == 4) {
                    if (!rowModel.isAlphaColor()) {
                        warnings = true;
                    }
                } else if (column == 3 && (rowModel.isUnmatchedSize() || ImportPartsSelectPanel.this.profileWidth != rowModel.getWidth() || ImportPartsSelectPanel.this.profileHeight != rowModel.getHeight())) {
                    warnings = true;
                }
                Color foregroundColor = this.isCellSelected(row, column) ? this.getSelectionForeground() : this.getForeground();
                comp.setForeground(this.isEnabled() ? foregroundColor : disabledForeground);
                if (warnings) {
                    AppConfig appConfig = AppConfig.getInstance();
                    Color invalidBgColor = appConfig.getInvalidBgColor();
                    comp.setBackground(invalidBgColor);
                } else if (this.isCellSelected(row, column)) {
                    comp.setBackground(this.getSelectionBackground());
                } else {
                    comp.setBackground(this.getBackground());
                }
                return comp;
            }
        };
        this.partsTable.setAutoResizeMode(0);
        this.partsTable.setShowGrid(true);
        this.partsTable.setGridColor(appConfig.getGridColor());
        this.partsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.partsTableModel.adjustColumnModel(this.partsTable.getColumnModel());
        this.partsTable.setSelectionMode(2);
        this.partsTable.setRowSelectionAllowed(true);
        AbstractAction actPartsSetCheck = new AbstractAction(strings.getProperty("parts.popup.check")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int[] selRows = ImportPartsSelectPanel.this.partsTable.getSelectedRows();
                ImportPartsSelectPanel.this.partsTableModel.setCheck(selRows, true);
            }
        };
        AbstractAction actPartsUnsetCheck = new AbstractAction(strings.getProperty("parts.popup.uncheck")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int[] selRows = ImportPartsSelectPanel.this.partsTable.getSelectedRows();
                ImportPartsSelectPanel.this.partsTableModel.setCheck(selRows, false);
            }
        };
        JPopupMenu partsTablePopupMenu = new JPopupMenu();
        partsTablePopupMenu.add(actPartsSetCheck);
        partsTablePopupMenu.add(actPartsUnsetCheck);
        this.partsTable.setComponentPopupMenu(partsTablePopupMenu);
        JScrollPane partsTableSP = new JScrollPane(this.partsTable);
        partsTableSP.setBorder(null);
        JPanel partsTableTitledPanel = new JPanel(new BorderLayout());
        partsTableTitledPanel.add((Component)partsTableSP, "Center");
        partsTableTitledPanel.setBorder(BorderFactory.createTitledBorder(strings.getProperty("parts.title")));
        this.add((Component)partsTableTitledPanel, "Center");
        this.actSelectAll = new AbstractAction(strings.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportPartsSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(strings.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportPartsSelectPanel.this.onDeselectAll();
            }
        };
        this.actSort = new AbstractAction(strings.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportPartsSelectPanel.this.onSort();
            }
        };
        this.actSortByTimestamp = new AbstractAction(strings.getProperty("parts.btn.sortByTimestamp")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportPartsSelectPanel.this.onSortByTimestamp();
            }
        };
        JPanel btnPanel = new JPanel();
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        JButton btnSelectAll = new JButton(this.actSelectAll);
        btnPanel.add((Component)btnSelectAll, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        JButton btnDeselectAll = new JButton(this.actDeselectAll);
        btnPanel.add((Component)btnDeselectAll, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        JButton btnSort = new JButton(this.actSort);
        btnPanel.add((Component)btnSort, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        JButton btnSortByTimestamp = new JButton(this.actSortByTimestamp);
        btnPanel.add((Component)btnSortByTimestamp, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        this.add((Component)btnPanel, "South");
    }

    @Override
    public void onActive(ImportWizardDialog parent, ImportWizardCardPanel previousPanel) {
        String defaultPartsSetId;
        CharacterData presetImportTarget;
        CharacterData cd;
        Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents;
        CharacterData currentProfile;
        Dimension imageSize;
        this.parent = parent;
        if (previousPanel == parent.importPresetSelectPanel) {
            return;
        }
        CharacterData characterData = parent.importTypeSelectPanel.isNewProfile() ? parent.importModel.getCharacterData() : parent.current;
        int profileWidth = 0;
        int profileHeight = 0;
        if (characterData != null && (imageSize = characterData.getImageSize()) != null) {
            profileWidth = imageSize.width;
            profileHeight = imageSize.height;
        }
        this.txtProfileWidth.setText(Integer.toString(profileWidth));
        this.txtProfileHeight.setText(Integer.toString(profileHeight));
        this.profileSizePanel.revalidate();
        this.profileHeight = profileHeight;
        this.profileWidth = profileWidth;
        boolean enabled = parent.importTypeSelectPanel.isImportPartsImages();
        this.partsTable.setEnabled(enabled);
        this.actDeselectAll.setEnabled(enabled);
        this.actSelectAll.setEnabled(enabled);
        this.actSort.setEnabled(enabled);
        this.actSortByTimestamp.setEnabled(enabled);
        if (parent.importTypeSelectPanel.isNewProfile()) {
            currentProfile = null;
            partsImageContents = parent.importModel.getPartsImageContentsForNewProfile();
        } else {
            currentProfile = parent.current;
            partsImageContents = parent.importModel.getPartsImageContentsForCurrentProfile();
        }
        PartsManageData partsManageData = parent.importModel.getPartsManageData();
        this.partsTableModel.initModel(partsImageContents, partsManageData, currentProfile);
        Collection<PartsSet> partsSets = null;
        if (parent.importTypeSelectPanel.isImportPreset() && (cd = parent.importModel.getCharacterData()) != null && cd.isValid()) {
            partsSets = cd.getPartsSets().values();
        }
        if (parent.importTypeSelectPanel.isNewProfile()) {
            presetImportTarget = null;
            CharacterData cd2 = parent.importModel.getCharacterData();
            defaultPartsSetId = cd2 != null ? cd2.getDefaultPartsSetId() : null;
        } else {
            presetImportTarget = parent.current;
            defaultPartsSetId = null;
        }
        parent.importPresetSelectPanel.initModel(partsSets, defaultPartsSetId, presetImportTarget);
    }

    @Override
    public boolean isReadyPrevious() {
        return true;
    }

    @Override
    public String doPrevious() {
        this.partsTableModel.clear();
        return "importTypeSelectPanel";
    }

    @Override
    public boolean isReadyNext() {
        return this.parent != null && this.parent.importTypeSelectPanel.isImportPreset();
    }

    @Override
    public boolean isReadyFinish() {
        return this.parent != null && this.parent.importTypeSelectPanel.isImportPartsImages() && !this.parent.importTypeSelectPanel.isImportPreset();
    }

    @Override
    public String doNext() {
        return "importPresetSelectPanel";
    }

    protected void onSelectAll() {
        this.partsTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.partsTableModel.deselectAll();
    }

    protected void onSort() {
        this.partsTableModel.sort();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rct = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rct);
        }
    }

    protected void onSortByTimestamp() {
        this.partsTableModel.sortByTimestamp();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rct = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rct);
        }
    }

    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getSelectedPartsImageContents() {
        return this.partsTableModel.getSelectedPartsImageContents();
    }

    public Collection<PartsIdentifier> getImportedPartsIdentifiers() {
        HashSet<PartsIdentifier> partsIdentifiers = new HashSet<PartsIdentifier>();
        partsIdentifiers.addAll(this.partsTableModel.getCurrentProfilePartsIdentifers());
        partsIdentifiers.addAll(this.partsTableModel.getSelectedPartsIdentifiers());
        return partsIdentifiers;
    }

    public void selectByPartsIdentifiers(Collection<PartsIdentifier> partsIdentifiers) {
        this.partsTableModel.selectByPartsIdentifiers(partsIdentifiers);
    }
}

