/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.ApplicationLogger;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoriesTableModel
extends AbstractTableModelWithComboBoxModel<CategoriesTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = ApplicationLogger.getLogger();
    private static final String[] categoriesColumnName;
    private static final int[] categoriesColumnWidths;
    private int serialCounter = 1;
    private UsedCategoryDetector usedCategoryDetector;

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < categoriesColumnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(categoriesColumnWidths[idx]);
        }
    }

    public void setUsedCategoryDetector(UsedCategoryDetector usedCategoryDetector) {
        this.usedCategoryDetector = usedCategoryDetector;
    }

    public UsedCategoryDetector getUsedCategoryDetector() {
        return this.usedCategoryDetector;
    }

    public void addCategory() {
        String id = "cat" + UUID.randomUUID().toString();
        String name = "Category" + this.serialCounter++;
        CategoriesTableRow partsCategory = new CategoriesTableRow(this.serialCounter, id, name, false, 10, null);
        this.addRow(partsCategory);
    }

    public void reorder() {
        int mx = this.elements.size();
        for (int idx = 0; idx < mx; ++idx) {
            CategoriesTableRow partsCategory = (CategoriesTableRow)this.elements.get(idx);
            partsCategory.setOrder(idx + 1);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int moveDown(int rowIndex) {
        int ret = super.moveDown(rowIndex);
        this.reorder();
        return ret;
    }

    @Override
    public int moveUp(int rowIndex) {
        int ret = super.moveUp(rowIndex);
        this.reorder();
        return ret;
    }

    @Override
    public String getColumnName(int column) {
        return categoriesColumnName[column];
    }

    @Override
    public int getColumnCount() {
        return categoriesColumnName.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CategoriesTableRow partsCategory = (CategoriesTableRow)this.elements.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return partsCategory.getLocalizedCategoryName();
            }
            case 1: {
                return partsCategory.isMultipleSelectable();
            }
            case 2: {
                return partsCategory.getVisibleRows();
            }
            case 3: {
                StringBuilder layerNames = new StringBuilder();
                List<LayersTableRow> layers = null;
                if (this.usedCategoryDetector != null) {
                    layers = this.usedCategoryDetector.getLayers(partsCategory);
                }
                if (layers != null) {
                    for (LayersTableRow layer : layers) {
                        if (layerNames.length() > 0) {
                            layerNames.append(", ");
                        }
                        layerNames.append(layer.getLayerName());
                    }
                }
                return layerNames.toString();
            }
        }
        return "***";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        CategoriesTableRow partsCategory = (CategoriesTableRow)this.elements.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    partsCategory.setLocalizedCategoryName((String)aValue);
                    break;
                }
                case 1: {
                    partsCategory.setMultipleSelectable((Boolean)aValue);
                    break;
                }
                case 2: {
                    partsCategory.setVisibleRows(((Number)aValue).intValue());
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINE, "value set failed. (" + rowIndex + ", " + columnIndex + "): " + aValue, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return Boolean.class;
        }
        if (columnIndex == 2) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex >= categoriesColumnName.length - 1) {
            return false;
        }
        return this.isEditable();
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/profileditdialog");
        categoriesColumnName = new String[]{strings.getProperty("categories.column.categoryname"), strings.getProperty("categories.column.multipleselectable"), strings.getProperty("categories.column.displayrowcount"), strings.getProperty("categories.column.usedlayers")};
        categoriesColumnWidths = new int[]{Integer.parseInt(strings.getProperty("categories.column.categoryname.width")), Integer.parseInt(strings.getProperty("categories.column.multipleselectable.width")), Integer.parseInt(strings.getProperty("categories.column.displayrowcount.width")), Integer.parseInt(strings.getProperty("categories.column.usedlayers.width"))};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface UsedCategoryDetector {
        public List<LayersTableRow> getLayers(CategoriesTableRow var1);
    }
}

