if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'test_common'
end

# checkout, save, restore, remove
module TestSessionStore
	include CGIKit, TestCommon

	# abstract
	def session_store_class; end

	def setup
		@app = testapp()
		@app.session_store_class = session_store_class()
		@store = @app.session_store
		@sid = 'testsessionstore'
		@session = Session.new(@sid)
		@request = Request.new
		@context = Context.new(@request, @app)
		@context.session = @session

		@expected = {:key=>:value}
		@session.values.replace(@expected)
	end

	def test_store
		perform_save
		perform_restore
		perform_checkout
		perform_remove
	end

	def perform_save
		@store.save(@context)
		assert(exist?(@sid))
	end

	def perform_restore
		session = @store.restore(@sid, @request)
		assert_not_nil(session)
		assert_equal(@expected, session.values)
	end

	def perform_checkout
		assert_not_nil(@store.checkout(@sid, @request))
		assert_nil(@store.checkout(nil, @request))
	end

	def perform_remove
		@store.remove(@sid)
		assert(!exist?(@sid))
	end

	# abstract
	def exist?( session_id ); end
end


class TestFileSessionStore < Test::Unit::TestCase
	include TestSessionStore

	def session_store_class
		FileSessionStore
	end

	def exist?( session_id )
		FileTest.exist?(session_file_path(session_id))
	end

	def session_file_path( session_id )
		File.join(@app.tmpdir, FileSessionStore::TMPDIR, session_id)
	end
end


class TestMemorySessionStore < Test::Unit::TestCase
	include TestSessionStore

	def session_store_class
		MemorySessionStore
	end

	def exist?( session_id )
		@store.exist?(session_id)
	end
end


if __FILE__ == $0 then
	[TestFileSessionStore, TestMemorySessionStore].each do |klass|
		suite = klass.suite
		runner = Test::Unit::UI::Console::TestRunner.new suite
		runner.start
	end
end
