if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'test_common'
end


class TestResourceRequestHandler < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.resource_manager = ResourceManager.new(@app)
		@handler = ResourceRequestHandler.new(@app)
		@request = Request.new
		@request.request_handler_key = 'r'
		@request.script_name = '/cgi-bin/test.cgi'
	end

	def test_resource_url
		name = 'resource'
		expected = "http://localhost/cgi-bin/test.cgi/r?#{ResourceRequestHandler::RESOURCE_KEY}=#{name}"
		assert_equal(expected, @handler.resource_url(name, @request))
	end

	def test_handle_request
		resource = @app.sample_image_path
		@request.request_handler_path = '/r'
		@request.form_values[ResourceRequestHandler::RESOURCE_KEY] = [resource]
		@handler.handle_request(@request)
		assert(FileTest.exist?(@app.sample_image_path))
	end

	def test_handle_request_remove_resource_after
		key = 'key'
		@app.resource_manager.set_data('data', key, 'mime')
		@request.request_handler_path = '/r'
		@request.form_values[ResourceRequestHandler::RESOURCE_KEY] = [key]
		@handler.handle_request(@request)
		assert(!FileTest.exist?("tmp/resource/#{key}"))
	end
end


if __FILE__ == $0 then
	suite = TestResourceRequestHandler.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
