if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'rexml/document'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/PopupPage/PopupPage'
	require 'test_common'
end


class TestElementPopup < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = PopupPage
		@does_test_other = true
	end

	def test_api_correct
		dec = {:TestAPI => {:element=>Popup, :list=>:test, :item=>:test,
			:display=>:test, :selection=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_selection_and_selected_value
		dec = {:TestAPI => {:element=>Popup, :selection=>:test, :selected_value=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_item_and_value
		dec = {:TestAPI => {:element=>Popup, :list=>:test, :value=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_item_and_display
		dec = {:TestAPI => {:element=>Popup, :list=>:test, :display=>:test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_api_nothing_bound
		dec = {:TestAPI => {:element => Popup}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_list_and_item
		response = @app.run()
		command = Command.new(response)
		assert(PopupPage.test_list_and_item(command))
	end

	def test_selection_with_index
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(PopupPage::TEST_SELECTION_WITH_INDEX_NAME)
		select.options[index].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		assert_equal(PopupPage::TEST_LIST[index], \
			component.value_for_key(PopupPage::TEST_SELECTION))

		command = Command.new(response)
		select = command.control(PopupPage::TEST_SELECTION_WITH_INDEX_NAME)
		assert(select.options[index].selected?)
	end

	def test_selection_with_value
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(PopupPage::TEST_SELECTION_WITH_VALUE_NAME)
		select.options[index].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		assert_equal(PopupPage::TEST_LIST[index], \
			component.value_for_key(PopupPage::TEST_SELECTION))

		command = Command.new(response)
		select = command.control(PopupPage::TEST_SELECTION_WITH_VALUE_NAME)
		assert(select.options[index].selected?)
	end

	def test_selected_value_with_index
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(PopupPage::TEST_SELECTED_VALUE_WITH_INDEX_NAME)
		select.options[index].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		assert_equal(index.to_s, component.value_for_key(PopupPage::TEST_SELECTED_VALUE))

		command = Command.new(response)
		select = command.control(PopupPage::TEST_SELECTED_VALUE_WITH_INDEX_NAME)
		assert(select.options[index].selected?)
	end

	def test_selected_value_with_value
		index = 1
		response = @app.run()
		command = Command.new(response)

		select = command.control(PopupPage::TEST_SELECTED_VALUE_WITH_VALUE_NAME)
		select.options[index].selected = true
		select.form.submit_form

		response = @app.run(command)
		component = response.component
		assert_equal(PopupPage::TEST_LIST[index].object_id.to_s, \
			component.value_for_key(PopupPage::TEST_SELECTED_VALUE))

		command = Command.new(response)
		select = command.control(PopupPage::TEST_SELECTED_VALUE_WITH_VALUE_NAME)
		assert(select.options[index].selected?)
	end

	def test_enabled
		response = @app.run()
		command = Command.new(response)
		assert_equal(false, command.control(PopupPage::TEST_ENABLED_NAME).enabled?)
	end

	def test_display
		response = @app.run()
		command = Command.new(response)
		assert(PopupPage.test_display(command))
	end

	def test_default
		response = @app.run()
		command = Command.new(response)
		assert(PopupPage.test_default(command))

		select = command.control(PopupPage::TEST_DEFAULT_NAME)
		select.options[0].selected = true
		select.form.submit_form
		response = @app.run(command)
		assert_nil(response.component.value_for_key(PopupPage::TEST_SELECTION))
	end

	def test_escape
		response = @app.run
		command = Command.new(response)
		assert(PopupPage.test_escape(command))
	end

	def test_value
		response = @app.run
		command = Command.new(response)
		assert(PopupPage.test_value(command))
	end
end


if __FILE__ == $0 then
	suite = TestElementPopup.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
