if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/ConditionalPage/ConditionalPage'
	require 'test_common'
end


class TestElementConditional < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = ConditionalPage
	end

	def test_api_correct
		dec = {:TestAPI => {:element => Conditional, :condition => :test}}
		store = DeclarationStore.new_from_hash(dec)
		assert_nothing_raised { store.validate_api }
	end

	def test_api_not_bound_condition
		dec = {:TestAPI => {:element => Conditional}}
		store = DeclarationStore.new_from_hash(dec)
		assert_raises(ValidationError) { store.validate_api }
	end

	def test_condition
		response = @app.run
		command = Command.new(response)
		command.link(ConditionalPage::TEST_LINK_TO_CONDITION_TRUE_NAME).submit
		response = @app.run(command)
		assert(ConditionalPage.test_condition_true(response.content))

		command = Command.new(response)
		command.link(ConditionalPage::TEST_LINK_TO_CONDITION_FALSE_NAME).submit
		response = @app.run(command)
		assert(ConditionalPage.test_condition_false(response.content))
	end

	def test_negate
		# ready condition true
		response = @app.run
		command = Command.new(response)
		command.link(ConditionalPage::TEST_LINK_TO_CONDITION_TRUE_NAME).submit
		response = @app.run(command)
		assert(ConditionalPage.test_condition_true(response.content))

		command = Command.new(response)
		command.link(ConditionalPage::TEST_LINK_TO_NEGATE_TRUE_NAME).submit
		response = @app.run(command)
		assert(ConditionalPage.test_condition_false(response.content))

		command = Command.new(response)
		command.link(ConditionalPage::TEST_LINK_TO_NEGATE_FALSE_NAME).submit
		response = @app.run(command)
		assert(ConditionalPage.test_condition_true(response.content))
	end

end


if __FILE__ == $0 then
	suite = TestElementConditional.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
