if __FILE__ == $0
	$LOAD_PATH.unshift '../lib' 
	require 'test/unit'
	require 'test/unit/ui/console/testrunner'
	require 'cgikit'
	require 'cgikit/command'
	require 'TestApp/app'
	require 'TestApp/TextFieldPage/TextFieldPage'
	require 'TestApp/ComponentRequestHandlerPage/ComponentRequestHandlerPage'
	require 'test_common'
end


# url, session_id, context_id, 
class TestComponentRequestHandler < Test::Unit::TestCase
	include CGIKit, TestCommon

	def setup
		@app = testapp()
		@app.main = ComponentRequestHandlerPage
		@handler = ComponentRequestHandler.new(@app)
		@request = Request.new
		@cid = '0.1.2'
		@sid = 'testsessionid'
		@context = Context.new(@request, @app)
		@context.context_id = @cid
		@session = Session.new(@sid)
		@context.session = @session
		script = '/cgi-bin/test.cgi'
		@request.script_name = script
	end

	# context, path, query, secure, port
	def test_url_storing_session_id_in_url
		@session.store_in_url = false
		url = "http://localhost/cgi-bin/test.cgi/c/#@cid"
		assert_equal(url, @handler.url(@context))

		@session.store_in_url = true
		url = "http://localhost/cgi-bin/test.cgi/c/#@sid/#@cid"
		assert_equal(url, @handler.url(@context))
	end

	def test_url_complete
		@session.store_in_url = true
		query = {:key=>'value'}
		path = 'testpath'
		url = "https://localhost:8080/cgi-bin/test.cgi/c/#@sid/#@cid/#{path}?key=value"
		assert_equal(url, @handler.url(@context, path, query, true, 8080))
	end

	def test_context_id_with_session_id_and_context_id
		@request.request_handler_path = "/c/#@sid/#@cid"
		assert_equal(@cid, @handler.context_id(@request))
	end

	def test_context_id_with_context_id
		@request.request_handler_path = "/c/#@cid"
		assert_equal(@cid, @handler.context_id(@request))
	end

	def test_context_id_with_invalid_context_id
		@request.request_handler_path = '/c/$#*&(*&@@#$!'
		assert_nil(@handler.context_id(@request))
	end

	def test_handle_request_request_response_loop
		component = @app.run.component
		assert(component.did_take_values_from_request)
		assert(component.did_invoke_action)
		assert(component.did_append_to_response)
	end

	def test_handle_request_invoke_action_return_nil
		command = Command.new(@app.run)
		command[ComponentRequestHandlerPage::TEST_INVOKE_ACTION_RETURN_NIL_KEY].submit
		component = @app.run(command).component
		assert_equal(@app.main, component.class)
	end

	def test_handle_request_invoke_action_return_component
		command = Command.new(@app.run)
		command[ComponentRequestHandlerPage::TEST_INVOKE_ACTION_RETURN_COMPONENT_KEY].submit
		component = @app.run(command).component
		assert_equal(TextFieldPage, component.class)
	end

	def test_handle_request_invoke_action_return_response
		command = Command.new(@app.run)
		command[ComponentRequestHandlerPage::TEST_INVOKE_ACTION_RETURN_RESPONSE_KEY].submit
		response = @app.run(command)
		pattern = ComponentRequestHandlerPage::TEST_INVOKE_ACTION_RETURN_RESPONSE_PATTERN
		assert_match(pattern, response.content)
	end

	def test_handle_request_save_session
		response = @app.run
		command = Command.new(response)
		assert(@app.session_store.exist?(response.component.session.session_id))
	end

	def test_handle_request_return_response
		assert_kind_of(Response, @app.run)
	end

end


if __FILE__ == $0 then
	suite = TestComponentRequestHandler.suite
	runner = Test::Unit::UI::Console::TestRunner.new suite
	runner.start
end
